/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.filter;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.typesafe.config.Config;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.AvroToAvroConverterBase;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.converter.SingleRecordIterable;
import org.apache.gobblin.util.AvroUtils;
import org.apache.gobblin.util.ConfigUtils;

public class GobblinTrackingEventFlattenFilterConverter
extends AvroToAvroConverterBase {
    public static final String FIELDS_TO_FLATTEN = "fieldsToFlatten";
    public static final String NEW_SCHEMA_NAME = "outputSchemaName";
    public static final String FIELDS_RENAME_MAP = "fieldsRenameMap";
    private static final char OLD_NEW_NAME_SEPARATOR = ':';
    private Schema gobblinTrackingEventSchema;
    private Set<String> nonMapFields;
    private String mapFieldName;
    private List<Schema.Field> newFields;
    private Config config;
    private BiMap<String, String> fieldsRenameMap;

    public Converter init(WorkUnitState workUnitState) {
        try {
            this.gobblinTrackingEventSchema = new Schema.Parser().parse(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("GobblinTrackingEvent.avsc"));
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot parse GobblinTrackingEvent schema.", e);
        }
        this.config = ConfigUtils.propertiesToConfig((Properties)workUnitState.getProperties()).getConfig(((Object)((Object)this)).getClass().getSimpleName());
        List entryList = ConfigUtils.getStringList((Config)this.config, (String)FIELDS_RENAME_MAP);
        this.fieldsRenameMap = HashBiMap.create();
        for (String entry : entryList) {
            List oldNewNames = Splitter.on((char)':').omitEmptyStrings().splitToList((CharSequence)entry);
            Preconditions.checkArgument((oldNewNames.size() == 2 ? 1 : 0) != 0, (Object)"Wrong format for key fieldsRenameMap");
            this.fieldsRenameMap.put(oldNewNames.get(0), oldNewNames.get(1));
        }
        this.nonMapFields = new HashSet<String>();
        this.newFields = new ArrayList<Schema.Field>();
        ArrayList<String> mapFieldNames = new ArrayList<String>();
        for (Schema.Field field : this.gobblinTrackingEventSchema.getFields()) {
            String curFieldName = field.name();
            if (!field.schema().getType().equals((Object)Schema.Type.MAP)) {
                if (this.fieldsRenameMap.containsKey((Object)curFieldName)) {
                    this.newFields.add(new Schema.Field((String)this.fieldsRenameMap.get((Object)curFieldName), field.schema(), field.doc(), field.defaultValue()));
                } else {
                    this.newFields.add(new Schema.Field(curFieldName, field.schema(), field.doc(), field.defaultValue()));
                }
                this.nonMapFields.add(curFieldName);
                continue;
            }
            mapFieldNames.add(curFieldName);
        }
        Preconditions.checkArgument((mapFieldNames.size() == 1 ? 1 : 0) != 0, (Object)"Input schema does not match GobblinTrackingEvent.");
        this.mapFieldName = (String)mapFieldNames.get(0);
        for (String fieldToFlatten : ConfigUtils.getStringList((Config)this.config, (String)FIELDS_TO_FLATTEN)) {
            String newFieldName = this.fieldsRenameMap.containsKey((Object)fieldToFlatten) ? (String)this.fieldsRenameMap.get((Object)fieldToFlatten) : fieldToFlatten;
            this.newFields.add(new Schema.Field(newFieldName, Schema.create((Schema.Type)Schema.Type.STRING), "", null));
        }
        return this;
    }

    @Override
    public Schema convertSchema(Schema inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        Preconditions.checkArgument((boolean)inputSchema.getFields().equals(this.gobblinTrackingEventSchema.getFields()));
        Schema outputSchema = Schema.createRecord((String)ConfigUtils.getString((Config)this.config, (String)NEW_SCHEMA_NAME, (String)inputSchema.getName()), (String)inputSchema.getDoc(), (String)inputSchema.getNamespace(), (boolean)inputSchema.isError());
        outputSchema.setFields(this.newFields);
        return outputSchema;
    }

    @Override
    public Iterable<GenericRecord> convertRecord(Schema outputSchema, GenericRecord inputRecord, WorkUnitState workUnit) throws DataConversionException {
        GenericData.Record genericRecord = new GenericData.Record(outputSchema);
        BiMap inversedViewOfFieldsRenameMap = this.fieldsRenameMap.inverse();
        for (Schema.Field field : outputSchema.getFields()) {
            String originalFieldName;
            String curFieldName = field.name();
            String string = originalFieldName = inversedViewOfFieldsRenameMap.containsKey((Object)curFieldName) ? (String)inversedViewOfFieldsRenameMap.get((Object)curFieldName) : curFieldName;
            if (this.nonMapFields.contains(originalFieldName)) {
                genericRecord.put(curFieldName, inputRecord.get(originalFieldName));
                continue;
            }
            genericRecord.put(curFieldName, AvroUtils.getFieldValue((GenericRecord)inputRecord, (String)Joiner.on((char)'.').join((Object)this.mapFieldName, (Object)originalFieldName, new Object[0])).or((Object)""));
        }
        return new SingleRecordIterable<GenericData.Record>(genericRecord);
    }
}

