/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client;

import io.confluent.kafka.schemaregistry.avro.AvroCompatibilityLevel;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.avro.Schema;

public class MockSchemaRegistryClient
implements SchemaRegistryClient {
    private String defaultCompatibility = "BACKWARD";
    private final Map<String, Map<Schema, Integer>> schemaCache = new HashMap<String, Map<Schema, Integer>>();
    private final Map<Integer, Schema> idCache = new HashMap<Integer, Schema>();
    private final Map<String, Map<Schema, Integer>> versionCache = new HashMap<String, Map<Schema, Integer>>();
    private final Map<String, String> compatibilityCache = new HashMap<String, String>();
    private final AtomicInteger ids = new AtomicInteger(0);

    private int getIdFromRegistry(String subject, Schema schema) throws IOException {
        for (Map.Entry<Integer, Schema> entry : this.idCache.entrySet()) {
            if (!entry.getValue().toString().equals(schema.toString())) continue;
            this.generateVersion(subject, schema);
            return entry.getKey();
        }
        int id = this.ids.incrementAndGet();
        this.idCache.put(id, schema);
        this.generateVersion(subject, schema);
        return id;
    }

    private void generateVersion(String subject, Schema schema) {
        int currentVersion;
        Map<Object, Object> schemaVersionMap;
        ArrayList<Integer> versions = this.getAllVersions(subject);
        if (versions.isEmpty()) {
            schemaVersionMap = new IdentityHashMap();
            currentVersion = 1;
        } else {
            schemaVersionMap = this.versionCache.get(subject);
            currentVersion = versions.get(versions.size() - 1) + 1;
        }
        schemaVersionMap.put(schema, currentVersion);
        this.versionCache.put(subject, schemaVersionMap);
    }

    private ArrayList<Integer> getAllVersions(String subject) {
        ArrayList<Integer> versions = new ArrayList<Integer>();
        if (this.versionCache.containsKey(subject)) {
            versions.addAll(this.versionCache.get(subject).values());
            Collections.sort(versions);
        }
        return versions;
    }

    private Schema getSchemaByIdFromRegistry(int id) throws IOException {
        if (this.idCache.containsKey(id)) {
            return this.idCache.get(id);
        }
        throw new IOException("Cannot get schema from schema registry!");
    }

    @Override
    public synchronized int register(String subject, Schema schema) throws IOException, RestClientException {
        Map<Object, Object> schemaIdMap;
        if (this.schemaCache.containsKey(subject)) {
            schemaIdMap = this.schemaCache.get(subject);
        } else {
            schemaIdMap = new IdentityHashMap();
            this.schemaCache.put(subject, schemaIdMap);
        }
        if (schemaIdMap.containsKey(schema)) {
            return (Integer)schemaIdMap.get(schema);
        }
        int id = this.getIdFromRegistry(subject, schema);
        schemaIdMap.put(schema, id);
        return id;
    }

    @Override
    public synchronized Schema getByID(int id) throws IOException, RestClientException {
        if (this.idCache.containsKey(id)) {
            return this.idCache.get(id);
        }
        Schema schema = this.getSchemaByIdFromRegistry(id);
        this.idCache.put(id, schema);
        return schema;
    }

    private int getLatestVersion(String subject) throws IOException, RestClientException {
        ArrayList<Integer> versions = this.getAllVersions(subject);
        if (versions.isEmpty()) {
            throw new IOException("No schema registered under subject!");
        }
        return versions.get(versions.size() - 1);
    }

    @Override
    public synchronized SchemaMetadata getLatestSchemaMetadata(String subject) throws IOException, RestClientException {
        int version = this.getLatestVersion(subject);
        String schemaString = null;
        Map<Schema, Integer> schemaVersionMap = this.versionCache.get(subject);
        for (Map.Entry<Schema, Integer> entry : schemaVersionMap.entrySet()) {
            if (entry.getValue() != version) continue;
            schemaString = entry.getKey().toString();
        }
        int id = -1;
        for (Map.Entry<Integer, Schema> entry : this.idCache.entrySet()) {
            if (!entry.getValue().toString().equals(schemaString)) continue;
            id = entry.getKey();
        }
        return new SchemaMetadata(id, version, schemaString);
    }

    @Override
    public synchronized int getVersion(String subject, Schema schema) throws IOException, RestClientException {
        if (this.versionCache.containsKey(subject)) {
            return this.versionCache.get(subject).get(schema);
        }
        throw new IOException("Cannot get version from schema registry!");
    }

    @Override
    public boolean testCompatibility(String subject, Schema newSchema) throws IOException, RestClientException {
        AvroCompatibilityLevel compatibilityLevel;
        SchemaMetadata latestSchemaMetadata = this.getLatestSchemaMetadata(subject);
        Schema latestSchema = this.getSchemaByIdFromRegistry(latestSchemaMetadata.getId());
        String compatibility = this.compatibilityCache.get(subject);
        if (compatibility == null) {
            compatibility = this.defaultCompatibility;
        }
        if ((compatibilityLevel = AvroCompatibilityLevel.forName(compatibility)) == null) {
            return false;
        }
        return compatibilityLevel.compatibilityChecker.isCompatible(newSchema, latestSchema);
    }

    @Override
    public String updateCompatibility(String subject, String compatibility) throws IOException, RestClientException {
        if (subject == null) {
            this.defaultCompatibility = compatibility;
            return compatibility;
        }
        this.compatibilityCache.put(subject, compatibility);
        return compatibility;
    }

    @Override
    public String getCompatibility(String subject) throws IOException, RestClientException {
        String compatibility = this.compatibilityCache.get(subject);
        if (compatibility == null) {
            compatibility = this.defaultCompatibility;
        }
        return compatibility;
    }
}

