/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.config.store.hdfs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.gobblin.config.store.api.ConfigStoreCreationException;
import org.apache.gobblin.config.store.api.ConfigStoreFactory;
import org.apache.gobblin.config.store.hdfs.SimpleHDFSConfigStoreFactory;
import org.apache.gobblin.config.store.hdfs.SimpleHadoopFilesystemConfigStore;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public abstract class SimpleHadoopFilesystemConfigStoreFactory
implements ConfigStoreFactory<SimpleHadoopFilesystemConfigStore> {
    protected static final String SIMPLE_HDFS_SCHEME_PREFIX = "simple-";
    public static final String DEFAULT_CONFIG_NAMESPACE = SimpleHDFSConfigStoreFactory.class.getName();
    public static final String DEFAULT_STORE_URI_KEY = "default_store_uri";
    private final String physicalScheme = this.getPhysicalScheme();
    private final Config factoryConfig;
    private final URI defaultURI;
    private Optional<FileSystem> defaultFileSystem;
    private Optional<URI> defaultRootDir;

    public SimpleHadoopFilesystemConfigStoreFactory() {
        this(ConfigUtils.getConfigOrEmpty((Config)ConfigFactory.load(), (String)DEFAULT_CONFIG_NAMESPACE));
    }

    public SimpleHadoopFilesystemConfigStoreFactory(Config factoryConfig) {
        this.factoryConfig = factoryConfig;
        this.defaultURI = this.computeDefaultURI(this.factoryConfig);
    }

    private URI computeDefaultURI(Config factoryConfig) {
        if (factoryConfig.hasPath(DEFAULT_STORE_URI_KEY)) {
            String uriString = factoryConfig.getString(DEFAULT_STORE_URI_KEY);
            if (Strings.isNullOrEmpty((String)uriString)) {
                throw new IllegalArgumentException("Default store URI should be non-empty");
            }
            try {
                URI uri = new URI(uriString);
                if (uri.getScheme() == null || this.physicalScheme.equals(uri.getScheme())) {
                    return uri;
                }
            }
            catch (URISyntaxException use) {
                throw new IllegalArgumentException("Could not use default uri " + uriString);
            }
        }
        return null;
    }

    protected abstract String getPhysicalScheme();

    protected abstract FileSystem getDefaultStoreFs(Config var1, Optional<URI> var2);

    protected abstract URI getDefaultRootDir(Config var1, FileSystem var2, Optional<URI> var3);

    private synchronized FileSystem getDefaultStoreFsLazy() {
        if (this.defaultFileSystem == null) {
            this.defaultFileSystem = Optional.fromNullable((Object)this.getDefaultStoreFs(this.factoryConfig, (Optional<URI>)Optional.fromNullable((Object)this.defaultURI)));
        }
        return (FileSystem)this.defaultFileSystem.orNull();
    }

    private synchronized URI getDefaultStoreURILazy() {
        if (this.defaultRootDir == null) {
            this.defaultRootDir = Optional.fromNullable((Object)this.computeDefaultStoreURI());
        }
        return (URI)this.defaultRootDir.orNull();
    }

    private URI computeDefaultStoreURI() {
        try {
            if (this.getDefaultStoreFsLazy() == null) {
                return null;
            }
            URI defaultRoot = this.getDefaultRootDir(this.factoryConfig, this.getDefaultStoreFsLazy(), (Optional<URI>)Optional.fromNullable((Object)this.defaultURI));
            if (defaultRoot == null) {
                return null;
            }
            Path path = this.getDefaultStoreFsLazy().makeQualified(new Path(defaultRoot));
            if (!SimpleHadoopFilesystemConfigStoreFactory.isValidStoreRootPath(this.getDefaultStoreFsLazy(), path)) {
                throw new IllegalArgumentException(path + " is not a config store.");
            }
            return path.toUri();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not create a default uri for scheme " + this.getScheme(), ioe);
        }
    }

    private static boolean isValidStoreRootPath(FileSystem fs, Path storeRootPath) throws IOException {
        Path storeRoot = new Path(storeRootPath, "_CONFIG_STORE");
        return fs.exists(storeRoot);
    }

    @Override
    public String getScheme() {
        return this.getSchemePrefix() + this.getPhysicalScheme();
    }

    @Override
    public SimpleHadoopFilesystemConfigStore createConfigStore(URI configKey) throws ConfigStoreCreationException {
        FileSystem fs = this.createFileSystem(configKey);
        URI physicalStoreRoot = this.getStoreRoot(fs, configKey);
        URI logicalStoreRoot = URI.create(this.getSchemePrefix() + physicalStoreRoot);
        return new SimpleHadoopFilesystemConfigStore(fs, physicalStoreRoot, logicalStoreRoot);
    }

    protected String getSchemePrefix() {
        return SIMPLE_HDFS_SCHEME_PREFIX;
    }

    private FileSystem createFileSystem(URI configKey) throws ConfigStoreCreationException {
        try {
            return FileSystem.get((URI)this.createFileSystemURI(configKey), (Configuration)new Configuration());
        }
        catch (IOException | URISyntaxException e) {
            throw new ConfigStoreCreationException(configKey, e);
        }
    }

    private URI createFileSystemURI(URI configKey) throws URISyntaxException, IOException {
        String configKeyScheme = configKey.getScheme();
        if (!configKeyScheme.startsWith(this.getSchemePrefix())) {
            throw new IllegalArgumentException(String.format("Scheme for configKey \"%s\" must begin with \"%s\"!", configKey, this.getSchemePrefix()));
        }
        if (Strings.isNullOrEmpty((String)configKey.getAuthority())) {
            return new URI(this.getPhysicalScheme(), this.getDefaultStoreFsLazy().getUri().getAuthority(), "", "", "");
        }
        String uriPhysicalScheme = configKeyScheme.substring(this.getSchemePrefix().length(), configKeyScheme.length());
        return new URI(uriPhysicalScheme, configKey.getAuthority(), "", "", "");
    }

    private URI getStoreRoot(FileSystem fs, URI configKey) throws ConfigStoreCreationException {
        if (Strings.isNullOrEmpty((String)configKey.getAuthority())) {
            if (this.getDefaultStoreURILazy() != null) {
                return this.getDefaultStoreURILazy();
            }
            if (this.isAuthorityRequired()) {
                throw new ConfigStoreCreationException(configKey, "No default store has been configured.");
            }
        }
        for (Path path = new Path(configKey.getPath()); path != null; path = path.getParent()) {
            try {
                if (!fs.exists(path)) continue;
                for (FileStatus fileStatus : fs.listStatus(path)) {
                    if (!fileStatus.isDirectory() || !fileStatus.getPath().getName().equals("_CONFIG_STORE")) continue;
                    return fs.getUri().resolve(fileStatus.getPath().getParent().toUri());
                }
                continue;
            }
            catch (IOException e) {
                throw new ConfigStoreCreationException(configKey, e);
            }
        }
        throw new ConfigStoreCreationException(configKey, "Cannot find the store root!");
    }

    protected boolean isAuthorityRequired() {
        return true;
    }

    @VisibleForTesting
    URI getDefaultStoreURI() {
        return this.getDefaultStoreURILazy() == null ? null : this.getDefaultStoreURILazy();
    }
}

