/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.config.common.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.typesafe.config.Config;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.gobblin.config.common.impl.ConfigStoreTopologyInspector;
import org.apache.gobblin.config.common.impl.ImportTraverser;
import org.apache.gobblin.config.common.impl.SingleLinkedListConfigKeyPath;
import org.apache.gobblin.config.store.api.ConfigKeyPath;

public class InMemoryTopology
implements ConfigStoreTopologyInspector {
    private final ConfigStoreTopologyInspector fallback;
    private final Cache<ConfigKeyPath, Collection<ConfigKeyPath>> childrenMap = CacheBuilder.newBuilder().build();
    private final Cache<ConfigKeyPath, List<ConfigKeyPath>> ownImportMap = CacheBuilder.newBuilder().build();
    private final Cache<ConfigKeyPath, LinkedList<ConfigKeyPath>> recursiveImportMap = CacheBuilder.newBuilder().build();
    private final Cache<ConfigKeyPath, LinkedList<ConfigKeyPath>> recursiveImportedByMap = CacheBuilder.newBuilder().build();
    private final Cache<ConfigKeyPath, Collection<ConfigKeyPath>> ownImportedByMap = CacheBuilder.newBuilder().build();
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Access is in fact thread safe.")
    private ImmutableMultimap<ConfigKeyPath, ConfigKeyPath> fullImportedByMap = null;

    public InMemoryTopology(ConfigStoreTopologyInspector fallback) {
        this.fallback = fallback;
    }

    private synchronized void computeImportedByMap(Optional<Config> runtimeConfig) {
        if (this.fullImportedByMap != null) {
            return;
        }
        ImmutableMultimap.Builder importedByBuilder = ImmutableMultimap.builder();
        Collection<ConfigKeyPath> currentLevel = this.getChildren(SingleLinkedListConfigKeyPath.ROOT);
        List<ConfigKeyPath> rootImports = this.getOwnImports(SingleLinkedListConfigKeyPath.ROOT, runtimeConfig);
        Preconditions.checkArgument((rootImports == null || rootImports.size() == 0 ? 1 : 0) != 0, (Object)"Root can not import other nodes, otherwise circular dependency will happen");
        while (!currentLevel.isEmpty()) {
            ArrayList<ConfigKeyPath> nextLevel = new ArrayList<ConfigKeyPath>();
            for (ConfigKeyPath configKeyPath : currentLevel) {
                List<ConfigKeyPath> ownImports = this.getOwnImports(configKeyPath, runtimeConfig);
                this.ownImportMap.put((Object)configKeyPath, ownImports);
                for (ConfigKeyPath importedPath : ownImports) {
                    importedByBuilder.put((Object)importedPath, (Object)configKeyPath);
                }
                Collection<ConfigKeyPath> tmp = this.getChildren(configKeyPath);
                nextLevel.addAll(tmp);
            }
            currentLevel = nextLevel;
        }
        this.fullImportedByMap = importedByBuilder.build();
    }

    @Override
    public Collection<ConfigKeyPath> getChildren(ConfigKeyPath configKey) {
        try {
            return (Collection)this.childrenMap.get((Object)configKey, () -> this.fallback.getChildren(configKey));
        }
        catch (ExecutionException ee) {
            throw new RuntimeException(ee);
        }
    }

    @Override
    public List<ConfigKeyPath> getOwnImports(ConfigKeyPath configKey) {
        return this.getOwnImports(configKey, (Optional<Config>)Optional.absent());
    }

    @Override
    public List<ConfigKeyPath> getOwnImports(ConfigKeyPath configKey, Optional<Config> runtimeConfig) {
        try {
            return (List)this.ownImportMap.get((Object)configKey, () -> this.fallback.getOwnImports(configKey, runtimeConfig));
        }
        catch (ExecutionException ee) {
            throw new RuntimeException(ee);
        }
    }

    @Override
    public Collection<ConfigKeyPath> getImportedBy(ConfigKeyPath configKey) {
        return this.getImportedBy(configKey, (Optional<Config>)Optional.absent());
    }

    @Override
    public Collection<ConfigKeyPath> getImportedBy(ConfigKeyPath configKey, Optional<Config> runtimeConfig) {
        if (this.fullImportedByMap != null) {
            return this.fullImportedByMap.get((Object)configKey);
        }
        try {
            return (Collection)this.ownImportedByMap.get((Object)configKey, () -> this.fallback.getImportedBy(configKey, runtimeConfig));
        }
        catch (UncheckedExecutionException exc) {
            if (exc.getCause() instanceof UnsupportedOperationException) {
                this.computeImportedByMap(runtimeConfig);
                return this.getImportedBy(configKey, runtimeConfig);
            }
            throw new RuntimeException(exc);
        }
        catch (ExecutionException ee) {
            throw new RuntimeException(ee);
        }
    }

    @Override
    public List<ConfigKeyPath> getImportsRecursively(ConfigKeyPath configKey) {
        return this.getImportsRecursively(configKey, (Optional<Config>)Optional.absent());
    }

    @Override
    public List<ConfigKeyPath> getImportsRecursively(ConfigKeyPath configKey, Optional<Config> runtimeConfig) {
        return new ImportTraverser<ConfigKeyPath>(key -> {
            if (key.isRootPath()) {
                return new LinkedList();
            }
            ArrayList imports = Lists.newArrayList();
            imports.addAll(Lists.reverse(this.getOwnImports((ConfigKeyPath)key, runtimeConfig)));
            imports.add(key.getParent());
            return imports;
        }, this.recursiveImportMap).traverseGraphRecursively(configKey);
    }

    @Override
    public Collection<ConfigKeyPath> getImportedByRecursively(ConfigKeyPath configKey) {
        return this.getImportedByRecursively(configKey, (Optional<Config>)Optional.absent());
    }

    @Override
    public Collection<ConfigKeyPath> getImportedByRecursively(ConfigKeyPath configKey, Optional<Config> runtimeConfig) {
        return new ImportTraverser<ConfigKeyPath>(key -> Lists.newLinkedList(this.getImportedBy((ConfigKeyPath)key, runtimeConfig)), this.recursiveImportedByMap).traverseGraphRecursively(configKey);
    }
}

