/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.tools.compatibility;

import com.linkedin.data.message.Message;
import com.linkedin.data.schema.compatibility.CompatibilityMessage;
import com.linkedin.restli.tools.idlcheck.CompatibilityInfo;
import com.linkedin.restli.tools.idlcheck.CompatibilityLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class CompatibilityInfoMap {
    private Map<CompatibilityInfo.Level, Collection<CompatibilityInfo>> _restSpecMap = new HashMap<CompatibilityInfo.Level, Collection<CompatibilityInfo>>();
    private Map<CompatibilityInfo.Level, Collection<CompatibilityInfo>> _modelMap = new HashMap<CompatibilityInfo.Level, Collection<CompatibilityInfo>>();

    public CompatibilityInfoMap() {
        this._restSpecMap.put(CompatibilityInfo.Level.INCOMPATIBLE, new ArrayList());
        this._restSpecMap.put(CompatibilityInfo.Level.COMPATIBLE, new ArrayList());
        this._modelMap.put(CompatibilityInfo.Level.INCOMPATIBLE, new ArrayList());
        this._modelMap.put(CompatibilityInfo.Level.COMPATIBLE, new ArrayList());
    }

    public void addRestSpecInfo(CompatibilityInfo.Type infoType, Stack<Object> path, Object ... parameters) {
        this._restSpecMap.get((Object)infoType.getLevel()).add(new CompatibilityInfo(path, infoType, parameters));
    }

    public void addRestSpecInfo(Object pathTail, CompatibilityInfo.Type infoType, Stack<Object> path, Object ... parameters) {
        path.push(pathTail);
        this._restSpecMap.get((Object)infoType.getLevel()).add(new CompatibilityInfo(path, infoType, parameters));
        path.pop();
    }

    public void addRestSpecInfo(Object pathTail, CompatibilityMessage message, Stack<Object> path) {
        path.push(pathTail);
        if (message.isError()) {
            CompatibilityInfo.Type infoType = CompatibilityInfo.Type.TYPE_ERROR;
            String info = String.format(message.getFormat(), message.getArgs());
            this._restSpecMap.get((Object)infoType.getLevel()).add(new CompatibilityInfo(path, infoType, info));
        } else {
            CompatibilityInfo.Type infoType = CompatibilityInfo.Type.TYPE_INFO;
            String info = String.format(message.getFormat(), message.getArgs());
            this._restSpecMap.get((Object)infoType.getLevel()).add(new CompatibilityInfo(Arrays.asList(message.getPath()), infoType, info));
        }
        path.pop();
    }

    public void addRestSpecInfo(Message message) {
        CompatibilityInfo.Type infoType = CompatibilityInfo.Type.OTHER_ERROR;
        this._restSpecMap.get((Object)infoType.getLevel()).add(new CompatibilityInfo(Arrays.asList(message.getPath()), infoType, message.toString()));
    }

    public void addModelInfo(CompatibilityMessage message) {
        CompatibilityInfo.Type infoType;
        String infoMessage = String.format(message.getFormat(), message.getArgs());
        if (message.isError()) {
            switch (message.getImpact()) {
                case BREAKS_NEW_READER: {
                    infoType = CompatibilityInfo.Type.TYPE_BREAKS_NEW_READER;
                    break;
                }
                case BREAKS_OLD_READER: {
                    infoType = CompatibilityInfo.Type.TYPE_BREAKS_OLD_READER;
                    break;
                }
                case BREAKS_NEW_AND_OLD_READERS: {
                    infoType = CompatibilityInfo.Type.TYPE_BREAKS_NEW_AND_OLD_READERS;
                    break;
                }
                default: {
                    infoType = CompatibilityInfo.Type.OTHER_ERROR;
                    break;
                }
            }
        } else {
            infoType = CompatibilityInfo.Type.TYPE_INFO;
        }
        CompatibilityInfo info = new CompatibilityInfo(Arrays.asList(message.getPath()), infoType, infoMessage);
        this._modelMap.get((Object)infoType.getLevel()).add(info);
    }

    public String createSummary(String prevRestModelPath, String currRestModelPath) {
        StringBuilder summaryMessage = new StringBuilder();
        CompatibilityInfoMap.createSummaryForInfo(this.getIncompatibles(), "Incompatible changes", summaryMessage);
        CompatibilityInfoMap.createSummaryForInfo(this.getCompatibles(), "Compatible changes", summaryMessage);
        if (summaryMessage.length() != 0) {
            summaryMessage.insert(0, new StringBuilder("\nRest.li compatibility report between published \"").append(prevRestModelPath).append("\" and current \"").append(currRestModelPath).append("\":\n"));
        }
        return summaryMessage.toString();
    }

    public String createSummary() {
        StringBuilder summaryMessage = new StringBuilder();
        CompatibilityInfoMap.createSummaryForInfo(this.getIncompatibles(), "Incompatible changes", summaryMessage);
        CompatibilityInfoMap.createSummaryForInfo(this.getCompatibles(), "Compatible changes", summaryMessage);
        if (summaryMessage.length() != 0) {
            summaryMessage.insert(0, "\nidl compatibility report:\n");
        }
        return summaryMessage.toString();
    }

    private static void createSummaryForInfo(Collection<CompatibilityInfo> info, String description, StringBuilder summaryMessage) {
        if (info.isEmpty()) {
            return;
        }
        summaryMessage.append(description).append(":\n");
        int issueIndex = 1;
        for (CompatibilityInfo i : info) {
            summaryMessage.append("  ").append(issueIndex).append(") ").append(i.toString()).append("\n");
            ++issueIndex;
        }
    }

    public boolean isCompatible(CompatibilityLevel level) {
        Collection<CompatibilityInfo> incompatibles = this.getIncompatibles();
        Collection<CompatibilityInfo> compatibles = this.getCompatibles();
        return this.isCompatible(incompatibles, compatibles, level);
    }

    public boolean isRestSpecCompatible(CompatibilityLevel level) {
        Collection<CompatibilityInfo> incompatibles = this.getRestSpecIncompatibles();
        Collection<CompatibilityInfo> compatibles = this.getRestSpecCompatibles();
        return this.isCompatible(incompatibles, compatibles, level);
    }

    public boolean isModelCompatible(CompatibilityLevel level) {
        Collection<CompatibilityInfo> incompatibles = this.getModelIncompatibles();
        Collection<CompatibilityInfo> compatibles = this.getModelCompatibles();
        return this.isCompatible(incompatibles, compatibles, level);
    }

    private boolean isCompatible(Collection<CompatibilityInfo> incompatibles, Collection<CompatibilityInfo> compatibles, CompatibilityLevel level) {
        return !(!incompatibles.isEmpty() && level.ordinal() >= CompatibilityLevel.BACKWARDS.ordinal() || !compatibles.isEmpty() && level.ordinal() >= CompatibilityLevel.EQUIVALENT.ordinal());
    }

    public boolean isEquivalent() {
        return this.isCompatible(CompatibilityLevel.EQUIVALENT);
    }

    public boolean isRestSpecEquivalent() {
        return this.isRestSpecCompatible(CompatibilityLevel.EQUIVALENT);
    }

    public boolean isModelEquivalent() {
        return this.isModelCompatible(CompatibilityLevel.EQUIVALENT);
    }

    public Collection<CompatibilityInfo> getIncompatibles() {
        return this.get(CompatibilityInfo.Level.INCOMPATIBLE);
    }

    public Collection<CompatibilityInfo> getCompatibles() {
        return this.get(CompatibilityInfo.Level.COMPATIBLE);
    }

    public Collection<CompatibilityInfo> getRestSpecIncompatibles() {
        return this.getRestSpecInfo(CompatibilityInfo.Level.INCOMPATIBLE);
    }

    public Collection<CompatibilityInfo> getRestSpecCompatibles() {
        return this.getRestSpecInfo(CompatibilityInfo.Level.COMPATIBLE);
    }

    public Collection<CompatibilityInfo> getModelIncompatibles() {
        return this.getModelInfo(CompatibilityInfo.Level.INCOMPATIBLE);
    }

    public Collection<CompatibilityInfo> getModelCompatibles() {
        return this.getModelInfo(CompatibilityInfo.Level.COMPATIBLE);
    }

    public Collection<CompatibilityInfo> get(CompatibilityInfo.Level level) {
        ArrayList<CompatibilityInfo> infos = new ArrayList<CompatibilityInfo>(this.getRestSpecInfo(level));
        infos.addAll(this.getModelInfo(level));
        return infos;
    }

    public Collection<CompatibilityInfo> getRestSpecInfo(CompatibilityInfo.Level level) {
        return this._restSpecMap.get((Object)level);
    }

    public Collection<CompatibilityInfo> getModelInfo(CompatibilityInfo.Level level) {
        return this._modelMap.get((Object)level);
    }

    public boolean addAll(CompatibilityInfoMap other) {
        for (Map.Entry<CompatibilityInfo.Level, Collection<CompatibilityInfo>> entry : this._restSpecMap.entrySet()) {
            entry.getValue().addAll(other.getRestSpecInfo(entry.getKey()));
        }
        for (Map.Entry<CompatibilityInfo.Level, Collection<CompatibilityInfo>> entry : this._modelMap.entrySet()) {
            entry.getValue().addAll(other.getModelInfo(entry.getKey()));
        }
        return true;
    }
}

