/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.tools;

import com.linkedin.restli.internal.server.model.ResourceModelEncoder;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public final class AdditionalDocProvidersUtil {
    private AdditionalDocProvidersUtil() {
    }

    public static List<ResourceModelEncoder.DocsProvider> findDocProviders(Logger log, boolean loadAdditionalDocProviders) {
        ArrayList<ResourceModelEncoder.DocsProvider> providers = new ArrayList<ResourceModelEncoder.DocsProvider>();
        if (loadAdditionalDocProviders) {
            try {
                providers.add((ResourceModelEncoder.DocsProvider)Class.forName("com.linkedin.restli.tools.scala.ScalaDocsProvider").newInstance());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ignored) {
                log.warn("Attempted to load ScalaDocsProvider but it was not found. Please add 'com.linkedin.pegasus:restli-tools-scala_<scala-version>:<pegasus-version>' to your classpath.");
            }
            catch (Throwable t) {
                log.info("Failed to initialize ScalaDocsProvider class", t);
            }
        }
        return providers;
    }
}

