/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.crypto;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.security.KeyStoreException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.crypto.JCEKSKeystoreCredentialStore;
import org.apache.gobblin.runtime.cli.CliApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="keystore", description="Examine JCE Keystore files")
public class JCEKSKeystoreCredentialStoreCli
implements CliApplication {
    private static final Logger log = LoggerFactory.getLogger(JCEKSKeystoreCredentialStoreCli.class);
    private static final Map<String, Action> actionMap = ImmutableMap.of((Object)"generate_keys", (Object)new GenerateKeyAction(), (Object)"list_keys", (Object)new ListKeysAction(), (Object)"help", (Object)new HelpAction(), (Object)"export", (Object)new ExportKeyAction());

    public void run(String[] args) {
        if (args.length < 2) {
            System.out.println("Must specify an action!");
            new HelpAction().run(args);
            return;
        }
        String actionStr = args[1];
        Action action = actionMap.get(actionStr);
        if (action == null) {
            System.out.println("Action " + actionStr + " unknown!");
            new HelpAction().run(args);
            return;
        }
        action.run(Arrays.copyOfRange(args, 1, args.length));
    }

    public static JCEKSKeystoreCredentialStore loadKeystore(String path) throws IOException {
        char[] password = JCEKSKeystoreCredentialStoreCli.getPasswordFromConsole();
        return new JCEKSKeystoreCredentialStore(path, String.valueOf(password));
    }

    public static char[] getPasswordFromConsole() {
        System.out.print("Please enter the keystore password: ");
        return System.console().readPassword();
    }

    static class ExportKeyAction
    extends Action {
        private static final Option KEYSTORE_LOCATION = Option.builder((String)"i").longOpt("in").hasArg().required().desc("Keystore location").build();
        private static final Option OUTPUT_LOCATION = Option.builder((String)"o").longOpt("out").hasArg().required().desc("Output location").build();

        ExportKeyAction() {
        }

        @Override
        protected List<Option> getExtraOptions() {
            return ImmutableList.of((Object)KEYSTORE_LOCATION, (Object)OUTPUT_LOCATION);
        }

        @Override
        void run(String[] args) {
            try {
                CommandLine cli = this.parseOptions(args);
                JCEKSKeystoreCredentialStore credStore = JCEKSKeystoreCredentialStoreCli.loadKeystore(cli.getOptionValue(KEYSTORE_LOCATION.getOpt()));
                HashMap<Integer, String> base64Keys = new HashMap<Integer, String>();
                Map keys = credStore.getAllEncodedKeys();
                for (Map.Entry e : keys.entrySet()) {
                    base64Keys.put(Integer.valueOf((String)e.getKey()), DatatypeConverter.printBase64Binary((byte[])((byte[])e.getValue())));
                }
                OutputStreamWriter fOs = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(cli.getOptionValue(OUTPUT_LOCATION.getOpt()))), StandardCharsets.UTF_8);
                Gson gson = new GsonBuilder().disableHtmlEscaping().create();
                fOs.write(gson.toJson(base64Keys));
                fOs.flush();
                fOs.close();
            }
            catch (ParseException e) {
                this.printUsage();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class GenerateKeyAction
    extends Action {
        private static final Option KEYSTORE_LOCATION = Option.builder((String)"o").longOpt("out").hasArg().desc("Keystore location").build();
        private static final Option NUM_KEYS = Option.builder((String)"n").longOpt("numKeys").hasArg().desc("# of keys to generate").build();
        private static final List<Option> OPTIONS = ImmutableList.of((Object)KEYSTORE_LOCATION, (Object)NUM_KEYS);

        GenerateKeyAction() {
        }

        @Override
        protected List<Option> getExtraOptions() {
            return OPTIONS;
        }

        @Override
        void run(String[] args) {
            try {
                CommandLine cli = this.parseOptions(args);
                if (!this.paramsAreValid(cli)) {
                    return;
                }
                int numKeys = Integer.parseInt(cli.getOptionValue(NUM_KEYS.getOpt(), "20"));
                char[] password = JCEKSKeystoreCredentialStoreCli.getPasswordFromConsole();
                String keystoreLocation = cli.getOptionValue(KEYSTORE_LOCATION.getOpt());
                JCEKSKeystoreCredentialStore credentialStore = new JCEKSKeystoreCredentialStore(cli.getOptionValue(KEYSTORE_LOCATION.getOpt()), String.valueOf(password), EnumSet.of(JCEKSKeystoreCredentialStore.CreationOptions.CREATE_IF_MISSING));
                credentialStore.generateAesKeys(numKeys, 0);
                System.out.println("Generated " + String.valueOf(numKeys) + " keys at " + keystoreLocation);
            }
            catch (IOException | KeyStoreException e) {
                throw new RuntimeException(e);
            }
            catch (ParseException e) {
                System.out.println("Unknown command line params " + e.toString());
                this.printUsage();
            }
        }

        private boolean paramsAreValid(CommandLine cli) {
            if (cli.hasOption(HELP.getOpt())) {
                this.printUsage();
                return false;
            }
            if (!cli.hasOption(KEYSTORE_LOCATION.getOpt())) {
                System.out.println("Must specify keystore location!");
                this.printUsage();
                return false;
            }
            return true;
        }
    }

    static class ListKeysAction
    extends Action {
        private static final Option KEYSTORE_LOCATION = Option.builder((String)"o").longOpt("out").hasArg().desc("Keystore location").build();
        private static final List<Option> options = ImmutableList.of((Object)KEYSTORE_LOCATION);

        ListKeysAction() {
        }

        @Override
        protected List<Option> getExtraOptions() {
            return options;
        }

        @Override
        void run(String[] args) {
            try {
                CommandLine cli = this.parseOptions(args);
                if (!this.paramsAreValid(cli)) {
                    return;
                }
                String keystoreLocation = cli.getOptionValue(KEYSTORE_LOCATION.getOpt());
                JCEKSKeystoreCredentialStore credentialStore = JCEKSKeystoreCredentialStoreCli.loadKeystore(keystoreLocation);
                Map keys = credentialStore.getAllEncodedKeys();
                System.out.println("Keystore " + keystoreLocation + " has " + String.valueOf(keys.size()) + " keys.");
            }
            catch (IOException | ParseException e) {
                throw new RuntimeException(e);
            }
        }

        private boolean paramsAreValid(CommandLine cli) {
            if (cli.hasOption(HELP.getOpt())) {
                this.printUsage();
                return false;
            }
            if (!cli.hasOption(KEYSTORE_LOCATION.getOpt())) {
                System.out.println("Must specify keystore location!");
                this.printUsage();
                return false;
            }
            return true;
        }
    }

    static class HelpAction
    extends Action {
        HelpAction() {
        }

        @Override
        protected List<Option> getExtraOptions() {
            return Collections.emptyList();
        }

        @Override
        void run(String[] args) {
            System.out.println("You can run <actionName> -h to see valid flags for a given action");
            for (String validAction : actionMap.keySet()) {
                System.out.println(validAction);
            }
        }
    }

    static abstract class Action {
        protected static final Option HELP = Option.builder((String)"h").longOpt("help").desc("Print usage").build();

        Action() {
        }

        protected abstract List<Option> getExtraOptions();

        abstract void run(String[] var1);

        protected void printUsage() {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("Options", this.getOptions());
        }

        protected CommandLine parseOptions(String[] args) throws ParseException {
            DefaultParser parser = new DefaultParser();
            return parser.parse(this.getOptions(), args);
        }

        private Options getOptions() {
            List<Option> options = this.getExtraOptions();
            Options optionList = new Options();
            optionList.addOption(HELP);
            for (Option o : options) {
                optionList.addOption(o);
            }
            return optionList;
        }
    }
}

