/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.crypto;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.codec.StreamCodec;
import org.apache.gobblin.crypto.Base64KeyToStringCodec;
import org.apache.gobblin.crypto.CredentialStore;
import org.apache.gobblin.crypto.CredentialStoreFactory;
import org.apache.gobblin.crypto.CredentialStoreProvider;
import org.apache.gobblin.crypto.EncryptionConfigParser;
import org.apache.gobblin.crypto.EncryptionProvider;
import org.apache.gobblin.crypto.GPGCodec;
import org.apache.gobblin.crypto.HexKeyToStringCodec;
import org.apache.gobblin.crypto.JCEKSKeystoreCredentialStore;
import org.apache.gobblin.crypto.JsonCredentialStore;
import org.apache.gobblin.crypto.KeyToStringCodec;
import org.apache.gobblin.crypto.RotatingAESCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class GobblinEncryptionProvider
implements CredentialStoreProvider,
EncryptionProvider {
    private static final Logger log = LoggerFactory.getLogger(GobblinEncryptionProvider.class);
    private static final Set<String> SUPPORTED_STREAMING_ALGORITHMS = ImmutableSet.of((Object)"aes_rotating", (Object)"any");

    public static Set<String> supportedStreamingAlgorithms() {
        return SUPPORTED_STREAMING_ALGORITHMS;
    }

    public StreamCodec buildStreamEncryptor(Map<String, Object> parameters) {
        String encryptionType = EncryptionConfigParser.getEncryptionType(parameters);
        if (encryptionType == null) {
            throw new IllegalArgumentException("Encryption type not present in parameters!");
        }
        return this.buildStreamCryptoProvider(encryptionType, parameters);
    }

    public StreamCodec buildStreamCryptoProvider(String algorithm, Map<String, Object> parameters) {
        switch (algorithm) {
            case "any": 
            case "aes_rotating": {
                CredentialStore cs = CredentialStoreFactory.buildCredentialStore(parameters);
                if (cs == null) {
                    throw new IllegalArgumentException("Failed to build credential store; can't instantiate AES");
                }
                return new RotatingAESCodec(cs);
            }
            case "gpg": {
                String password = EncryptionConfigParser.getKeystorePassword(parameters);
                Preconditions.checkNotNull((Object)password, (Object)"Must specify an en/decryption password for GPGCodec!");
                return new GPGCodec(password);
            }
        }
        log.debug("Do not support encryption type {}", (Object)algorithm);
        return null;
    }

    public CredentialStore buildCredentialStore(Map<String, Object> parameters) {
        String ks_type = EncryptionConfigParser.getKeystoreType(parameters);
        String ks_path = EncryptionConfigParser.getKeystorePath(parameters);
        String ks_password = EncryptionConfigParser.getKeystorePassword(parameters);
        try {
            switch (ks_type) {
                case "java": {
                    return new JCEKSKeystoreCredentialStore(ks_path, ks_password);
                }
                case "json": {
                    return new JsonCredentialStore(ks_path, this.buildKeyToStringCodec(parameters));
                }
            }
            return null;
        }
        catch (IOException e) {
            log.error("Error building credential store, returning null", (Throwable)e);
            return null;
        }
    }

    private KeyToStringCodec buildKeyToStringCodec(Map<String, Object> parameters) {
        String encodingName;
        switch (encodingName = EncryptionConfigParser.getKeystoreEncoding(parameters)) {
            case "hex": {
                return new HexKeyToStringCodec();
            }
            case "base64": {
                return new Base64KeyToStringCodec();
            }
        }
        throw new IllegalArgumentException("Don't know how to build key to string codec for type " + encodingName);
    }
}

