/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateAddColCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateAddColScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateAddScalarCol;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@Description(name="date_add", value="_FUNC_(start_date, num_days) - Returns the date that is num_days after start_date.", extended="start_date is a string in the format 'yyyy-MM-dd HH:mm:ss' or 'yyyy-MM-dd'. num_days is a number. The time part of start_date is ignored.\nExample:\n   > SELECT _FUNC_('2009-30-07', 1) FROM src LIMIT 1;\n  '2009-31-07'")
@VectorizedExpressions(value={VectorUDFDateAddColScalar.class, VectorUDFDateAddScalarCol.class, VectorUDFDateAddColCol.class})
public class GenericUDFDateAdd
extends GenericUDF {
    private transient SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private transient PrimitiveObjectInspectorConverter.TimestampConverter timestampConverter;
    private transient ObjectInspectorConverters.Converter textConverter;
    private transient ObjectInspectorConverters.Converter dateWritableConverter;
    private transient ObjectInspectorConverters.Converter intWritableConverter;
    private transient PrimitiveObjectInspector.PrimitiveCategory inputType1;
    private transient PrimitiveObjectInspector.PrimitiveCategory inputType2;
    private final Calendar calendar = Calendar.getInstance();
    private final Text output = new Text();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("date_add() requires 2 argument, got " + arguments.length);
        }
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + arguments[0].getTypeName() + " is passed. as first arguments");
        }
        if (arguments[1].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(1, "Only primitive type arguments are accepted but " + arguments[2].getTypeName() + " is passed. as second arguments");
        }
        this.inputType1 = ((PrimitiveObjectInspector)arguments[0]).getPrimitiveCategory();
        WritableStringObjectInspector outputOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        switch (this.inputType1) {
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                this.inputType1 = PrimitiveObjectInspector.PrimitiveCategory.STRING;
                this.textConverter = ObjectInspectorConverters.getConverter((ObjectInspector)((PrimitiveObjectInspector)arguments[0]), (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
                break;
            }
            case TIMESTAMP: {
                this.timestampConverter = new PrimitiveObjectInspectorConverter.TimestampConverter((PrimitiveObjectInspector)arguments[0], (SettableTimestampObjectInspector)PrimitiveObjectInspectorFactory.writableTimestampObjectInspector);
                break;
            }
            case DATE: {
                this.dateWritableConverter = ObjectInspectorConverters.getConverter((ObjectInspector)((PrimitiveObjectInspector)arguments[0]), (ObjectInspector)PrimitiveObjectInspectorFactory.writableDateObjectInspector);
                break;
            }
            default: {
                throw new UDFArgumentException(" DATE_ADD() only takes STRING/TIMESTAMP/DATEWRITABLE types as first argument, got " + this.inputType1);
            }
        }
        this.inputType2 = ((PrimitiveObjectInspector)arguments[1]).getPrimitiveCategory();
        if (this.inputType2 != PrimitiveObjectInspector.PrimitiveCategory.INT) {
            throw new UDFArgumentException(" DATE_ADD() only takes INT types as second  argument, got " + this.inputType2);
        }
        this.intWritableConverter = ObjectInspectorConverters.getConverter((ObjectInspector)((PrimitiveObjectInspector)arguments[1]), (ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector);
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (arguments[0].get() == null) {
            return null;
        }
        IntWritable toBeAdded = (IntWritable)this.intWritableConverter.convert(arguments[1].get());
        if (toBeAdded == null) {
            return null;
        }
        switch (this.inputType1) {
            case STRING: {
                String dateString = this.textConverter.convert(arguments[0].get()).toString();
                try {
                    this.calendar.setTime(this.formatter.parse(dateString.toString()));
                    this.calendar.add(5, toBeAdded.get());
                    break;
                }
                catch (ParseException e) {
                    return null;
                }
            }
            case TIMESTAMP: {
                Timestamp ts = ((TimestampWritable)this.timestampConverter.convert(arguments[0].get())).getTimestamp();
                this.calendar.setTime(ts);
                this.calendar.add(5, toBeAdded.get());
                break;
            }
            case DATE: {
                DateWritable dw = (DateWritable)this.dateWritableConverter.convert(arguments[0].get());
                this.calendar.setTime(dw.get());
                this.calendar.add(5, toBeAdded.get());
                break;
            }
            default: {
                throw new UDFArgumentException("DATE_ADD() only takes STRING/TIMESTAMP/DATEWRITABLE types, got " + this.inputType1);
            }
        }
        Date newDate = this.calendar.getTime();
        this.output.set(this.formatter.format(newDate));
        return this.output;
    }

    @Override
    public String getDisplayString(String[] children) {
        StringBuilder sb = new StringBuilder();
        sb.append("date_add(");
        if (children.length > 0) {
            sb.append(children[0]);
            for (int i = 1; i < children.length; ++i) {
                sb.append(", ");
                sb.append(children[i]);
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

