/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.ReflectionUtils;

public class ReduceWork
extends BaseWork {
    private static final transient Log LOG = LogFactory.getLog(ReduceWork.class);
    private TableDesc keyDesc;
    private List<TableDesc> tagToValueDesc = new ArrayList<TableDesc>();
    private Operator<?> reducer;
    private Integer numReduceTasks;
    private boolean needsTagging;
    private Map<Integer, String> tagToInput = new HashMap<Integer, String>();
    private boolean isAutoReduceParallelism;
    private int minReduceTasks;
    private int maxReduceTasks;
    private ObjectInspector keyObjectInspector = null;
    private ObjectInspector valueObjectInspector = null;

    public ReduceWork() {
    }

    public ReduceWork(String name) {
        super(name);
    }

    public void setKeyDesc(TableDesc keyDesc) {
        this.keyDesc = keyDesc;
    }

    public TableDesc getKeyDesc() {
        return this.keyDesc;
    }

    private ObjectInspector getObjectInspector(TableDesc desc) {
        ObjectInspector objectInspector;
        try {
            Deserializer deserializer = (Deserializer)ReflectionUtils.newInstance(desc.getDeserializerClass(), null);
            SerDeUtils.initializeSerDe((Deserializer)deserializer, null, (Properties)desc.getProperties(), null);
            objectInspector = deserializer.getObjectInspector();
        }
        catch (Exception e) {
            return null;
        }
        return objectInspector;
    }

    public ObjectInspector getKeyObjectInspector() {
        if (this.keyObjectInspector == null) {
            this.keyObjectInspector = this.getObjectInspector(this.keyDesc);
        }
        return this.keyObjectInspector;
    }

    public ObjectInspector getValueObjectInspector() {
        if (this.needsTagging) {
            return null;
        }
        if (this.valueObjectInspector == null) {
            this.valueObjectInspector = this.getObjectInspector(this.tagToValueDesc.get(0));
        }
        return this.valueObjectInspector;
    }

    public List<TableDesc> getTagToValueDesc() {
        return this.tagToValueDesc;
    }

    public void setTagToValueDesc(List<TableDesc> tagToValueDesc) {
        this.tagToValueDesc = tagToValueDesc;
    }

    @Explain(displayName="Execution mode")
    public String getVectorModeOn() {
        return this.vectorMode ? "vectorized" : null;
    }

    @Explain(displayName="Reduce Operator Tree")
    public Operator<?> getReducer() {
        return this.reducer;
    }

    public void setReducer(Operator<?> reducer) {
        this.reducer = reducer;
    }

    @Explain(displayName="Needs Tagging", normalExplain=false)
    public boolean getNeedsTagging() {
        return this.needsTagging;
    }

    public void setNeedsTagging(boolean needsTagging) {
        this.needsTagging = needsTagging;
    }

    public void setTagToInput(Map<Integer, String> tagToInput) {
        this.tagToInput = tagToInput;
    }

    public Map<Integer, String> getTagToInput() {
        return this.tagToInput;
    }

    @Override
    public void replaceRoots(Map<Operator<?>, Operator<?>> replacementMap) {
        this.setReducer(replacementMap.get(this.getReducer()));
    }

    @Override
    public Set<Operator<?>> getAllRootOperators() {
        LinkedHashSet opSet = new LinkedHashSet();
        opSet.add(this.getReducer());
        return opSet;
    }

    public Integer getNumReduceTasks() {
        return this.numReduceTasks;
    }

    public void setNumReduceTasks(Integer numReduceTasks) {
        this.numReduceTasks = numReduceTasks;
    }

    @Override
    public void configureJobConf(JobConf job) {
        if (this.reducer != null) {
            for (FileSinkOperator fs : OperatorUtils.findOperators(this.reducer, FileSinkOperator.class)) {
                PlanUtils.configureJobConf(((FileSinkDesc)fs.getConf()).getTableInfo(), job);
            }
        }
    }

    public void setAutoReduceParallelism(boolean isAutoReduceParallelism) {
        this.isAutoReduceParallelism = isAutoReduceParallelism;
    }

    public boolean isAutoReduceParallelism() {
        return this.isAutoReduceParallelism;
    }

    public void setMinReduceTasks(int minReduceTasks) {
        this.minReduceTasks = minReduceTasks;
    }

    public int getMinReduceTasks() {
        return this.minReduceTasks;
    }

    public int getMaxReduceTasks() {
        return this.maxReduceTasks;
    }

    public void setMaxReduceTasks(int maxReduceTasks) {
        this.maxReduceTasks = maxReduceTasks;
    }
}

