/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.optiq.translator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.hydromatic.avatica.ByteString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.type.Decimal128;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.optimizer.optiq.OptiqSemanticException;
import org.apache.hadoop.hive.ql.optimizer.optiq.translator.SqlFunctionConverter;
import org.apache.hadoop.hive.ql.optimizer.optiq.translator.TypeConverter;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeNullDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseCompare;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseNumeric;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToBinary;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToChar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDecimal;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToVarchar;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlCastFunction;
import org.eigenbase.sql.type.SqlTypeName;

public class RexNodeConverter {
    private static final Log LOG = LogFactory.getLog(RexNodeConverter.class);
    private final RelOptCluster cluster;
    private final ImmutableList<InputCtx> inputCtxs;
    private final boolean flattenExpr;
    private static final BigInteger MIN_LONG_BI = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger MAX_LONG_BI = BigInteger.valueOf(Long.MAX_VALUE);

    public RexNodeConverter(RelOptCluster cluster, RelDataType inpDataType, ImmutableMap<String, Integer> nameToPosMap, int offset, boolean flattenExpr) {
        this.cluster = cluster;
        this.inputCtxs = ImmutableList.of((Object)new InputCtx(inpDataType, nameToPosMap, null, offset));
        this.flattenExpr = flattenExpr;
    }

    public RexNodeConverter(RelOptCluster cluster, List<InputCtx> inpCtxLst, boolean flattenExpr) {
        this.cluster = cluster;
        this.inputCtxs = ImmutableList.builder().addAll(inpCtxLst).build();
        this.flattenExpr = flattenExpr;
    }

    public RexNode convert(ExprNodeDesc expr) throws SemanticException {
        if (expr instanceof ExprNodeNullDesc) {
            return this.createNullLiteral(expr);
        }
        if (expr instanceof ExprNodeGenericFuncDesc) {
            return this.convert((ExprNodeGenericFuncDesc)expr);
        }
        if (expr instanceof ExprNodeConstantDesc) {
            return this.convert((ExprNodeConstantDesc)expr);
        }
        if (expr instanceof ExprNodeColumnDesc) {
            return this.convert((ExprNodeColumnDesc)expr);
        }
        if (expr instanceof ExprNodeFieldDesc) {
            return this.convert((ExprNodeFieldDesc)expr);
        }
        throw new RuntimeException("Unsupported Expression");
    }

    private RexNode convert(ExprNodeFieldDesc fieldDesc) throws SemanticException {
        RexNode rexNode = this.convert(fieldDesc.getDesc());
        if (rexNode instanceof RexCall) {
            return this.cluster.getRexBuilder().makeFieldAccess(rexNode, fieldDesc.getFieldName(), true);
        }
        throw new OptiqSemanticException("Unexpected rexnode : " + rexNode.getClass().getCanonicalName());
    }

    private RexNode convert(ExprNodeGenericFuncDesc func) throws SemanticException {
        boolean isCompare;
        LinkedList<RexNode> childRexNodeLst = new LinkedList<RexNode>();
        ImmutableList.Builder argTypeBldr = ImmutableList.builder();
        TypeInfo tgtDT = null;
        GenericUDF tgtUdf = func.getGenericUDF();
        boolean isNumeric = tgtUdf instanceof GenericUDFBaseNumeric;
        boolean bl = isCompare = !isNumeric && tgtUdf instanceof GenericUDFBaseCompare;
        if (isNumeric) {
            tgtDT = func.getTypeInfo();
            assert (func.getChildren().size() == 2);
        } else if (isCompare && func.getChildren().size() == 2) {
            tgtDT = FunctionRegistry.getCommonClassForComparison(func.getChildren().get(0).getTypeInfo(), func.getChildren().get(1).getTypeInfo());
        }
        Iterator<ExprNodeDesc> i$ = func.getChildren().iterator();
        while (i$.hasNext()) {
            ExprNodeDesc childExpr;
            ExprNodeDesc tmpExprNode = childExpr = i$.next();
            if (tgtDT != null && TypeInfoUtils.isConversionRequiredForComparison((TypeInfo)tgtDT, (TypeInfo)childExpr.getTypeInfo())) {
                if (isCompare) {
                    tmpExprNode = ParseUtils.createConversionCast(childExpr, (PrimitiveTypeInfo)tgtDT);
                } else if (isNumeric) {
                    GenericUDFBaseNumeric numericUdf = (GenericUDFBaseNumeric)tgtUdf;
                    PrimitiveTypeInfo minArgType = numericUdf.deriveMinArgumentCast(childExpr, tgtDT);
                    tmpExprNode = ParseUtils.createConversionCast(childExpr, minArgType);
                } else {
                    throw new AssertionError((Object)("Unexpected " + tgtDT + " - not a numeric op or compare"));
                }
            }
            argTypeBldr.add((Object)TypeConverter.convert(tmpExprNode.getTypeInfo(), this.cluster.getTypeFactory()));
            RexNode tmpRN = this.convert(tmpExprNode);
            childRexNodeLst.add(tmpRN);
        }
        RexNode expr = null;
        RelDataType retType = null;
        expr = this.handleExplicitCast(func, childRexNodeLst);
        if (expr == null) {
            retType = TypeConverter.convert(func.getTypeInfo(), this.cluster.getTypeFactory());
            SqlOperator optiqOp = SqlFunctionConverter.getOptiqOperator(func.getFuncText(), func.getGenericUDF(), (ImmutableList<RelDataType>)argTypeBldr.build(), retType);
            expr = this.cluster.getRexBuilder().makeCall(optiqOp, childRexNodeLst);
        } else {
            retType = expr.getType();
        }
        if (this.flattenExpr && expr instanceof RexCall && !(((RexCall)expr).getOperator() instanceof SqlCastFunction)) {
            RexCall call = (RexCall)expr;
            expr = this.cluster.getRexBuilder().makeCall(retType, call.getOperator(), RexUtil.flatten((List)call.getOperands(), (SqlOperator)call.getOperator()));
        }
        return expr;
    }

    private boolean castExprUsingUDFBridge(GenericUDF gUDF) {
        int sp;
        String udfClassName;
        boolean castExpr = false;
        if (gUDF != null && gUDF instanceof GenericUDFBridge && (udfClassName = ((GenericUDFBridge)gUDF).getUdfClassName()) != null && (sp = udfClassName.lastIndexOf(46)) >= 0 & sp + 1 < udfClassName.length() && ((udfClassName = udfClassName.substring(sp + 1)).equals("UDFToBoolean") || udfClassName.equals("UDFToByte") || udfClassName.equals("UDFToDouble") || udfClassName.equals("UDFToInteger") || udfClassName.equals("UDFToLong") || udfClassName.equals("UDFToShort") || udfClassName.equals("UDFToFloat") || udfClassName.equals("UDFToString"))) {
            castExpr = true;
        }
        return castExpr;
    }

    private RexNode handleExplicitCast(ExprNodeGenericFuncDesc func, List<RexNode> childRexNodeLst) throws OptiqSemanticException {
        GenericUDF udf;
        RexNode castExpr = null;
        if (childRexNodeLst != null && childRexNodeLst.size() == 1 && ((udf = func.getGenericUDF()) instanceof GenericUDFToChar || udf instanceof GenericUDFToVarchar || udf instanceof GenericUDFToDecimal || udf instanceof GenericUDFToDate || udf instanceof GenericUDFToBinary || this.castExprUsingUDFBridge(udf))) {
            castExpr = this.cluster.getRexBuilder().makeAbstractCast(TypeConverter.convert(func.getTypeInfo(), this.cluster.getTypeFactory()), childRexNodeLst.get(0));
        }
        return castExpr;
    }

    private InputCtx getInputCtx(ExprNodeColumnDesc col) throws SemanticException {
        InputCtx ctxLookingFor = null;
        if (this.inputCtxs.size() == 1) {
            ctxLookingFor = (InputCtx)this.inputCtxs.get(0);
        } else {
            String tableAlias = col.getTabAlias();
            String colAlias = col.getColumn();
            int noInp = 0;
            for (InputCtx ic : this.inputCtxs) {
                if (tableAlias != null && !ic.hiveRR.hasTableAlias(tableAlias) || ic.hiveRR.getPosition(colAlias) < 0) continue;
                ctxLookingFor = ic;
                ++noInp;
            }
            if (noInp > 1) {
                throw new RuntimeException("Ambigous column mapping");
            }
        }
        return ctxLookingFor;
    }

    protected RexNode convert(ExprNodeColumnDesc col) throws SemanticException {
        InputCtx ic = this.getInputCtx(col);
        int pos = (Integer)ic.hiveNameToPosMap.get((Object)col.getColumn());
        return this.cluster.getRexBuilder().makeInputRef(((RelDataTypeField)ic.optiqInpDataType.getFieldList().get(pos)).getType(), pos + ic.offsetInOptiqSchema);
    }

    protected RexNode convert(ExprNodeConstantDesc literal) throws OptiqSemanticException {
        RexBuilder rexBuilder = this.cluster.getRexBuilder();
        RelDataTypeFactory dtFactory = rexBuilder.getTypeFactory();
        PrimitiveTypeInfo hiveType = (PrimitiveTypeInfo)literal.getTypeInfo();
        RelDataType optiqDataType = TypeConverter.convert(hiveType, dtFactory);
        PrimitiveObjectInspector.PrimitiveCategory hiveTypeCategory = hiveType.getPrimitiveCategory();
        ConstantObjectInspector coi = literal.getWritableObjectInspector();
        Object value = ObjectInspectorUtils.copyToStandardJavaObject((Object)coi.getWritableConstantValue(), (ObjectInspector)coi);
        RexLiteral optiqLiteral = null;
        switch (hiveTypeCategory) {
            case BOOLEAN: {
                optiqLiteral = rexBuilder.makeLiteral(((Boolean)value).booleanValue());
                break;
            }
            case BYTE: {
                byte[] byteArray = new byte[]{(Byte)value};
                ByteString bs = new ByteString(byteArray);
                optiqLiteral = rexBuilder.makeBinaryLiteral(bs);
                break;
            }
            case SHORT: {
                optiqLiteral = rexBuilder.makeExactLiteral(new BigDecimal(((Short)value).shortValue()), optiqDataType);
                break;
            }
            case INT: {
                optiqLiteral = rexBuilder.makeExactLiteral(new BigDecimal((Integer)value));
                break;
            }
            case LONG: {
                optiqLiteral = rexBuilder.makeBigintLiteral(new BigDecimal((Long)value));
                break;
            }
            case DECIMAL: {
                if (value instanceof HiveDecimal) {
                    value = ((HiveDecimal)value).bigDecimalValue();
                } else if (value instanceof Decimal128) {
                    value = ((Decimal128)value).toBigDecimal();
                }
                if (value == null) {
                    throw new OptiqSemanticException("Expression " + literal.getExprString() + " is not a valid decimal");
                }
                BigDecimal bd = (BigDecimal)value;
                BigInteger unscaled = bd.unscaledValue();
                if (unscaled.compareTo(MIN_LONG_BI) >= 0 && unscaled.compareTo(MAX_LONG_BI) <= 0) {
                    optiqLiteral = rexBuilder.makeExactLiteral(bd);
                    break;
                }
                RelDataType relType = this.cluster.getTypeFactory().createSqlType(SqlTypeName.DECIMAL, bd.scale(), unscaled.toString().length());
                optiqLiteral = rexBuilder.makeExactLiteral(bd, relType);
                break;
            }
            case FLOAT: {
                optiqLiteral = rexBuilder.makeApproxLiteral(new BigDecimal(((Float)value).floatValue()), optiqDataType);
                break;
            }
            case DOUBLE: {
                optiqLiteral = rexBuilder.makeApproxLiteral(new BigDecimal((Double)value), optiqDataType);
                break;
            }
            case CHAR: {
                if (value instanceof HiveChar) {
                    value = ((HiveChar)value).getValue();
                }
                optiqLiteral = rexBuilder.makeLiteral((String)value);
                break;
            }
            case VARCHAR: {
                if (value instanceof HiveVarchar) {
                    value = ((HiveVarchar)value).getValue();
                }
                optiqLiteral = rexBuilder.makeLiteral((String)value);
                break;
            }
            case STRING: {
                optiqLiteral = rexBuilder.makeLiteral((String)value);
                break;
            }
            case DATE: {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime((Date)value);
                optiqLiteral = rexBuilder.makeDateLiteral((Calendar)cal);
                break;
            }
            case TIMESTAMP: {
                optiqLiteral = rexBuilder.makeTimestampLiteral((Calendar)value, -1);
                break;
            }
            default: {
                throw new RuntimeException("UnSupported Literal");
            }
        }
        return optiqLiteral;
    }

    private RexNode createNullLiteral(ExprNodeDesc expr) throws OptiqSemanticException {
        return this.cluster.getRexBuilder().makeNullLiteral(TypeConverter.convert(expr.getTypeInfo(), this.cluster.getTypeFactory()).getSqlTypeName());
    }

    public static RexNode convert(RelOptCluster cluster, ExprNodeDesc joinCondnExprNode, List<RelNode> inputRels, LinkedHashMap<RelNode, RowResolver> relToHiveRR, Map<RelNode, ImmutableMap<String, Integer>> relToHiveColNameOptiqPosMap, boolean flattenExpr) throws SemanticException {
        ArrayList<InputCtx> inputCtxLst = new ArrayList<InputCtx>();
        int offSet = 0;
        for (RelNode r : inputRels) {
            inputCtxLst.add(new InputCtx(r.getRowType(), relToHiveColNameOptiqPosMap.get(r), relToHiveRR.get(r), offSet));
            offSet += r.getRowType().getFieldCount();
        }
        return new RexNodeConverter(cluster, inputCtxLst, flattenExpr).convert(joinCondnExprNode);
    }

    private static class InputCtx {
        private final RelDataType optiqInpDataType;
        private final ImmutableMap<String, Integer> hiveNameToPosMap;
        private final RowResolver hiveRR;
        private final int offsetInOptiqSchema;

        private InputCtx(RelDataType optiqInpDataType, ImmutableMap<String, Integer> hiveNameToPosMap, RowResolver hiveRR, int offsetInOptiqSchema) {
            this.optiqInpDataType = optiqInpDataType;
            this.hiveNameToPosMap = hiveNameToPosMap;
            this.hiveRR = hiveRR;
            this.offsetInOptiqSchema = offsetInOptiqSchema;
        }
    }
}

