/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.optimizer.ConstantPropagateProcCtx;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeNullDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseCompare;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public final class ConstantPropagateProcFactory {
    protected static final Log LOG = LogFactory.getLog((String)ConstantPropagateProcFactory.class.getName());
    protected static Set<Class<?>> propagatableUdfs = new HashSet();
    private static final Set<PrimitiveObjectInspector.PrimitiveCategory> unSupportedTypes;

    private ConstantPropagateProcFactory() {
    }

    public static ColumnInfo resolveColumn(RowResolver rr, ExprNodeColumnDesc desc) {
        try {
            ColumnInfo ci = rr.get(desc.getTabAlias(), desc.getColumn());
            if (ci == null) {
                String[] tmp = rr.reverseLookup(desc.getColumn());
                if (tmp == null) {
                    return null;
                }
                ci = rr.get(tmp[0], tmp[1]);
                ci.setTabAlias(tmp[0]);
                ci.setAlias(tmp[1]);
            } else {
                String[] tmp = rr.reverseLookup(ci.getInternalName());
                if (tmp == null) {
                    return null;
                }
                ci.setTabAlias(tmp[0]);
                ci.setAlias(tmp[1]);
            }
            return ci;
        }
        catch (SemanticException e) {
            throw new RuntimeException(e);
        }
    }

    private static ExprNodeConstantDesc typeCast(ExprNodeDesc desc, TypeInfo ti) {
        ObjectInspector oi;
        if (desc instanceof ExprNodeNullDesc) {
            return null;
        }
        if (!(ti instanceof PrimitiveTypeInfo) || !(desc.getTypeInfo() instanceof PrimitiveTypeInfo)) {
            return null;
        }
        PrimitiveTypeInfo priti = (PrimitiveTypeInfo)ti;
        PrimitiveTypeInfo descti = (PrimitiveTypeInfo)desc.getTypeInfo();
        if (unSupportedTypes.contains(priti.getPrimitiveCategory()) || unSupportedTypes.contains(descti.getPrimitiveCategory())) {
            return null;
        }
        LOG.debug((Object)("Casting " + desc + " to type " + ti));
        ExprNodeConstantDesc c = (ExprNodeConstantDesc)desc;
        if (null != c.getFoldedFromVal() && priti.getTypeName().equals("string")) {
            return new ExprNodeConstantDesc(c.getFoldedFromVal());
        }
        ObjectInspector origOI = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)desc.getTypeInfo());
        ObjectInspectorConverters.Converter converter = ObjectInspectorConverters.getConverter((ObjectInspector)origOI, (ObjectInspector)(oi = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)ti)));
        Object convObj = converter.convert(c.getValue());
        if (convObj instanceof Integer) {
            switch (priti.getPrimitiveCategory()) {
                case BYTE: {
                    convObj = new Byte((byte)((Integer)convObj).intValue());
                    break;
                }
                case SHORT: {
                    convObj = new Short((short)((Integer)convObj).intValue());
                    break;
                }
                case LONG: {
                    convObj = new Long(((Integer)convObj).intValue());
                }
            }
        }
        return new ExprNodeConstantDesc(ti, convObj);
    }

    public static ExprNodeDesc foldExpr(ExprNodeGenericFuncDesc funcDesc) {
        GenericUDF udf = funcDesc.getGenericUDF();
        if (!ConstantPropagateProcFactory.isDeterministicUdf(udf)) {
            return funcDesc;
        }
        return ConstantPropagateProcFactory.evaluateFunction(funcDesc.getGenericUDF(), funcDesc.getChildren(), funcDesc.getChildren());
    }

    private static ExprNodeDesc foldExpr(ExprNodeDesc desc, Map<ColumnInfo, ExprNodeDesc> constants, ConstantPropagateProcCtx cppCtx, Operator<? extends Serializable> op, int tag, boolean propagate) {
        if (desc instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc funcDesc = (ExprNodeGenericFuncDesc)desc;
            GenericUDF udf = funcDesc.getGenericUDF();
            if (!ConstantPropagateProcFactory.isDeterministicUdf(udf)) {
                LOG.debug((Object)("Function " + udf.getClass() + " undeterministic, quit folding."));
                return desc;
            }
            boolean propagateNext = propagate && propagatableUdfs.contains(udf.getClass());
            ArrayList<ExprNodeDesc> newExprs = new ArrayList<ExprNodeDesc>();
            for (ExprNodeDesc childExpr : desc.getChildren()) {
                newExprs.add(ConstantPropagateProcFactory.foldExpr(childExpr, constants, cppCtx, op, tag, propagateNext));
            }
            ExprNodeDesc constant = ConstantPropagateProcFactory.evaluateFunction(udf, newExprs, desc.getChildren());
            if (constant != null) {
                LOG.debug((Object)("Folding expression:" + desc + " -> " + constant));
                return constant;
            }
            ExprNodeDesc shortcut = ConstantPropagateProcFactory.shortcutFunction(udf, newExprs);
            if (shortcut != null) {
                LOG.debug((Object)("Folding expression:" + desc + " -> " + shortcut));
                return shortcut;
            }
            ((ExprNodeGenericFuncDesc)desc).setChildren(newExprs);
            if (propagate) {
                ConstantPropagateProcFactory.propagate(udf, newExprs, cppCtx.getRowResolver(op), constants);
            }
            return desc;
        }
        if (desc instanceof ExprNodeColumnDesc) {
            if (op.getParentOperators() == null || op.getParentOperators().isEmpty()) {
                return desc;
            }
            Operator<OperatorDesc> parent = op.getParentOperators().get(tag);
            ExprNodeDesc col = ConstantPropagateProcFactory.evaluateColumn((ExprNodeColumnDesc)desc, cppCtx, parent);
            if (col != null) {
                LOG.debug((Object)("Folding expression:" + desc + " -> " + col));
                return col;
            }
        }
        return desc;
    }

    private static boolean isDeterministicUdf(GenericUDF udf) {
        String[] jars;
        String[] files;
        UDFType udfType = udf.getClass().getAnnotation(UDFType.class);
        if (udf instanceof GenericUDFBridge) {
            udfType = ((GenericUDFBridge)udf).getUdfClass().getAnnotation(UDFType.class);
        }
        if (!udfType.deterministic()) {
            return false;
        }
        if (udf instanceof GenericUDFBridge) {
            GenericUDFBridge bridge = (GenericUDFBridge)udf;
            String udfClassName = bridge.getUdfClassName();
            try {
                UDF udfInternal = (UDF)Class.forName(bridge.getUdfClassName(), true, Utilities.getSessionSpecifiedClassLoader()).newInstance();
                files = udfInternal.getRequiredFiles();
                jars = udfInternal.getRequiredJars();
            }
            catch (Exception e) {
                LOG.error((Object)("The UDF implementation class '" + udfClassName + "' is not present in the class path"));
                return false;
            }
        } else {
            files = udf.getRequiredFiles();
            jars = udf.getRequiredJars();
        }
        return files == null && jars == null;
    }

    private static void propagate(GenericUDF udf, List<ExprNodeDesc> newExprs, RowResolver rr, Map<ColumnInfo, ExprNodeDesc> constants) {
        ExprNodeDesc operand;
        if (udf instanceof GenericUDFOPEqual) {
            ExprNodeConstantDesc v;
            ExprNodeDesc lOperand = newExprs.get(0);
            ExprNodeDesc rOperand = newExprs.get(1);
            if (lOperand instanceof ExprNodeConstantDesc) {
                v = (ExprNodeConstantDesc)lOperand;
            } else if (rOperand instanceof ExprNodeConstantDesc) {
                v = (ExprNodeConstantDesc)rOperand;
            } else {
                return;
            }
            ExprNodeColumnDesc c = ConstantPropagateProcFactory.getColumnExpr(lOperand);
            if (null == c) {
                c = ConstantPropagateProcFactory.getColumnExpr(rOperand);
            }
            if (null == c) {
                return;
            }
            ColumnInfo ci = ConstantPropagateProcFactory.resolveColumn(rr, c);
            if (ci != null) {
                LOG.debug((Object)("Filter " + udf + " is identified as a value assignment, propagate it."));
                if (!v.getTypeInfo().equals((Object)ci.getType())) {
                    v = ConstantPropagateProcFactory.typeCast(v, ci.getType());
                }
                if (v != null) {
                    constants.put(ci, v);
                }
            }
        } else if (udf instanceof GenericUDFOPNull && (operand = newExprs.get(0)) instanceof ExprNodeColumnDesc) {
            LOG.debug((Object)("Filter " + udf + " is identified as a value assignment, propagate it."));
            ExprNodeColumnDesc c = (ExprNodeColumnDesc)operand;
            ColumnInfo ci = ConstantPropagateProcFactory.resolveColumn(rr, c);
            if (ci != null) {
                constants.put(ci, new ExprNodeNullDesc());
            }
        }
    }

    private static ExprNodeColumnDesc getColumnExpr(ExprNodeDesc expr) {
        while (FunctionRegistry.isOpCast(expr)) {
            expr = expr.getChildren().get(0);
        }
        return expr instanceof ExprNodeColumnDesc ? (ExprNodeColumnDesc)expr : null;
    }

    private static ExprNodeDesc shortcutFunction(GenericUDF udf, List<ExprNodeDesc> newExprs) {
        ExprNodeDesc childExpr;
        int i;
        if (udf instanceof GenericUDFOPAnd) {
            for (i = 0; i < 2; ++i) {
                childExpr = newExprs.get(i);
                ExprNodeDesc other = newExprs.get(Math.abs(i - 1));
                if (childExpr instanceof ExprNodeConstantDesc) {
                    ExprNodeConstantDesc c = (ExprNodeConstantDesc)childExpr;
                    if (Boolean.TRUE.equals(c.getValue())) {
                        return other;
                    }
                    return childExpr;
                }
                if (!(childExpr instanceof ExprNodeGenericFuncDesc) || !(((ExprNodeGenericFuncDesc)childExpr).getGenericUDF() instanceof GenericUDFOPNotNull) || !(childExpr.getChildren().get(0) instanceof ExprNodeColumnDesc) || !(other instanceof ExprNodeGenericFuncDesc) || !(((ExprNodeGenericFuncDesc)other).getGenericUDF() instanceof GenericUDFBaseCompare) || other.getChildren().size() != 2) continue;
                ExprNodeColumnDesc colDesc = ConstantPropagateProcFactory.getColumnExpr(other.getChildren().get(0));
                if (null == colDesc) {
                    colDesc = ConstantPropagateProcFactory.getColumnExpr(other.getChildren().get(1));
                }
                if (null == colDesc || !colDesc.isSame(childExpr.getChildren().get(0))) continue;
                return other;
            }
        }
        if (udf instanceof GenericUDFOPOr) {
            for (i = 0; i < 2; ++i) {
                childExpr = newExprs.get(i);
                if (!(childExpr instanceof ExprNodeConstantDesc)) continue;
                ExprNodeConstantDesc c = (ExprNodeConstantDesc)childExpr;
                if (Boolean.FALSE.equals(c.getValue())) {
                    return newExprs.get(Math.abs(i - 1));
                }
                return childExpr;
            }
        }
        return null;
    }

    private static ExprNodeDesc evaluateColumn(ExprNodeColumnDesc desc, ConstantPropagateProcCtx cppCtx, Operator<? extends Serializable> parent) {
        try {
            ColumnInfo ci = null;
            RowResolver rr = cppCtx.getOpToParseCtxMap().get(parent).getRowResolver();
            String[] tmp = rr.reverseLookup(desc.getColumn());
            if (tmp == null) {
                LOG.error((Object)("Reverse look up of column " + desc + " error!"));
                return null;
            }
            ci = rr.get(tmp[0], tmp[1]);
            if (ci != null) {
                ExprNodeDesc constant = null;
                if (ci.getAlias() == null) {
                    for (Map.Entry<ColumnInfo, ExprNodeDesc> e : cppCtx.getOpToConstantExprs().get(parent).entrySet()) {
                        if (!e.getKey().getInternalName().equals(ci.getInternalName())) continue;
                        constant = e.getValue();
                        break;
                    }
                } else {
                    constant = cppCtx.getOpToConstantExprs().get(parent).get(ci);
                }
                if (constant != null) {
                    if (constant instanceof ExprNodeConstantDesc && !constant.getTypeInfo().equals((Object)desc.getTypeInfo())) {
                        return ConstantPropagateProcFactory.typeCast(constant, desc.getTypeInfo());
                    }
                    return constant;
                }
                return null;
            }
            LOG.error((Object)("Can't resolve " + desc.getTabAlias() + "." + desc.getColumn()));
            throw new RuntimeException("Can't resolve " + desc.getTabAlias() + "." + desc.getColumn());
        }
        catch (SemanticException e) {
            throw new RuntimeException(e);
        }
    }

    private static ExprNodeDesc evaluateFunction(GenericUDF udf, List<ExprNodeDesc> exprs, List<ExprNodeDesc> oldExprs) {
        GenericUDF.DeferredObject[] arguments = new GenericUDF.DeferredJavaObject[exprs.size()];
        ObjectInspector[] argois = new ObjectInspector[exprs.size()];
        for (int i = 0; i < exprs.size(); ++i) {
            ExprNodeDesc desc = exprs.get(i);
            if (desc instanceof ExprNodeConstantDesc) {
                ExprNodeConstantDesc constant = (ExprNodeConstantDesc)exprs.get(i);
                if (!constant.getTypeInfo().equals((Object)oldExprs.get(i).getTypeInfo()) && (constant = ConstantPropagateProcFactory.typeCast(constant, oldExprs.get(i).getTypeInfo())) == null) {
                    return null;
                }
                Object value = constant.getValue();
                PrimitiveTypeInfo pti = (PrimitiveTypeInfo)constant.getTypeInfo();
                Object writableValue = PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)pti).getPrimitiveWritableObject(value);
                arguments[i] = new GenericUDF.DeferredJavaObject(writableValue);
                argois[i] = ObjectInspectorUtils.getConstantObjectInspector((ObjectInspector)constant.getWritableObjectInspector(), (Object)writableValue);
                continue;
            }
            if (desc instanceof ExprNodeNullDesc) {
                return null;
            }
            if (desc instanceof ExprNodeGenericFuncDesc) {
                ExprNodeDesc evaluatedFn = ConstantPropagateProcFactory.foldExpr((ExprNodeGenericFuncDesc)desc);
                if (null == evaluatedFn || !(evaluatedFn instanceof ExprNodeConstantDesc)) {
                    return null;
                }
                ExprNodeConstantDesc constant = (ExprNodeConstantDesc)evaluatedFn;
                Object writableValue = PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)((PrimitiveTypeInfo)constant.getTypeInfo())).getPrimitiveWritableObject(constant.getValue());
                arguments[i] = new GenericUDF.DeferredJavaObject(writableValue);
                argois[i] = ObjectInspectorUtils.getConstantObjectInspector((ObjectInspector)constant.getWritableObjectInspector(), (Object)writableValue);
                continue;
            }
            return null;
        }
        try {
            ObjectInspector oi = udf.initialize(argois);
            Object o = udf.evaluate(arguments);
            LOG.debug((Object)(udf.getClass().getName() + "(" + exprs + ")=" + o));
            if (o == null) {
                return new ExprNodeNullDesc();
            }
            Class<?> clz = o.getClass();
            if (PrimitiveObjectInspectorUtils.isPrimitiveWritableClass(clz)) {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
                PrimitiveTypeInfo typeInfo = poi.getTypeInfo();
                if (typeInfo.getTypeName().contains("decimal") || typeInfo.getTypeName().contains("varchar") || typeInfo.getTypeName().contains("char")) {
                    return null;
                }
                o = poi.getPrimitiveJavaObject(o);
            } else if (!PrimitiveObjectInspectorUtils.isPrimitiveJavaClass(clz)) {
                LOG.error((Object)("Unable to evaluate " + udf + ". Return value unrecoginizable."));
                return null;
            }
            String constStr = null;
            if (arguments.length == 1 && FunctionRegistry.isOpCast(udf)) {
                constStr = ((GenericUDF.DeferredJavaObject)arguments[0]).get().toString();
            }
            return new ExprNodeConstantDesc(o).setFoldedFromVal(constStr);
        }
        catch (HiveException e) {
            LOG.error((Object)("Evaluation function " + udf.getClass() + " failed in Constant Propagatation Optimizer."));
            throw new RuntimeException(e);
        }
    }

    private static void foldOperator(Operator<? extends Serializable> op, ConstantPropagateProcCtx cppCtx) throws SemanticException {
        Map<String, ExprNodeDesc> colExprMap;
        RowSchema schema = op.getSchema();
        Map<ColumnInfo, ExprNodeDesc> constants = cppCtx.getOpToConstantExprs().get(op);
        if (schema != null && schema.getSignature() != null) {
            for (ColumnInfo col : schema.getSignature()) {
                ExprNodeDesc constant = constants.get(col);
                if (constant == null) continue;
                LOG.debug((Object)("Replacing column " + col + " with constant " + constant + " in " + op));
                if (!col.getType().equals((Object)constant.getTypeInfo())) {
                    constant = ConstantPropagateProcFactory.typeCast(constant, col.getType());
                }
                if (constant == null) continue;
                col.setObjectinspector(constant.getWritableObjectInspector());
            }
        }
        if ((colExprMap = op.getColumnExprMap()) != null) {
            for (Map.Entry<ColumnInfo, ExprNodeDesc> e : constants.entrySet()) {
                String internalName = e.getKey().getInternalName();
                if (!colExprMap.containsKey(internalName)) continue;
                colExprMap.put(internalName, e.getValue());
            }
        }
    }

    public static ConstantPropagateFilterProc getFilterProc() {
        return new ConstantPropagateFilterProc();
    }

    public static ConstantPropagateGroupByProc getGroupByProc() {
        return new ConstantPropagateGroupByProc();
    }

    public static ConstantPropagateDefaultProc getDefaultProc() {
        return new ConstantPropagateDefaultProc();
    }

    public static ConstantPropagateSelectProc getSelectProc() {
        return new ConstantPropagateSelectProc();
    }

    public static NodeProcessor getFileSinkProc() {
        return new ConstantPropagateFileSinkProc();
    }

    public static NodeProcessor getStopProc() {
        return new ConstantPropagateStopProc();
    }

    public static NodeProcessor getReduceSinkProc() {
        return new ConstantPropagateReduceSinkProc();
    }

    public static NodeProcessor getJoinProc() {
        return new ConstantPropagateJoinProc();
    }

    public static NodeProcessor getTableScanProc() {
        return new ConstantPropagateTableScanProc();
    }

    static {
        propagatableUdfs.add(GenericUDFOPAnd.class);
        unSupportedTypes = ImmutableSet.builder().add((Object)PrimitiveObjectInspector.PrimitiveCategory.DECIMAL).add((Object)PrimitiveObjectInspector.PrimitiveCategory.VARCHAR).add((Object)PrimitiveObjectInspector.PrimitiveCategory.CHAR).build();
    }

    public static class ConstantPropagateTableScanProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            TableScanOperator op = (TableScanOperator)nd;
            TableScanDesc conf = (TableScanDesc)op.getConf();
            ConstantPropagateProcCtx cppCtx = (ConstantPropagateProcCtx)ctx;
            Map<ColumnInfo, ExprNodeDesc> constants = cppCtx.getPropagatedConstants(op);
            cppCtx.getOpToConstantExprs().put(op, constants);
            ExprNodeGenericFuncDesc pred = conf.getFilterExpr();
            if (pred == null) {
                return null;
            }
            ExprNodeDesc constant = ConstantPropagateProcFactory.foldExpr(pred, constants, cppCtx, op, 0, false);
            if (constant instanceof ExprNodeGenericFuncDesc) {
                conf.setFilterExpr((ExprNodeGenericFuncDesc)constant);
            } else {
                conf.setFilterExpr(null);
            }
            return null;
        }
    }

    public static class ConstantPropagateJoinProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            JoinOperator op = (JoinOperator)nd;
            JoinDesc conf = (JoinDesc)op.getConf();
            ConstantPropagateProcCtx cppCtx = (ConstantPropagateProcCtx)ctx;
            Map<ColumnInfo, ExprNodeDesc> constants = cppCtx.getPropagatedConstants(op);
            cppCtx.getOpToConstantExprs().put(op, constants);
            if (constants.isEmpty()) {
                return null;
            }
            if (op.getChildOperators().size() == 1 && op.getChildOperators().get(0) instanceof ReduceSinkOperator) {
                LOG.debug((Object)"Skip JOIN-RS structure.");
                return null;
            }
            LOG.info((Object)("Old exprs " + conf.getExprs()));
            for (Map.Entry<Byte, List<ExprNodeDesc>> e : conf.getExprs().entrySet()) {
                byte tag = e.getKey();
                List<ExprNodeDesc> exprs = e.getValue();
                if (exprs == null) continue;
                ArrayList<ExprNodeDesc> newExprs = new ArrayList<ExprNodeDesc>();
                for (ExprNodeDesc expr : exprs) {
                    ExprNodeDesc newExpr = ConstantPropagateProcFactory.foldExpr(expr, constants, cppCtx, op, tag, false);
                    if (newExpr instanceof ExprNodeConstantDesc || newExpr instanceof ExprNodeNullDesc) {
                        LOG.info((Object)("expr " + newExpr + " fold from " + expr + " is removed."));
                        continue;
                    }
                    newExprs.add(newExpr);
                }
                e.setValue(newExprs);
            }
            LOG.info((Object)("New exprs " + conf.getExprs()));
            for (List<ExprNodeDesc> v : conf.getFilters().values()) {
                for (int i = 0; i < v.size(); ++i) {
                    ExprNodeDesc expr = ConstantPropagateProcFactory.foldExpr(v.get(i), constants, cppCtx, op, 0, false);
                    v.set(i, expr);
                }
            }
            ConstantPropagateProcFactory.foldOperator(op, cppCtx);
            return null;
        }
    }

    public static class ConstantPropagateReduceSinkProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            JoinOperator joinOp;
            ReduceSinkOperator op = (ReduceSinkOperator)nd;
            ReduceSinkDesc rsDesc = (ReduceSinkDesc)op.getConf();
            ConstantPropagateProcCtx cppCtx = (ConstantPropagateProcCtx)ctx;
            Map<ColumnInfo, ExprNodeDesc> constants = cppCtx.getPropagatedConstants(op);
            cppCtx.getOpToConstantExprs().put(op, constants);
            if (constants.isEmpty()) {
                return null;
            }
            if (op.getChildOperators().size() == 1 && op.getChildOperators().get(0) instanceof JoinOperator && this.skipFolding((JoinDesc)(joinOp = (JoinOperator)op.getChildOperators().get(0)).getConf())) {
                LOG.debug((Object)("Skip folding in outer join " + op));
                cppCtx.getOpToConstantExprs().put(op, new HashMap());
                return null;
            }
            if (rsDesc.getDistinctColumnIndices() != null && !rsDesc.getDistinctColumnIndices().isEmpty()) {
                LOG.debug((Object)("Skip folding in distinct subqueries " + op));
                cppCtx.getOpToConstantExprs().put(op, new HashMap());
                return null;
            }
            ArrayList<ExprNodeDesc> newKeyEpxrs = new ArrayList<ExprNodeDesc>();
            for (ExprNodeDesc desc : rsDesc.getKeyCols()) {
                ExprNodeDesc newDesc = ConstantPropagateProcFactory.foldExpr(desc, constants, cppCtx, op, 0, false);
                if (newDesc != desc && desc instanceof ExprNodeColumnDesc && newDesc instanceof ExprNodeConstantDesc) {
                    ((ExprNodeConstantDesc)newDesc).setFoldedFromCol(((ExprNodeColumnDesc)desc).getColumn());
                }
                newKeyEpxrs.add(newDesc);
            }
            rsDesc.setKeyCols(newKeyEpxrs);
            ArrayList<ExprNodeDesc> newPartExprs = new ArrayList<ExprNodeDesc>();
            for (ExprNodeDesc desc : rsDesc.getPartitionCols()) {
                ExprNodeDesc expr = ConstantPropagateProcFactory.foldExpr(desc, constants, cppCtx, op, 0, false);
                if (expr != desc && desc instanceof ExprNodeColumnDesc && expr instanceof ExprNodeConstantDesc) {
                    ((ExprNodeConstantDesc)expr).setFoldedFromCol(((ExprNodeColumnDesc)desc).getColumn());
                }
                newPartExprs.add(expr);
            }
            rsDesc.setPartitionCols(newPartExprs);
            ArrayList<ExprNodeDesc> newValExprs = new ArrayList<ExprNodeDesc>();
            for (ExprNodeDesc desc : rsDesc.getValueCols()) {
                newValExprs.add(ConstantPropagateProcFactory.foldExpr(desc, constants, cppCtx, op, 0, false));
            }
            rsDesc.setValueCols(newValExprs);
            ConstantPropagateProcFactory.foldOperator(op, cppCtx);
            return null;
        }

        private boolean skipFolding(JoinDesc joinDesc) {
            for (JoinCondDesc cond : joinDesc.getConds()) {
                if (cond.getType() == 0 || cond.getType() == 4) continue;
                return true;
            }
            return false;
        }
    }

    public static class ConstantPropagateStopProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            Operator op = (Operator)nd;
            ConstantPropagateProcCtx cppCtx = (ConstantPropagateProcCtx)ctx;
            cppCtx.getOpToConstantExprs().put(op, new HashMap());
            LOG.debug((Object)("Stop propagate constants on op " + op.getOperatorId()));
            return null;
        }
    }

    public static class ConstantPropagateFileSinkProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            FileSinkOperator op = (FileSinkOperator)nd;
            ConstantPropagateProcCtx cppCtx = (ConstantPropagateProcCtx)ctx;
            Map<ColumnInfo, ExprNodeDesc> constants = cppCtx.getPropagatedConstants(op);
            cppCtx.getOpToConstantExprs().put(op, constants);
            if (constants.isEmpty()) {
                return null;
            }
            FileSinkDesc fsdesc = (FileSinkDesc)op.getConf();
            DynamicPartitionCtx dpCtx = fsdesc.getDynPartCtx();
            if (dpCtx != null) {
                Set<String> inputs = dpCtx.getInputToDPCols().keySet();
                Operator<OperatorDesc> parent = op.getParentOperators().get(0);
                Map<ColumnInfo, ExprNodeDesc> parentConstants = cppCtx.getPropagatedConstants(parent);
                RowResolver rr = cppCtx.getOpToParseCtxMap().get(parent).getRowResolver();
                boolean allConstant = true;
                for (String input : inputs) {
                    String[] tmp = rr.reverseLookup(input);
                    ColumnInfo ci = rr.get(tmp[0], tmp[1]);
                    if (parentConstants.get(ci) != null) continue;
                    allConstant = false;
                    break;
                }
                if (allConstant) {
                    this.pruneDP(fsdesc);
                }
            }
            ConstantPropagateProcFactory.foldOperator(op, cppCtx);
            return null;
        }

        private void pruneDP(FileSinkDesc fsdesc) {
            LOG.info((Object)"DP can be rewritten to SP!");
        }
    }

    public static class ConstantPropagateSelectProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            SelectOperator op = (SelectOperator)nd;
            ConstantPropagateProcCtx cppCtx = (ConstantPropagateProcCtx)ctx;
            Map<ColumnInfo, ExprNodeDesc> constants = cppCtx.getPropagatedConstants(op);
            cppCtx.getOpToConstantExprs().put(op, constants);
            ConstantPropagateProcFactory.foldOperator(op, cppCtx);
            List<ExprNodeDesc> colList = ((SelectDesc)op.getConf()).getColList();
            List<String> columnNames = ((SelectDesc)op.getConf()).getOutputColumnNames();
            Map<String, ExprNodeDesc> columnExprMap = op.getColumnExprMap();
            if (colList != null) {
                for (int i = 0; i < colList.size(); ++i) {
                    ExprNodeDesc newCol = ConstantPropagateProcFactory.foldExpr(colList.get(i), constants, cppCtx, op, 0, false);
                    if (!(colList.get(i) instanceof ExprNodeConstantDesc) && newCol instanceof ExprNodeConstantDesc) {
                        String colName = colList.get(i).getExprString();
                        if (HiveConf.getPositionFromInternalName((String)colName) == -1) {
                            ((ExprNodeConstantDesc)newCol).setFoldedFromCol(colName);
                        } else {
                            ExprNodeDesc desc = columnExprMap.get(colName);
                            if (desc instanceof ExprNodeConstantDesc) {
                                ((ExprNodeConstantDesc)newCol).setFoldedFromCol(((ExprNodeConstantDesc)desc).getFoldedFromCol());
                            }
                        }
                    }
                    colList.set(i, newCol);
                    if (columnExprMap == null) continue;
                    columnExprMap.put(columnNames.get(i), newCol);
                }
                LOG.debug((Object)("New column list:(" + StringUtils.join(colList, (String)" ") + ")"));
            }
            return null;
        }
    }

    public static class ConstantPropagateDefaultProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            ConstantPropagateProcCtx cppCtx = (ConstantPropagateProcCtx)ctx;
            Operator op = (Operator)nd;
            Map<ColumnInfo, ExprNodeDesc> constants = cppCtx.getPropagatedConstants(op);
            cppCtx.getOpToConstantExprs().put(op, constants);
            if (constants.isEmpty()) {
                return null;
            }
            ConstantPropagateProcFactory.foldOperator(op, cppCtx);
            return null;
        }
    }

    public static class ConstantPropagateGroupByProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            GroupByOperator op = (GroupByOperator)nd;
            ConstantPropagateProcCtx cppCtx = (ConstantPropagateProcCtx)ctx;
            Map<ColumnInfo, ExprNodeDesc> colToConstants = cppCtx.getPropagatedConstants(op);
            cppCtx.getOpToConstantExprs().put(op, colToConstants);
            if (colToConstants.isEmpty()) {
                return null;
            }
            GroupByDesc conf = (GroupByDesc)op.getConf();
            ArrayList<ExprNodeDesc> keys = conf.getKeys();
            for (int i = 0; i < keys.size(); ++i) {
                ExprNodeDesc key = keys.get(i);
                ExprNodeDesc newkey = ConstantPropagateProcFactory.foldExpr(key, colToConstants, cppCtx, op, 0, false);
                keys.set(i, newkey);
            }
            ConstantPropagateProcFactory.foldOperator(op, cppCtx);
            return null;
        }
    }

    public static class ConstantPropagateFilterProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            FilterOperator op = (FilterOperator)nd;
            ConstantPropagateProcCtx cppCtx = (ConstantPropagateProcCtx)ctx;
            Map<ColumnInfo, ExprNodeDesc> constants = cppCtx.getPropagatedConstants(op);
            cppCtx.getOpToConstantExprs().put(op, constants);
            ExprNodeDesc condn = ((FilterDesc)op.getConf()).getPredicate();
            LOG.debug((Object)("Old filter FIL[" + op.getIdentifier() + "] conditions:" + condn.getExprString()));
            ExprNodeDesc newCondn = ConstantPropagateProcFactory.foldExpr(condn, constants, cppCtx, op, 0, true);
            if (newCondn instanceof ExprNodeConstantDesc) {
                ExprNodeConstantDesc c = (ExprNodeConstantDesc)newCondn;
                if (Boolean.TRUE.equals(c.getValue())) {
                    cppCtx.addOpToDelete(op);
                    LOG.debug((Object)("Filter expression " + condn + " holds true. Will delete it."));
                } else if (Boolean.FALSE.equals(c.getValue())) {
                    LOG.warn((Object)("Filter expression " + condn + " holds false!"));
                }
            }
            LOG.debug((Object)("New filter FIL[" + op.getIdentifier() + "] conditions:" + newCondn.getExprString()));
            ((FilterDesc)op.getConf()).setPredicate(newCondn);
            ConstantPropagateProcFactory.foldOperator(op, cppCtx);
            return null;
        }
    }
}

