/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.mapred.JobConf;

public class ProjectionPusher {
    private static final Log LOG = LogFactory.getLog(ProjectionPusher.class);
    private final Map<String, PartitionDesc> pathToPartitionInfo = new LinkedHashMap<String, PartitionDesc>();
    private MapWork mapWork;

    private void updateMrWork(JobConf job) {
        String plan = HiveConf.getVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.PLAN);
        if (this.mapWork == null && plan != null && plan.length() > 0) {
            this.mapWork = Utilities.getMapWork((Configuration)job);
            this.pathToPartitionInfo.clear();
            for (Map.Entry<String, PartitionDesc> entry : this.mapWork.getPathToPartitionInfo().entrySet()) {
                this.pathToPartitionInfo.put(new Path(entry.getKey()).toUri().getPath(), entry.getValue());
            }
        }
    }

    private void pushProjectionsAndFilters(JobConf jobConf, String splitPath, String splitPathWithNoSchema) {
        if (this.mapWork == null) {
            return;
        }
        if (this.mapWork.getPathToAliases() == null) {
            return;
        }
        ArrayList<String> aliases = new ArrayList<String>();
        for (Map.Entry<String, ArrayList<String>> entry : this.mapWork.getPathToAliases().entrySet()) {
            String key = new Path(entry.getKey()).toUri().getPath();
            if (!splitPath.equals(key) && !splitPathWithNoSchema.equals(key)) continue;
            ArrayList<String> list = entry.getValue();
            for (String val : list) {
                aliases.add(val);
            }
        }
        for (String alias : aliases) {
            Operator<? extends OperatorDesc> op = this.mapWork.getAliasToWork().get(alias);
            if (op == null || !(op instanceof TableScanOperator)) continue;
            TableScanOperator tableScan = (TableScanOperator)op;
            List<Integer> list = tableScan.getNeededColumnIDs();
            if (list != null) {
                ColumnProjectionUtils.appendReadColumnIDs((Configuration)jobConf, list);
            } else {
                ColumnProjectionUtils.setFullyReadColumns((Configuration)jobConf);
            }
            this.pushFilters(jobConf, tableScan);
        }
    }

    private void pushFilters(JobConf jobConf, TableScanOperator tableScan) {
        TableScanDesc scanDesc = (TableScanDesc)tableScan.getConf();
        if (scanDesc == null) {
            LOG.debug((Object)"Not pushing filters because TableScanDesc is null");
            return;
        }
        Utilities.setColumnNameList(jobConf, tableScan);
        ExprNodeGenericFuncDesc filterExpr = scanDesc.getFilterExpr();
        if (filterExpr == null) {
            LOG.debug((Object)"Not pushing filters because FilterExpr is null");
            return;
        }
        String filterText = filterExpr.getExprString();
        String filterExprSerialized = Utilities.serializeExpression(filterExpr);
        jobConf.set("hive.io.filter.text", filterText);
        jobConf.set("hive.io.filter.expr.serialized", filterExprSerialized);
    }

    public JobConf pushProjectionsAndFilters(JobConf jobConf, Path path) throws IOException {
        this.updateMrWork(jobConf);
        JobConf cloneJobConf = new JobConf((Configuration)jobConf);
        PartitionDesc part = this.pathToPartitionInfo.get(path.toString());
        if (part != null && part.getTableDesc() != null) {
            Utilities.copyTableJobPropertiesToConf(part.getTableDesc(), cloneJobConf);
        }
        this.pushProjectionsAndFilters(cloneJobConf, path.toString(), path.toUri().getPath());
        return cloneJobConf;
    }
}

