/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.exec.persistence.HashMapWrapper;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinBytesTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKey;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectSerDeContext;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainerSerDe;
import org.apache.hadoop.hive.ql.exec.tez.TezCacheAccess;
import org.apache.hadoop.hive.ql.exec.tez.TezContext;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.library.api.KeyValueReader;

public class HashTableLoader
implements org.apache.hadoop.hive.ql.exec.HashTableLoader {
    private static final Log LOG = LogFactory.getLog((String)HashTableLoader.class.getName());
    private ExecMapperContext context;
    private Configuration hconf;
    private MapJoinDesc desc;
    private MapJoinKey lastKey = null;
    private int rowCount = 0;

    @Override
    public void init(ExecMapperContext context, Configuration hconf, MapJoinOperator joinOp) {
        this.context = context;
        this.hconf = hconf;
        this.desc = (MapJoinDesc)joinOp.getConf();
    }

    @Override
    public void load(MapJoinTableContainer[] mapJoinTables, MapJoinTableContainerSerDe[] mapJoinTableSerdes) throws HiveException {
        TezContext tezContext = (TezContext)MapredContext.get();
        Map<Integer, String> parentToInput = this.desc.getParentToInput();
        Map<Integer, Long> parentKeyCounts = this.desc.getParentKeyCounts();
        boolean useOptimizedTables = HiveConf.getBoolVar((Configuration)this.hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEMAPJOINUSEOPTIMIZEDTABLE);
        boolean isFirstKey = true;
        TezCacheAccess tezCacheAccess = TezCacheAccess.createInstance(this.hconf);
        for (int pos = 0; pos < mapJoinTables.length; ++pos) {
            if (pos == this.desc.getPosBigTable()) continue;
            String inputName = parentToInput.get(pos);
            LogicalInput input = tezContext.getInput(inputName);
            try {
                MapJoinTableContainer tableContainer;
                ObjectInspector keyOi;
                KeyValueReader kvReader = (KeyValueReader)input.getReader();
                MapJoinObjectSerDeContext keyCtx = mapJoinTableSerdes[pos].getKeyContext();
                MapJoinObjectSerDeContext valCtx = mapJoinTableSerdes[pos].getValueContext();
                if (useOptimizedTables && !MapJoinBytesTableContainer.isSupportedKey(keyOi = keyCtx.getSerDe().getObjectInspector())) {
                    if (isFirstKey) {
                        useOptimizedTables = false;
                    } else {
                        throw new HiveException(this.describeOi("Only a subset of mapjoin keys is supported. Unsupported key: ", keyOi));
                    }
                }
                isFirstKey = false;
                Long keyCountObj = parentKeyCounts.get(pos);
                long keyCount = keyCountObj == null ? -1L : keyCountObj;
                MapJoinTableContainer mapJoinTableContainer = tableContainer = useOptimizedTables ? new MapJoinBytesTableContainer(this.hconf, valCtx, keyCount) : new HashMapWrapper(this.hconf, keyCount);
                while (kvReader.next()) {
                    ++this.rowCount;
                    this.lastKey = tableContainer.putRow(keyCtx, (Writable)kvReader.getCurrentKey(), valCtx, (Writable)kvReader.getCurrentValue());
                }
                tableContainer.seal();
                mapJoinTables[pos] = tableContainer;
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
            catch (SerDeException e) {
                throw new HiveException(e);
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
            LOG.info((Object)("Is this a bucket map join: " + this.desc.isBucketMapJoin()));
            if (this.desc.isBucketMapJoin()) continue;
            tezCacheAccess.registerCachedInput(inputName);
            LOG.info((Object)("Setting Input: " + inputName + " as cached"));
        }
    }

    private String describeOi(String desc, ObjectInspector keyOi) {
        for (StructField field : ((StructObjectInspector)keyOi).getAllStructFieldRefs()) {
            ObjectInspector oi = field.getFieldObjectInspector();
            String cat = oi.getCategory().toString();
            if (oi.getCategory() == ObjectInspector.Category.PRIMITIVE) {
                cat = ((PrimitiveObjectInspector)oi).getPrimitiveCategory().toString();
            }
            desc = desc + field.getFieldName() + ":" + cat + ", ";
        }
        return desc;
    }
}

