/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.generator;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.ComplexDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaLocation;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.EnumDataSchema;
import com.linkedin.data.schema.FixedDataSchema;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.PrimitiveDataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.pegasus.generator.CodeUtil;
import com.linkedin.pegasus.generator.spec.ArrayTemplateSpec;
import com.linkedin.pegasus.generator.spec.ClassTemplateSpec;
import com.linkedin.pegasus.generator.spec.CustomInfoSpec;
import com.linkedin.pegasus.generator.spec.EnumTemplateSpec;
import com.linkedin.pegasus.generator.spec.FixedTemplateSpec;
import com.linkedin.pegasus.generator.spec.MapTemplateSpec;
import com.linkedin.pegasus.generator.spec.ModifierSpec;
import com.linkedin.pegasus.generator.spec.PrimitiveTemplateSpec;
import com.linkedin.pegasus.generator.spec.RecordTemplateSpec;
import com.linkedin.pegasus.generator.spec.TyperefTemplateSpec;
import com.linkedin.pegasus.generator.spec.UnionTemplateSpec;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateSpecGenerator {
    private static final Logger _log = LoggerFactory.getLogger(TemplateSpecGenerator.class);
    private static final String ARRAY_SUFFIX = "Array";
    private static final String MAP_SUFFIX = "Map";
    private static final String[] SPECIAL_SUFFIXES = new String[]{"Array", "Map"};
    private final Collection<ClassTemplateSpec> _classTemplateSpecs = new HashSet<ClassTemplateSpec>();
    private final Map<ClassTemplateSpec, DataSchemaLocation> _classToDataSchemaLocationMap = new HashMap<ClassTemplateSpec, DataSchemaLocation>();
    private final Map<String, DataSchema> _classNameToSchemaMap = new HashMap<String, DataSchema>(100);
    private final IdentityHashMap<DataSchema, ClassTemplateSpec> _schemaToClassMap = new IdentityHashMap(100);
    private final Deque<DataSchemaLocation> _locationStack = new ArrayDeque<DataSchemaLocation>();
    private final Map<DataSchema, CustomInfoSpec> _immediateCustomMap = new IdentityHashMap<DataSchema, CustomInfoSpec>();
    private final DataSchemaResolver _schemaResolver;
    private final String _customTypeLanguage;
    private final String _templatePackageName;

    public TemplateSpecGenerator(DataSchemaResolver schemaResolver) {
        this(schemaResolver, "java", DataTemplate.class.getPackage().getName());
    }

    public TemplateSpecGenerator(DataSchemaResolver schemaResolver, String customTypeLanguage, String templatePackageName) {
        this._schemaResolver = schemaResolver;
        this._customTypeLanguage = customTypeLanguage;
        this._templatePackageName = templatePackageName;
    }

    public DataSchemaLocation getClassLocation(ClassTemplateSpec classSpec) {
        return this._classToDataSchemaLocationMap.get(classSpec);
    }

    public void registerDefinedSchema(DataSchema schema) {
        ClassTemplateSpec spec = ClassTemplateSpec.createFromDataSchema(schema);
        this._schemaToClassMap.put(schema, spec);
        this._classNameToSchemaMap.put(spec.getBindingName(), schema);
    }

    public ClassTemplateSpec generate(DataSchema schema, DataSchemaLocation location) {
        this.pushCurrentLocation(location);
        ClassTemplateSpec result = this.processSchema(schema, null, null);
        this.popCurrentLocation();
        return result;
    }

    public Collection<ClassTemplateSpec> getGeneratedSpecs() {
        return this._classTemplateSpecs;
    }

    private static void checkClassNameForSpecialSuffix(String className) {
        for (String suffix : SPECIAL_SUFFIXES) {
            if (!className.endsWith(suffix)) continue;
            _log.warn("Class name for named type ends with a suffix that may conflict with derived class names for unnamed types, name: " + className + ", suffix: " + suffix);
            break;
        }
    }

    private static boolean allowCustomClass(DataSchema schema) {
        DataSchema dereferencedSchema;
        boolean result = false;
        DataSchema.Type type = schema.getType();
        if ((type == DataSchema.Type.TYPEREF || type == DataSchema.Type.RECORD) && ((dereferencedSchema = schema.getDereferencedDataSchema()).getType() == DataSchema.Type.RECORD || CodeUtil.isDirectType(dereferencedSchema) && dereferencedSchema.getType() != DataSchema.Type.ENUM)) {
            result = true;
        }
        return result;
    }

    private static DataSchema dereferenceIfTyperef(DataSchema schema) {
        DataSchema.Type type = schema.getType();
        return type == DataSchema.Type.TYPEREF ? ((TyperefDataSchema)schema).getRef() : null;
    }

    private static IllegalArgumentException nullTypeNotAllowed(ClassTemplateSpec enclosingClass, String memberName) {
        return new IllegalArgumentException("The null type can only be used in unions, null found" + TemplateSpecGenerator.enclosingClassAndMemberNameToString(enclosingClass, memberName));
    }

    private static IllegalStateException unrecognizedSchemaType(ClassTemplateSpec enclosingClass, String memberName, DataSchema schema) {
        return new IllegalStateException("Unrecognized schema: " + schema + TemplateSpecGenerator.enclosingClassAndMemberNameToString(enclosingClass, memberName));
    }

    private static String enclosingClassAndMemberNameToString(ClassTemplateSpec enclosingClass, String memberName) {
        StringBuilder sb = new StringBuilder();
        if (memberName != null) {
            sb.append(" in ");
            sb.append(memberName);
        }
        if (enclosingClass != null) {
            sb.append(" in ");
            sb.append(enclosingClass.getFullName());
        }
        return sb.toString();
    }

    private void checkForClassNameConflict(String className, DataSchema schema) throws IllegalArgumentException {
        DataSchema schemaFromClassName = this._classNameToSchemaMap.get(className);
        boolean conflict = false;
        if (schemaFromClassName != null && schemaFromClassName != schema) {
            DataSchema.Type schemaType = schema.getType();
            if (schemaFromClassName.getType() != schemaType) {
                conflict = true;
            } else if (schema instanceof NamedDataSchema) {
                conflict = true;
            } else if (!schemaFromClassName.equals((Object)schema)) {
                assert (schemaType == DataSchema.Type.ARRAY || schemaType == DataSchema.Type.MAP);
                _log.info("Class name: " + className + ", bound to schema:" + schemaFromClassName + ", instead of schema: " + schema);
            }
        }
        if (conflict) {
            throw new IllegalArgumentException("Class name conflict detected, class name: " + className + ", class already bound to schema: " + schemaFromClassName + ", attempting to rebind to schema: " + schema);
        }
    }

    private DataSchemaLocation currentLocation() {
        return this._locationStack.getLast();
    }

    private void pushCurrentLocation(DataSchemaLocation location) {
        this._locationStack.addLast(location);
    }

    private void popCurrentLocation() {
        this._locationStack.removeLast();
    }

    private void registerClassTemplateSpec(DataSchema schema, ClassTemplateSpec classTemplateSpec) {
        classTemplateSpec.setLocation(this.currentLocation().toString());
        this._schemaToClassMap.put(schema, classTemplateSpec);
        this._classNameToSchemaMap.put(classTemplateSpec.getBindingName(), schema);
        this._classToDataSchemaLocationMap.put(classTemplateSpec, this.currentLocation());
        if (schema instanceof NamedDataSchema) {
            TemplateSpecGenerator.checkClassNameForSpecialSuffix(classTemplateSpec.getBindingName());
        }
        this._classTemplateSpecs.add(classTemplateSpec);
    }

    private ClassTemplateSpec processSchema(DataSchema schema, ClassTemplateSpec enclosingClass, String memberName) {
        CustomInfoSpec customInfo = this.getImmediateCustomInfo(schema);
        ClassTemplateSpec result = null;
        TyperefDataSchema originalTyperefSchema = null;
        while (schema.getType() == DataSchema.Type.TYPEREF) {
            TyperefDataSchema typerefSchema = (TyperefDataSchema)schema;
            if (originalTyperefSchema == null) {
                originalTyperefSchema = typerefSchema;
            }
            ClassTemplateSpec found = this._schemaToClassMap.get(schema);
            schema = typerefSchema.getRef();
            if (found == null) {
                if (schema.getType() == DataSchema.Type.UNION) {
                    result = this.generateUnion((UnionDataSchema)schema, typerefSchema);
                    break;
                }
                this.generateTyperef(typerefSchema, originalTyperefSchema);
                continue;
            }
            if (schema.getType() != DataSchema.Type.UNION) continue;
            result = found;
            break;
        }
        if (result == null) {
            assert (schema == schema.getDereferencedDataSchema());
            if (schema instanceof ComplexDataSchema) {
                ClassTemplateSpec found = this._schemaToClassMap.get(schema);
                result = found == null ? (schema instanceof NamedDataSchema ? this.generateNamedSchema((NamedDataSchema)schema) : this.generateUnnamedComplexSchema(schema, enclosingClass, memberName)) : found;
                if (customInfo != null) {
                    result = customInfo.getCustomClass();
                }
            } else if (schema instanceof PrimitiveDataSchema) {
                ClassTemplateSpec classTemplateSpec = result = customInfo != null ? customInfo.getCustomClass() : this.getPrimitiveClassForSchema((PrimitiveDataSchema)schema, enclosingClass, memberName);
            }
        }
        if (result == null) {
            throw TemplateSpecGenerator.unrecognizedSchemaType(enclosingClass, memberName, schema);
        }
        result.setOriginalTyperefSchema(originalTyperefSchema);
        return result;
    }

    private CustomClasses getCustomClasses(DataSchema schema) {
        return TemplateSpecGenerator.getCustomClasses(schema, this._customTypeLanguage);
    }

    public static CustomClasses getCustomClasses(DataSchema schema, String customTypeLanguage) {
        Object java;
        CustomClasses customClasses = null;
        Map properties = schema.getProperties();
        if (customTypeLanguage != null && (java = properties.get(customTypeLanguage)) != null) {
            Object coercerClass;
            if (java.getClass() != DataMap.class) {
                throw new IllegalArgumentException(schema + " has \"" + customTypeLanguage + "\" property that is not a DataMap");
            }
            DataMap map = (DataMap)java;
            Object custom = map.get((Object)"class");
            if (custom != null) {
                if (custom.getClass() != String.class) {
                    throw new IllegalArgumentException(schema + " has \"" + customTypeLanguage + "\" property with \"class\" that is not a string");
                }
                customClasses = new CustomClasses();
                customClasses.customClass = new ClassTemplateSpec();
                customClasses.customClass.setFullName((String)custom);
                if (!TemplateSpecGenerator.allowCustomClass(schema)) {
                    throw new IllegalArgumentException(schema + " cannot have custom class binding");
                }
            }
            if ((coercerClass = map.get((Object)"coercerClass")) != null) {
                if (coercerClass.getClass() != String.class) {
                    throw new IllegalArgumentException(schema + " has \"" + customTypeLanguage + "\" property with \"coercerClass\" that is not a string");
                }
                if (customClasses == null) {
                    throw new IllegalArgumentException(schema + " has \"" + customTypeLanguage + "\" property with \"coercerClass\" but does not have \"class\" property");
                }
                customClasses.customCoercerClass = new ClassTemplateSpec();
                customClasses.customCoercerClass.setFullName((String)coercerClass);
            }
        }
        return customClasses;
    }

    private CustomInfoSpec getImmediateCustomInfo(DataSchema schema) {
        if (this._immediateCustomMap.containsKey(schema)) {
            return this._immediateCustomMap.get(schema);
        }
        CustomInfoSpec immediate = null;
        DataSchema current = schema;
        while (current != null) {
            CustomClasses customClasses = this.getCustomClasses(current);
            if (customClasses != null) {
                immediate = new CustomInfoSpec((NamedDataSchema)schema, (NamedDataSchema)current, customClasses.customClass, customClasses.customCoercerClass);
                break;
            }
            current = TemplateSpecGenerator.dereferenceIfTyperef(current);
        }
        this._immediateCustomMap.put(schema, immediate);
        return immediate;
    }

    private ClassTemplateSpec getPrimitiveClassForSchema(PrimitiveDataSchema schema, ClassTemplateSpec enclosingClass, String memberName) {
        switch (schema.getType()) {
            case INT: 
            case DOUBLE: 
            case BOOLEAN: 
            case STRING: 
            case LONG: 
            case FLOAT: 
            case BYTES: {
                return PrimitiveTemplateSpec.getInstance(schema.getType());
            }
            case NULL: {
                throw TemplateSpecGenerator.nullTypeNotAllowed(enclosingClass, memberName);
            }
        }
        throw TemplateSpecGenerator.unrecognizedSchemaType(enclosingClass, memberName, (DataSchema)schema);
    }

    private ClassTemplateSpec generateNamedSchema(NamedDataSchema schema) {
        ClassTemplateSpec templateClass;
        this.pushCurrentLocation((DataSchemaLocation)this._schemaResolver.nameToDataSchemaLocations().get(schema.getFullName()));
        String className = schema.getBindingName();
        this.checkForClassNameConflict(className, (DataSchema)schema);
        switch (schema.getType()) {
            case RECORD: {
                templateClass = this.generateRecord((RecordDataSchema)schema);
                break;
            }
            case ENUM: {
                templateClass = this.generateEnum((EnumDataSchema)schema);
                break;
            }
            case FIXED: {
                templateClass = this.generateFixed((FixedDataSchema)schema);
                break;
            }
            default: {
                throw TemplateSpecGenerator.unrecognizedSchemaType(null, null, (DataSchema)schema);
            }
        }
        this.popCurrentLocation();
        return templateClass;
    }

    private ClassTemplateSpec generateUnnamedComplexSchema(DataSchema schema, ClassTemplateSpec enclosingClass, String memberName) {
        if (schema instanceof ArrayDataSchema) {
            return this.generateArray((ArrayDataSchema)schema, enclosingClass, memberName);
        }
        if (schema instanceof MapDataSchema) {
            return this.generateMap((MapDataSchema)schema, enclosingClass, memberName);
        }
        if (schema instanceof UnionDataSchema) {
            return this.generateUnion((UnionDataSchema)schema, enclosingClass, memberName);
        }
        throw TemplateSpecGenerator.unrecognizedSchemaType(enclosingClass, memberName, schema);
    }

    private ClassTemplateSpec determineDataClass(DataSchema schema, ClassTemplateSpec enclosingClass, String memberName) {
        DataSchema dereferencedSchema = schema.getDereferencedDataSchema();
        ClassTemplateSpec result = dereferencedSchema.getType() == DataSchema.Type.ENUM ? PrimitiveTemplateSpec.getInstance(DataSchema.Type.STRING) : (CodeUtil.isDirectType(dereferencedSchema) ? this.getPrimitiveClassForSchema((PrimitiveDataSchema)dereferencedSchema, enclosingClass, memberName) : null);
        return result;
    }

    private ArrayTemplateSpec generateArray(ArrayDataSchema schema, ClassTemplateSpec enclosingClass, String memberName) {
        DataSchema itemSchema = schema.getItems();
        ClassInfo classInfo = this.classInfoForUnnamed(enclosingClass, memberName, (DataSchema)schema);
        if (classInfo.existingClass != null) {
            this.processSchema(itemSchema, enclosingClass, memberName);
            return (ArrayTemplateSpec)classInfo.existingClass;
        }
        ArrayTemplateSpec arrayClass = (ArrayTemplateSpec)classInfo.definedClass;
        this.registerClassTemplateSpec((DataSchema)schema, arrayClass);
        arrayClass.setItemClass(this.processSchema(itemSchema, enclosingClass, memberName));
        arrayClass.setItemDataClass(this.determineDataClass(itemSchema, enclosingClass, memberName));
        CustomInfoSpec customInfo = this.getImmediateCustomInfo(itemSchema);
        arrayClass.setCustomInfo(customInfo);
        return arrayClass;
    }

    private MapTemplateSpec generateMap(MapDataSchema schema, ClassTemplateSpec enclosingClass, String memberName) {
        DataSchema valueSchema = schema.getValues();
        ClassInfo classInfo = this.classInfoForUnnamed(enclosingClass, memberName, (DataSchema)schema);
        if (classInfo.existingClass != null) {
            this.processSchema(valueSchema, enclosingClass, memberName);
            return (MapTemplateSpec)classInfo.existingClass;
        }
        MapTemplateSpec mapClass = (MapTemplateSpec)classInfo.definedClass;
        this.registerClassTemplateSpec((DataSchema)schema, mapClass);
        mapClass.setValueClass(this.processSchema(valueSchema, enclosingClass, memberName));
        mapClass.setValueDataClass(this.determineDataClass(valueSchema, enclosingClass, memberName));
        CustomInfoSpec customInfo = this.getImmediateCustomInfo(valueSchema);
        mapClass.setCustomInfo(customInfo);
        return mapClass;
    }

    private UnionTemplateSpec generateUnion(UnionDataSchema schema, ClassTemplateSpec enclosingClass, String memberName) {
        if (enclosingClass == null || memberName == null) {
            throw new IllegalArgumentException("Cannot processSchema template for top level union: " + schema);
        }
        ClassInfo classInfo = this.classInfoForUnnamed(enclosingClass, memberName, (DataSchema)schema);
        if (classInfo.existingClass != null) {
            return (UnionTemplateSpec)classInfo.existingClass;
        }
        UnionTemplateSpec unionClass = (UnionTemplateSpec)classInfo.definedClass;
        this.registerClassTemplateSpec((DataSchema)schema, unionClass);
        return this.generateUnion(schema, unionClass);
    }

    private ClassTemplateSpec generateUnion(UnionDataSchema schema, TyperefDataSchema typerefDataSchema) {
        assert (typerefDataSchema.getRef() == schema);
        this.pushCurrentLocation((DataSchemaLocation)this._schemaResolver.nameToDataSchemaLocations().get(typerefDataSchema.getFullName()));
        UnionTemplateSpec unionClass = new UnionTemplateSpec(schema);
        unionClass.setNamespace(typerefDataSchema.getNamespace());
        unionClass.setPackage(typerefDataSchema.getPackage());
        unionClass.setClassName(typerefDataSchema.getName());
        unionClass.setModifiers(ModifierSpec.PUBLIC);
        this.registerClassTemplateSpec((DataSchema)typerefDataSchema, unionClass);
        TyperefTemplateSpec typerefInfoClass = new TyperefTemplateSpec(typerefDataSchema);
        typerefInfoClass.setEnclosingClass(unionClass);
        typerefInfoClass.setClassName("UnionTyperefInfo");
        typerefInfoClass.setModifiers(ModifierSpec.PRIVATE, ModifierSpec.STATIC, ModifierSpec.FINAL);
        UnionTemplateSpec result = this.generateUnion(schema, unionClass);
        result.setTyperefClass(typerefInfoClass);
        this.popCurrentLocation();
        return result;
    }

    private UnionTemplateSpec generateUnion(UnionDataSchema schema, UnionTemplateSpec unionClass) {
        IdentityHashMap customInfoMap = new IdentityHashMap(schema.getTypes().size() * 2);
        for (DataSchema memberType : schema.getTypes()) {
            UnionTemplateSpec.Member newMember = new UnionTemplateSpec.Member();
            unionClass.getMembers().add(newMember);
            newMember.setSchema(memberType);
            if (memberType.getDereferencedType() == DataSchema.Type.NULL) continue;
            newMember.setClassTemplateSpec(this.processSchema(memberType, unionClass, memberType.getUnionMemberKey()));
            newMember.setDataClass(this.determineDataClass(memberType, unionClass, memberType.getUnionMemberKey()));
            CustomInfoSpec customInfo = this.getImmediateCustomInfo(memberType);
            if (customInfo == null) continue;
            if (!customInfoMap.containsKey(customInfo)) {
                customInfoMap.put(customInfo, null);
            }
            newMember.setCustomInfo(customInfo);
        }
        return unionClass;
    }

    private ClassTemplateSpec generateEnum(EnumDataSchema schema) {
        EnumTemplateSpec enumClass = new EnumTemplateSpec(schema);
        enumClass.setNamespace(schema.getNamespace());
        enumClass.setPackage(schema.getPackage());
        enumClass.setClassName(schema.getName());
        enumClass.setModifiers(ModifierSpec.PUBLIC);
        this.registerClassTemplateSpec((DataSchema)schema, enumClass);
        return enumClass;
    }

    private ClassTemplateSpec generateFixed(FixedDataSchema schema) {
        FixedTemplateSpec fixedClass = new FixedTemplateSpec(schema);
        fixedClass.setNamespace(schema.getNamespace());
        fixedClass.setPackage(schema.getPackage());
        fixedClass.setClassName(schema.getName());
        fixedClass.setModifiers(ModifierSpec.PUBLIC);
        this.registerClassTemplateSpec((DataSchema)schema, fixedClass);
        return fixedClass;
    }

    private TyperefTemplateSpec generateTyperef(TyperefDataSchema schema, TyperefDataSchema originalTyperefSchema) {
        TyperefTemplateSpec typerefClass = new TyperefTemplateSpec(schema);
        typerefClass.setOriginalTyperefSchema(originalTyperefSchema);
        typerefClass.setNamespace(schema.getNamespace());
        typerefClass.setPackage(schema.getPackage());
        typerefClass.setClassName(schema.getName());
        typerefClass.setModifiers(ModifierSpec.PUBLIC);
        this.registerClassTemplateSpec((DataSchema)schema, typerefClass);
        return typerefClass;
    }

    private RecordTemplateSpec generateRecord(RecordDataSchema schema) {
        RecordTemplateSpec recordClass = new RecordTemplateSpec(schema);
        recordClass.setNamespace(schema.getNamespace());
        recordClass.setPackage(schema.getPackage());
        recordClass.setClassName(schema.getName());
        recordClass.setModifiers(ModifierSpec.PUBLIC);
        this.registerClassTemplateSpec((DataSchema)schema, recordClass);
        List includes = schema.getInclude();
        for (NamedDataSchema includedSchema : includes) {
            this.processSchema((DataSchema)includedSchema, null, null);
        }
        IdentityHashMap customInfoMap = new IdentityHashMap(schema.getFields().size() * 2);
        for (RecordDataSchema.Field field : schema.getFields()) {
            ClassTemplateSpec fieldClass = this.processSchema(field.getType(), recordClass, field.getName());
            RecordTemplateSpec.Field newField = new RecordTemplateSpec.Field();
            newField.setSchemaField(field);
            newField.setType(fieldClass);
            newField.setDataClass(this.determineDataClass(field.getType(), recordClass, field.getName()));
            CustomInfoSpec customInfo = this.getImmediateCustomInfo(field.getType());
            if (customInfo != null) {
                if (!customInfoMap.containsKey(customInfo)) {
                    customInfoMap.put(customInfo, null);
                }
                newField.setCustomInfo(customInfo);
            }
            recordClass.addField(newField);
        }
        return recordClass;
    }

    private ClassInfo classInfoForUnnamed(ClassTemplateSpec enclosingClass, String name, DataSchema schema) {
        assert (!(schema instanceof NamedDataSchema));
        assert (!(schema instanceof PrimitiveDataSchema));
        ClassInfo classInfo = this.classNameForUnnamedTraverse(enclosingClass, name, schema);
        String className = classInfo.bindingName();
        DataSchema schemaFromClassName = this._classNameToSchemaMap.get(className);
        if (schemaFromClassName == null) {
            ClassTemplateSpec classTemplateSpec = ClassTemplateSpec.createFromDataSchema(schema);
            if (enclosingClass != null && classInfo.namespace.equals(enclosingClass.getFullName())) {
                classTemplateSpec.setEnclosingClass(enclosingClass);
                classTemplateSpec.setClassName(classInfo.name);
                classTemplateSpec.setModifiers(ModifierSpec.PUBLIC, ModifierSpec.STATIC, ModifierSpec.FINAL);
            } else {
                classTemplateSpec.setNamespace(classInfo.namespace);
                classTemplateSpec.setClassName(classInfo.name);
                classTemplateSpec.setPackage(classInfo.packageName);
                classTemplateSpec.setModifiers(ModifierSpec.PUBLIC);
            }
            classInfo.definedClass = classTemplateSpec;
        } else {
            this.checkForClassNameConflict(className, schema);
            classInfo.existingClass = this._schemaToClassMap.get(schemaFromClassName);
        }
        return classInfo;
    }

    private ClassInfo classNameForUnnamedTraverse(ClassTemplateSpec enclosingClass, String memberName, DataSchema schema) {
        DataSchema dereferencedDataSchema = schema.getDereferencedDataSchema();
        switch (dereferencedDataSchema.getType()) {
            case ARRAY: {
                ArrayDataSchema arraySchema = (ArrayDataSchema)dereferencedDataSchema;
                CustomInfoSpec customInfo = this.getImmediateCustomInfo(arraySchema.getItems());
                if (customInfo != null) {
                    return new ClassInfo(customInfo.getCustomSchema().getNamespace(), customInfo.getCustomSchema().getName() + ARRAY_SUFFIX, customInfo.getCustomSchema().getPackage());
                }
                ClassInfo classInfo = this.classNameForUnnamedTraverse(enclosingClass, memberName, arraySchema.getItems());
                classInfo.name = classInfo.name + ARRAY_SUFFIX;
                return classInfo;
            }
            case MAP: {
                MapDataSchema mapSchema = (MapDataSchema)dereferencedDataSchema;
                CustomInfoSpec customInfo = this.getImmediateCustomInfo(mapSchema.getValues());
                if (customInfo != null) {
                    return new ClassInfo(customInfo.getCustomSchema().getNamespace(), customInfo.getCustomSchema().getName() + MAP_SUFFIX, customInfo.getCustomSchema().getPackage());
                }
                ClassInfo classInfo = this.classNameForUnnamedTraverse(enclosingClass, memberName, mapSchema.getValues());
                classInfo.name = classInfo.name + MAP_SUFFIX;
                return classInfo;
            }
            case UNION: {
                if (schema.getType() == DataSchema.Type.TYPEREF) {
                    DataSchema referencedDataSchema;
                    TyperefDataSchema typerefDataSchema = (TyperefDataSchema)schema;
                    while ((referencedDataSchema = typerefDataSchema.getDereferencedDataSchema()) != dereferencedDataSchema) {
                        typerefDataSchema = (TyperefDataSchema)referencedDataSchema;
                    }
                    return new ClassInfo(typerefDataSchema.getNamespace(), CodeUtil.capitalize(typerefDataSchema.getName()), typerefDataSchema.getPackage());
                }
                return new ClassInfo(enclosingClass.getFullName(), CodeUtil.capitalize(memberName));
            }
            case RECORD: 
            case ENUM: 
            case FIXED: {
                NamedDataSchema namedSchema = (NamedDataSchema)dereferencedDataSchema;
                return new ClassInfo(namedSchema.getNamespace(), CodeUtil.capitalize(namedSchema.getName()), namedSchema.getPackage());
            }
            case BOOLEAN: {
                return new ClassInfo(this._templatePackageName, "Boolean");
            }
            case INT: {
                return new ClassInfo(this._templatePackageName, "Integer");
            }
            case LONG: {
                return new ClassInfo(this._templatePackageName, "Long");
            }
            case FLOAT: {
                return new ClassInfo(this._templatePackageName, "Float");
            }
            case DOUBLE: {
                return new ClassInfo(this._templatePackageName, "Double");
            }
            case STRING: {
                return new ClassInfo(this._templatePackageName, "String");
            }
            case BYTES: {
                return new ClassInfo(this._templatePackageName, "ByteString");
            }
            case NULL: {
                throw TemplateSpecGenerator.nullTypeNotAllowed(enclosingClass, memberName);
            }
        }
        throw TemplateSpecGenerator.unrecognizedSchemaType(enclosingClass, memberName, dereferencedDataSchema);
    }

    private static class ClassInfo {
        private String namespace;
        private String name;
        private String packageName;
        private ClassTemplateSpec existingClass;
        private ClassTemplateSpec definedClass;

        private ClassInfo(String namespace, String name) {
            this.namespace = namespace;
            this.name = name;
        }

        private ClassInfo(String namespace, String name, String packageName) {
            this.namespace = namespace;
            this.name = name;
            this.packageName = packageName;
        }

        private String fullName() {
            return this.namespace.isEmpty() ? this.name : this.namespace + '.' + this.name;
        }

        private String bindingName() {
            return this.packageName == null || this.packageName.isEmpty() ? this.fullName() : this.packageName + "." + this.name;
        }
    }

    private static class CustomClasses {
        private ClassTemplateSpec customClass;
        private ClassTemplateSpec customCoercerClass;

        private CustomClasses() {
        }
    }
}

