/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.gobblin.runtime.metastore.filesystem;

import java.io.IOException;

import org.apache.gobblin.metastore.DatasetStateStore;
import org.apache.gobblin.metastore.metadata.DatasetStateStoreEntryManager;
import org.apache.gobblin.runtime.FsDatasetStateStore;
import org.apache.gobblin.runtime.JobState;
import org.apache.hadoop.fs.FileStatus;


/**
 * A {@link DatasetStateStoreEntryManager} generated by {@link FsDatasetStateStore}.
 */
public class FsDatasetStateStoreEntryManager extends DatasetStateStoreEntryManager<JobState.DatasetState> {

  private final FsDatasetStateStore stateStore;

  public FsDatasetStateStoreEntryManager(FileStatus fileStatus, FsDatasetStateStore stateStore) {
    super(fileStatus.getPath().getParent().getName(), fileStatus.getPath().getName(), fileStatus.getModificationTime(),
        new DatasetStateStore.TableNameParser(fileStatus.getPath().getName()), stateStore);
    this.stateStore = stateStore;
  }

  @Override
  public JobState.DatasetState readState() throws IOException {
    return this.stateStore.getInternal(getStoreName(), getTableName(), getSanitizedDatasetUrn(), true);
  }

  @Override
  public void delete() throws IOException {
    this.stateStore.delete(getStoreName(), getTableName());
  }
}
