/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.geode.distributed.internal.FunctionExecutionPooledExecutor;
import org.apache.geode.distributed.internal.OverflowQueueWithDMStats;
import org.apache.geode.distributed.internal.PoolStatHelper;
import org.apache.geode.distributed.internal.PooledExecutorWithDMStats;
import org.apache.geode.distributed.internal.QueueStatHelper;
import org.apache.geode.distributed.internal.SerialQueuedExecutorWithDMStats;
import org.apache.geode.internal.ScheduledThreadPoolExecutorWithKeepAlive;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.logging.internal.executors.LoggingThreadFactory;

public class CoreLoggingExecutors {
    public static ExecutorService newSerialThreadPool(String threadName, LoggingThreadFactory.ThreadInitializer threadInitializer, LoggingThreadFactory.CommandWrapper commandWrapper, PoolStatHelper stats, ThreadsMonitoring threadsMonitoring, BlockingQueue<Runnable> feed) {
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, threadInitializer, commandWrapper);
        return new SerialQueuedExecutorWithDMStats(feed, stats, (ThreadFactory)threadFactory, threadsMonitoring);
    }

    public static ExecutorService newSerialThreadPoolWithFeedStatistics(String threadName, LoggingThreadFactory.ThreadInitializer threadInitializer, LoggingThreadFactory.CommandWrapper commandWrapper, PoolStatHelper poolStats, ThreadsMonitoring threadsMonitoring, int feedSize, QueueStatHelper feedStats) {
        BlockingQueue<Runnable> feed = CoreLoggingExecutors.createFeedWithStatistics(feedSize, feedStats);
        return CoreLoggingExecutors.newSerialThreadPool(threadName, threadInitializer, commandWrapper, poolStats, threadsMonitoring, feed);
    }

    public static ExecutorService newSerialThreadPoolWithUnlimitedFeed(String threadName, LoggingThreadFactory.ThreadInitializer threadInitializer, LoggingThreadFactory.CommandWrapper commandWrapper, PoolStatHelper stats, ThreadsMonitoring threadsMonitoring) {
        LinkedBlockingQueue<Runnable> feed = new LinkedBlockingQueue<Runnable>();
        return CoreLoggingExecutors.newSerialThreadPool(threadName, threadInitializer, commandWrapper, stats, threadsMonitoring, feed);
    }

    public static ExecutorService newThreadPoolWithUnlimitedFeed(String threadName, LoggingThreadFactory.ThreadInitializer threadInitializer, LoggingThreadFactory.CommandWrapper commandWrapper, int poolSize, PoolStatHelper poolStats, int msTimeout, ThreadsMonitoring threadsMonitoring) {
        LinkedBlockingQueue<Runnable> feed = new LinkedBlockingQueue<Runnable>();
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, threadInitializer, commandWrapper);
        return new PooledExecutorWithDMStats(feed, poolSize, poolStats, (ThreadFactory)threadFactory, msTimeout, threadsMonitoring);
    }

    public static ExecutorService newThreadPoolWithFixedFeed(String threadName, LoggingThreadFactory.CommandWrapper commandWrapper, int poolSize, PoolStatHelper poolStats, int msTimeout, ThreadsMonitoring threadsMonitoring, int feedSize) {
        ArrayBlockingQueue<Runnable> feed = new ArrayBlockingQueue<Runnable>(feedSize);
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, commandWrapper);
        return new PooledExecutorWithDMStats(feed, poolSize, poolStats, (ThreadFactory)threadFactory, msTimeout, threadsMonitoring);
    }

    public static ExecutorService newFunctionThreadPoolWithFeedStatistics(String threadName, LoggingThreadFactory.ThreadInitializer threadInitializer, LoggingThreadFactory.CommandWrapper commandWrapper, int poolSize, PoolStatHelper poolStats, ThreadsMonitoring threadsMonitoring, int feedSize, QueueStatHelper feedStats) {
        BlockingQueue<Runnable> feed = CoreLoggingExecutors.createFeedWithStatistics(feedSize, feedStats);
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, threadInitializer, commandWrapper);
        return new FunctionExecutionPooledExecutor(feed, poolSize, poolStats, (ThreadFactory)threadFactory, true, threadsMonitoring);
    }

    private static BlockingQueue<Runnable> createFeedWithStatistics(int feedSize, QueueStatHelper feedStats) {
        OverflowQueueWithDMStats<Runnable> feed = feedSize == 0 ? new OverflowQueueWithDMStats<Runnable>(feedStats) : new OverflowQueueWithDMStats(feedSize, feedStats);
        return feed;
    }

    public static ExecutorService newThreadPoolWithFeedStatistics(String threadName, LoggingThreadFactory.ThreadInitializer threadInitializer, LoggingThreadFactory.CommandWrapper commandWrapper, int poolSize, PoolStatHelper poolStats, ThreadsMonitoring threadsMonitoring, int feedSize, QueueStatHelper feedStats) {
        BlockingQueue<Runnable> feed = CoreLoggingExecutors.createFeedWithStatistics(feedSize, feedStats);
        return CoreLoggingExecutors.newThreadPool(threadName, threadInitializer, commandWrapper, poolSize, poolStats, threadsMonitoring, feed);
    }

    public static ExecutorService newThreadPool(String threadName, LoggingThreadFactory.ThreadInitializer threadInitializer, LoggingThreadFactory.CommandWrapper commandWrapper, int poolSize, PoolStatHelper poolStats, ThreadsMonitoring threadsMonitoring, BlockingQueue<Runnable> feed) {
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, threadInitializer, commandWrapper);
        return new PooledExecutorWithDMStats(feed, poolSize, poolStats, (ThreadFactory)threadFactory, threadsMonitoring, "gemfire.");
    }

    public static ExecutorService newThreadPoolWithSynchronousFeed(String threadName, LoggingThreadFactory.CommandWrapper commandWrapper, int poolSize) {
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, commandWrapper);
        SynchronousQueue<Runnable> feed = new SynchronousQueue<Runnable>();
        return new PooledExecutorWithDMStats(feed, poolSize, (ThreadFactory)threadFactory, null, "gemfire.");
    }

    public static ExecutorService newThreadPoolWithSynchronousFeed(String threadName, LoggingThreadFactory.CommandWrapper commandWrapper, int poolSize, PoolStatHelper poolStats, int msTimeout, ThreadsMonitoring threadsMonitoring) {
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, commandWrapper);
        SynchronousQueue<Runnable> feed = new SynchronousQueue<Runnable>();
        return new PooledExecutorWithDMStats(feed, poolSize, poolStats, (ThreadFactory)threadFactory, msTimeout, threadsMonitoring);
    }

    public static ExecutorService newThreadPoolWithSynchronousFeed(String threadName, int poolSize, PoolStatHelper stats, int msTimeout, RejectedExecutionHandler rejectionHandler) {
        SynchronousQueue<Runnable> feed = new SynchronousQueue<Runnable>();
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName);
        return new PooledExecutorWithDMStats(feed, poolSize, stats, (ThreadFactory)threadFactory, msTimeout, rejectionHandler, null);
    }

    public static ExecutorService newThreadPoolWithSynchronousFeed(String threadName, LoggingThreadFactory.ThreadInitializer threadInitializer, LoggingThreadFactory.CommandWrapper commandWrapper, int corePoolSize, int maximumPoolSize, long keepAliveSeconds) {
        SynchronousQueue<Runnable> blockingQueue = new SynchronousQueue<Runnable>();
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, threadInitializer, commandWrapper);
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveSeconds, TimeUnit.SECONDS, blockingQueue, (ThreadFactory)threadFactory);
    }

    public static ExecutorService newThreadPoolWithSynchronousFeed(String threadName, int corePoolSize, int maximumPoolSize, long keepAliveSeconds) {
        return CoreLoggingExecutors.newThreadPoolWithSynchronousFeed(threadName, null, null, corePoolSize, maximumPoolSize, keepAliveSeconds);
    }

    public static ExecutorService newThreadPoolWithSynchronousFeedThatHandlesRejection(String threadName, LoggingThreadFactory.ThreadInitializer threadInitializer, LoggingThreadFactory.CommandWrapper commandWrapper, int corePoolSize, int maximumPoolSize, long keepAliveSeconds) {
        SynchronousQueue<Runnable> blockingQueue = new SynchronousQueue<Runnable>();
        RejectedExecutionHandler rejectedExecutionHandler = (r, pool) -> {
            try {
                blockingQueue.put(r);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new RejectedExecutionException("interrupted", ex);
            }
        };
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, threadInitializer, commandWrapper);
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveSeconds, TimeUnit.SECONDS, blockingQueue, (ThreadFactory)threadFactory, rejectedExecutionHandler);
    }

    public static ExecutorService newFixedThreadPoolWithTimeout(String threadName, int poolSize, int keepAliveSeconds, QueueStatHelper feedStats) {
        BlockingQueue<Runnable> feed = CoreLoggingExecutors.createFeedWithStatistics(0, feedStats);
        return LoggingExecutors.newFixedThreadPool((String)threadName, (boolean)true, (int)poolSize, (long)keepAliveSeconds, feed);
    }

    public static ScheduledExecutorService newScheduledThreadPool(String threadName, int poolSize, int keepAliveMillis, ThreadsMonitoring threadsMonitoring) {
        ScheduledThreadPoolExecutorWithKeepAlive result = new ScheduledThreadPoolExecutorWithKeepAlive(poolSize, (long)keepAliveMillis, TimeUnit.MILLISECONDS, (ThreadFactory)new LoggingThreadFactory(threadName), threadsMonitoring);
        result.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        result.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        return result;
    }

    private CoreLoggingExecutors() {
    }
}

