/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.distributed.internal.PoolStatHelper;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class FunctionExecutionPooledExecutor
extends ThreadPoolExecutor {
    protected final PoolStatHelper stats;
    private final ThreadsMonitoring threadMonitoring;
    private static final Logger logger = LogService.getLogger();
    private static final int OFFER_TIME = Integer.getInteger("gemfire.RETRY_INTERVAL", 5000);
    @MakeNotStatic
    private static final InheritableThreadLocal<Boolean> isFunctionExecutionThread = new InheritableThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    protected BlockingQueue<Runnable> bufferQueue;
    Thread bufferConsumer;

    public static boolean isFunctionExecutionThread() {
        return (Boolean)isFunctionExecutionThread.get();
    }

    public FunctionExecutionPooledExecutor(BlockingQueue<Runnable> q, int maxPoolSize, PoolStatHelper stats, ThreadFactory tf, int msTimeout, RejectedExecutionHandler reh, ThreadsMonitoring tMonitoring) {
        super(FunctionExecutionPooledExecutor.getCorePoolSize(maxPoolSize), maxPoolSize, msTimeout, TimeUnit.MILLISECONDS, q, tf, reh);
        this.stats = stats;
        this.threadMonitoring = tMonitoring;
    }

    private static BlockingQueue<Runnable> initQ(BlockingQueue<Runnable> q) {
        if (q instanceof SynchronousQueue) {
            return q;
        }
        return new SynchronousQueue<Runnable>();
    }

    private static RejectedExecutionHandler initREH(final BlockingQueue<Runnable> q, boolean forFnExec) {
        if (forFnExec) {
            return new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                    if (executor.isShutdown()) {
                        throw new RejectedExecutionException("executor has been shutdown");
                    }
                    if (this.isBufferConsumer(executor)) {
                        this.handleRejectedExecutionForBufferConsumer(r, executor);
                    } else if (this.isFunctionExecutionThread()) {
                        this.handleRejectedExecutionForFunctionExecutionThread(r, executor);
                    } else {
                        try {
                            q.put(r);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                }

                private boolean isBufferConsumer(ThreadPoolExecutor executor) {
                    return Thread.currentThread() == ((FunctionExecutionPooledExecutor)executor).bufferConsumer;
                }

                private boolean isFunctionExecutionThread() {
                    return (Boolean)isFunctionExecutionThread.get();
                }

                private void handleRejectedExecutionForBufferConsumer(Runnable r, ThreadPoolExecutor executor) {
                    logger.warn("An additional Function Execution Processor thread is being launched because all " + executor.getMaximumPoolSize() + " thread pool threads are in use for greater than " + OFFER_TIME + " ms");
                    this.launchAdditionalThread(r, executor);
                }

                private void handleRejectedExecutionForFunctionExecutionThread(Runnable r, ThreadPoolExecutor executor) {
                    if (logger.isDebugEnabled()) {
                        logger.warn("An additional Function Execution Processor thread is being launched to prevent slow performance due to nested function executions");
                    }
                    this.launchAdditionalThread(r, executor);
                }

                private void launchAdditionalThread(Runnable r, ThreadPoolExecutor executor) {
                    Thread th = executor.getThreadFactory().newThread(r);
                    th.start();
                }
            };
        }
        if (q instanceof SynchronousQueue) {
            return new ThreadPoolExecutor.CallerRunsPolicy();
        }
        return new BufferHandler();
    }

    public FunctionExecutionPooledExecutor(BlockingQueue<Runnable> q, int maxPoolSize, PoolStatHelper stats, ThreadFactory tf, int msTimeout, final boolean forFnExec, ThreadsMonitoring tMonitoring) {
        this(FunctionExecutionPooledExecutor.initQ(q), maxPoolSize, stats, tf, msTimeout, FunctionExecutionPooledExecutor.initREH(q, forFnExec), tMonitoring);
        if (!(q instanceof SynchronousQueue)) {
            this.bufferQueue = q;
            final BlockingQueue<Runnable> takeQueue = q;
            final BlockingQueue<Runnable> putQueue = this.getQueue();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            SystemFailure.checkFailure();
                            Runnable task = (Runnable)takeQueue.take();
                            if (forFnExec) {
                                if (putQueue.offer(task, OFFER_TIME, TimeUnit.MILLISECONDS)) continue;
                                FunctionExecutionPooledExecutor.this.execute(task);
                                continue;
                            }
                            putQueue.put(task);
                        }
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            };
            this.bufferConsumer = tf.newThread(r);
            this.bufferConsumer.start();
        }
    }

    public static void setIsFunctionExecutionThread(Boolean isExecutionThread) {
        isFunctionExecutionThread.set(isExecutionThread);
    }

    @Override
    public void shutdown() {
        try {
            super.shutdown();
        }
        finally {
            this.terminated();
        }
    }

    @Override
    protected void terminated() {
        if (this.bufferConsumer != null) {
            this.bufferConsumer.interrupt();
        }
        super.terminated();
    }

    public List shutdownNow() {
        this.terminated();
        List<Runnable> l = super.shutdownNow();
        if (this.bufferQueue != null) {
            this.bufferQueue.drainTo(l);
        }
        return l;
    }

    public FunctionExecutionPooledExecutor(BlockingQueue<Runnable> q, int poolSize, PoolStatHelper stats, ThreadFactory tf, ThreadsMonitoring tMonitoring) {
        this(q, poolSize, stats, tf, (int)Integer.getInteger("gemfire.IDLE_THREAD_TIMEOUT", 1800000), false, tMonitoring);
    }

    public FunctionExecutionPooledExecutor(BlockingQueue<Runnable> q, int poolSize, PoolStatHelper stats, ThreadFactory tf, boolean forFnExec, ThreadsMonitoring tMonitoring) {
        this(q, poolSize, stats, tf, (int)Integer.getInteger("gemfire.IDLE_THREAD_TIMEOUT", 1800000), forFnExec, tMonitoring);
    }

    public FunctionExecutionPooledExecutor(BlockingQueue<Runnable> q, int poolSize, ThreadFactory tf, ThreadsMonitoring tMonitoring) {
        this(q, poolSize, null, tf, tMonitoring);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        if (this.stats != null) {
            this.stats.startJob();
        }
        if (this.threadMonitoring != null) {
            this.threadMonitoring.startMonitor(ThreadsMonitoring.Mode.FunctionExecutor);
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable ex) {
        if (this.stats != null) {
            this.stats.endJob();
        }
        if (this.threadMonitoring != null) {
            this.threadMonitoring.endMonitor();
        }
    }

    private static int getCorePoolSize(int maxSize) {
        if (maxSize == Integer.MAX_VALUE) {
            return 0;
        }
        return 1;
    }

    public static class BufferHandler
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (executor.isShutdown()) {
                throw new RejectedExecutionException("executor has been shutdown");
            }
            try {
                FunctionExecutionPooledExecutor pool = (FunctionExecutionPooledExecutor)executor;
                pool.bufferQueue.put(r);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                RejectedExecutionException e = new RejectedExecutionException("interrupted");
                e.initCause(ie);
                throw e;
            }
        }
    }

    public static class BlockHandler
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (executor.isShutdown()) {
                throw new RejectedExecutionException("executor has been shutdown");
            }
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                RejectedExecutionException e = new RejectedExecutionException("interrupted");
                e.initCause(ie);
                throw e;
            }
        }
    }
}

