/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLException;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.InvalidDeltaException;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.client.ServerRefusedConnectionException;
import org.apache.geode.cache.client.SocketFactory;
import org.apache.geode.cache.client.internal.AuthenticateUserOp;
import org.apache.geode.cache.client.internal.ClientUpdater;
import org.apache.geode.cache.client.internal.Endpoint;
import org.apache.geode.cache.client.internal.EndpointManager;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.GetEventValueOp;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.QueueManager;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.tcpserver.HostAndPort;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.InternalInstantiator;
import org.apache.geode.internal.cache.ClientServerObserver;
import org.apache.geode.internal.cache.ClientServerObserverHolder;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.ClientSideHandshake;
import org.apache.geode.internal.cache.tier.InterestType;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.sockets.CacheServerHelper;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.MessageStats;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.ServerQueueStatus;
import org.apache.geode.internal.cache.tier.sockets.ServerResponseMatrix;
import org.apache.geode.internal.cache.versions.ConcurrentCacheModificationException;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.sequencelog.EntryLogger;
import org.apache.geode.internal.serialization.ByteArrayDataInput;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.statistics.StatisticsTypeFactoryImpl;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.pdx.PdxSerializationException;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.AuthenticationRequiredException;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.logging.log4j.Logger;

public class CacheClientUpdater
extends LoggingThread
implements ClientUpdater,
InternalDistributedSystem.DisconnectListener {
    private static final Logger logger = LogService.getLogger();
    private static final int DEFAULT_SOCKET_BUFFER_SIZE = 32768;
    private final boolean connected;
    private final DistributedSystem system;
    private final Socket socket;
    private final OutputStream out;
    private final InputStream in;
    private ServerQueueStatus serverQueueStatus;
    private volatile ClientUpdater failedUpdater;
    private final ByteBuffer commBuffer;
    private boolean commBufferReleased;
    private final CCUStats stats;
    private InternalCache cache;
    private CachedRegionHelper cacheHelper;
    private final AtomicBoolean continueProcessing = new AtomicBoolean(true);
    private final boolean isDurableClient;
    private final InternalDistributedMember serverId;
    private final boolean isPrimary;
    private boolean isOpCompleted;
    public static final String CLIENT_UPDATER_THREAD_NAME = "Cache Client Updater Thread ";
    @MutableForTesting
    public static boolean isUsedByTest;
    @MutableForTesting
    static boolean fullValueRequested;
    private final ServerLocation location;
    private final QueueManager qManager;
    private final EndpointManager eManager;
    private final Endpoint endpoint;
    private static final long MAX_CACHE_WAIT;

    public ServerQueueStatus getServerQueueStatus() {
        return this.serverQueueStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean waitForCache() {
        long tilt = System.currentTimeMillis() + MAX_CACHE_WAIT * 1000L;
        while (true) {
            if (this.quitting()) {
                logger.warn("{}: abandoned wait due to cancellation.", (Object)this);
                return false;
            }
            if (!this.connected) {
                logger.warn("{}: abandoned wait because it is no longer connected", (Object)this);
                return false;
            }
            if (System.currentTimeMillis() > tilt) {
                logger.warn("{}: wait timed out (more than {} seconds)", new Object[]{this, MAX_CACHE_WAIT});
                return false;
            }
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            if (cache != null && !cache.isClosed()) {
                this.cache = cache;
                this.cacheHelper = new CachedRegionHelper(cache);
                return true;
            }
            boolean interrupted = Thread.interrupted();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException ignore) {
                interrupted = true;
                continue;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    public CacheClientUpdater(String name, ServerLocation location, boolean primary, DistributedSystem ids, ClientSideHandshake handshake, QueueManager qManager, EndpointManager eManager, Endpoint endpoint, int handshakeTimeout, SocketCreator socketCreator, SocketFactory socketFactory) throws AuthenticationRequiredException, AuthenticationFailedException, ServerRefusedConnectionException {
        this(name, location, primary, ids, handshake, qManager, eManager, endpoint, handshakeTimeout, socketCreator, new StatisticsProvider(), socketFactory);
    }

    public CacheClientUpdater(String name, ServerLocation location, boolean primary, DistributedSystem distributedSystem, ClientSideHandshake handshake, QueueManager qManager, EndpointManager eManager, Endpoint endpoint, int handshakeTimeout, SocketCreator socketCreator, StatisticsProvider statisticsProvider, SocketFactory socketFactory) throws AuthenticationRequiredException, AuthenticationFailedException, ServerRefusedConnectionException {
        super(name);
        this.system = distributedSystem;
        this.isDurableClient = handshake.isDurable();
        this.isPrimary = primary;
        this.location = location;
        this.qManager = qManager;
        this.eManager = eManager;
        this.endpoint = endpoint;
        this.stats = statisticsProvider.createStatistics(distributedSystem, location);
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("Creating asynchronous update connection");
        }
        boolean success = false;
        Socket mySock = null;
        InternalDistributedMember sid = null;
        ByteBuffer cb = null;
        OutputStream tmpOut = null;
        InputStream tmpIn = null;
        try {
            PoolImpl pool;
            int socketBufferSize = Integer.getInteger("BridgeServer.SOCKET_BUFFER_SIZE", 32768);
            mySock = socketCreator.forClient().connect(new HostAndPort(location.getHostName(), location.getPort()), handshakeTimeout, socketBufferSize, socketFactory::createSocket);
            mySock.setTcpNoDelay(true);
            mySock.setSendBufferSize(socketBufferSize);
            this.verifySocketBufferSize(socketBufferSize, mySock.getReceiveBufferSize(), "receive");
            this.verifySocketBufferSize(socketBufferSize, mySock.getSendBufferSize(), "send");
            mySock.setSoTimeout(handshakeTimeout);
            tmpOut = mySock.getOutputStream();
            tmpIn = mySock.getInputStream();
            if (isDebugEnabled) {
                logger.debug("Initialized server-to-client socket with send buffer size: {} bytes and receive buffer size: {} bytes", (Object)mySock.getSendBufferSize(), (Object)mySock.getReceiveBufferSize());
            }
            if (isDebugEnabled) {
                logger.debug("Created connection from {}:{} to CacheClientNotifier on port {} for server-to-client communication", (Object)mySock.getInetAddress().getHostAddress(), (Object)mySock.getLocalPort(), (Object)mySock.getPort());
            }
            this.serverQueueStatus = handshake.handshakeWithSubscriptionFeed(mySock, this.isPrimary);
            if ((this.serverQueueStatus.isPrimary() || this.serverQueueStatus.isNonRedundant()) && !(pool = (PoolImpl)this.qManager.getPool()).getReadyForEventsCalled()) {
                pool.setPendingEventCount(this.serverQueueStatus.getServerQueueSize());
            }
            int bufSize = 1024;
            try {
                bufSize = mySock.getSendBufferSize();
                if (bufSize < 1024) {
                    bufSize = 1024;
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            cb = ServerConnection.allocateCommBuffer(bufSize, mySock);
            sid = new InternalDistributedMember(mySock.getInetAddress(), mySock.getPort(), false, true);
            success = true;
        }
        catch (ConnectException ignore) {
            if (!this.quitting()) {
                logger.warn("{} connection was refused", (Object)this);
            }
        }
        catch (SSLException ex) {
            if (!this.quitting()) {
                this.getSecurityLogger().warning(String.format("%s SSL negotiation failed. %s", this, ex));
                throw new AuthenticationFailedException(String.format("SSL negotiation failed with endpoint: %s", location), ex);
            }
        }
        catch (GemFireSecurityException ex) {
            if (!this.quitting()) {
                this.getSecurityLogger().warning(String.format("%s: Security exception when creating server-to-client communication socket. %s", this, ex));
                throw ex;
            }
        }
        catch (IOException e) {
            if (!this.quitting()) {
                logger.warn(String.format("%s: Caught following exception while attempting to create a server-to-client communication socket and will exit: %s", this, e), (Throwable)(logger.isDebugEnabled() ? e : null));
            }
            eManager.serverCrashed(this.endpoint);
        }
        catch (ClassNotFoundException e) {
            if (!this.quitting()) {
                logger.warn("Unable to load the class: {}", (Object)e.getMessage());
            }
        }
        catch (ServerRefusedConnectionException e) {
            if (!this.quitting()) {
                logger.warn(String.format("%s: Caught following exception while attempting to create a server-to-client communication socket and will exit: %s", this, e), (Throwable)(logger.isDebugEnabled() ? e : null));
            }
            throw e;
        }
        finally {
            this.connected = success;
            this.socket = mySock;
            this.commBuffer = cb;
            this.out = tmpOut;
            this.in = tmpIn;
            this.serverId = sid;
            if (this.connected) {
                if (mySock != null) {
                    try {
                        mySock.setSoTimeout(0);
                    }
                    catch (SocketException ignore) {}
                }
            } else {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseCommBuffer() {
        if (!this.commBufferReleased && this.commBuffer != null) {
            ByteBuffer byteBuffer = this.commBuffer;
            synchronized (byteBuffer) {
                if (!this.commBufferReleased) {
                    this.commBufferReleased = true;
                    ServerConnection.releaseCommBuffer(this.commBuffer);
                }
            }
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean isPrimary() {
        return this.isPrimary;
    }

    private InternalLogWriter getSecurityLogger() {
        return this.qManager.getSecurityLogger();
    }

    @Override
    public void setFailedUpdater(ClientUpdater failedUpdater) {
        this.failedUpdater = failedUpdater;
    }

    public void run() {
        EntryLogger.setSource(this.serverId, "RI");
        boolean addedListener = false;
        try {
            if (this.system instanceof InternalDistributedSystem) {
                ((InternalDistributedSystem)this.system).addDisconnectListener(this);
                addedListener = true;
            }
            if (!this.waitForCache()) {
                logger.warn("{}: no cache (exiting)", (Object)this);
                return;
            }
            this.processMessages();
        }
        catch (CancelException cancelException) {
        }
        finally {
            if (addedListener) {
                ((InternalDistributedSystem)this.system).removeDisconnectListener(this);
            }
            this.close();
            EntryLogger.clearSource();
        }
    }

    private void stopProcessing() {
        this.continueProcessing.set(false);
    }

    private void stopUpdater() {
        block6: {
            boolean isSelfDestroying = Thread.currentThread() == this;
            this.stopProcessing();
            if (this.isAlive()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Stopping {}", (Object)this.location, (Object)this);
                }
                if (!isSelfDestroying) {
                    this.interrupt();
                    try {
                        if (this.socket != null) {
                            this.socket.close();
                        }
                    }
                    catch (IOException e) {
                        if (!logger.isDebugEnabled()) break block6;
                        logger.debug(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public void close() {
        this.continueProcessing.set(false);
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.cacheHelper != null) {
            this.cacheHelper.close();
        }
        this.releaseCommBuffer();
        this.stats.close();
    }

    private Message initializeMessage() {
        Message message = new Message(2, KnownVersion.CURRENT);
        message.setComms(this.socket, this.in, this.out, this.commBuffer, this.stats);
        return message;
    }

    public String toString() {
        return this.getName() + " (" + this.location.getHostName() + ':' + this.location.getPort() + ')';
    }

    private void handleMarker(Message clientMessage) {
        try {
            boolean isDebugEnabled = logger.isDebugEnabled();
            if (isDebugEnabled) {
                logger.debug("Received marker message of length ({} bytes)", (Object)clientMessage.getPayloadLength());
            }
            this.qManager.getState().processMarker();
            if (isDebugEnabled) {
                logger.debug("Processed marker message");
            }
        }
        catch (Exception e) {
            String message = "The following exception occurred while attempting to handle a marker.";
            this.handleException(message, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUpdate(Message clientMessage) {
        String regionName = null;
        Object key = null;
        Part valuePart = null;
        boolean isDebugEnabled = logger.isDebugEnabled();
        try {
            boolean isValueObject;
            boolean isCreate;
            VersionTag versionTag;
            this.isOpCompleted = false;
            if (isDebugEnabled) {
                logger.debug("Received put message of length ({} bytes)", (Object)clientMessage.getPayloadLength());
            }
            int partCnt = 0;
            Part regionNamePart = clientMessage.getPart(partCnt++);
            Part keyPart = clientMessage.getPart(partCnt++);
            boolean isDeltaSent = (Boolean)clientMessage.getPart(partCnt++).getObject();
            valuePart = clientMessage.getPart(partCnt++);
            Part callbackArgumentPart = clientMessage.getPart(partCnt++);
            if ((versionTag = (VersionTag)clientMessage.getPart(partCnt++).getObject()) != null) {
                versionTag.replaceNullIDs((InternalDistributedMember)this.endpoint.getMemberId());
            }
            Part isInterestListPassedPart = clientMessage.getPart(partCnt++);
            Part hasCqsPart = clientMessage.getPart(partCnt++);
            EventID eventId = (EventID)clientMessage.getPart(clientMessage.getNumberOfParts() - 1).getObject();
            boolean withInterest = (Boolean)isInterestListPassedPart.getObject();
            boolean withCQs = (Boolean)hasCqsPart.getObject();
            regionName = regionNamePart.getCachedString();
            key = keyPart.getStringOrObject();
            Object callbackArgument = callbackArgumentPart.getObject();
            boolean bl = isCreate = clientMessage.getMessageType() == 27;
            if (isDebugEnabled) {
                logger.debug("Putting entry for region: {} key: {} create: {}{} callbackArgument: {} withInterest={} withCQs={} eventID={} version={}", (Object)regionName, key, (Object)isCreate, (Object)(valuePart.isObject() ? new StringBuilder(" value: ").append(this.deserialize(valuePart.getSerializedForm())) : ""), callbackArgument, (Object)withInterest, (Object)withCQs, (Object)eventId, (Object)versionTag);
            }
            LocalRegion region = (LocalRegion)this.cacheHelper.getRegion(regionName);
            byte[] deltaBytes = null;
            Object objectValue = null;
            if (!isDeltaSent) {
                byte[] serializedForm = valuePart.getSerializedForm();
                if (!isCreate || !InternalDataSerializer.isSerializedNull(serializedForm)) {
                    objectValue = valuePart.getSerializedForm();
                }
                if (withCQs) {
                    objectValue = valuePart.getObject();
                }
                isValueObject = valuePart.isObject();
            } else {
                deltaBytes = valuePart.getSerializedForm();
                isValueObject = true;
            }
            if (region == null) {
                if (isDebugEnabled && !this.quitting()) {
                    logger.debug("{}: Region named {} does not exist", (Object)this, (Object)regionName);
                }
            } else if (region.hasServerProxy() && ServerResponseMatrix.checkForValidStateAfterNotification(region, key, clientMessage.getMessageType()) && (withInterest || !withCQs)) {
                EntryEventImpl newEvent = null;
                try {
                    newEvent = EntryEventImpl.create((InternalRegion)region, clientMessage.getMessageType() == 27 ? Operation.CREATE : Operation.UPDATE, key, null, callbackArgument, true, eventId.getDistributedMember());
                    newEvent.setVersionTag(versionTag);
                    newEvent.setFromServer(true);
                    region.basicBridgeClientUpdate(eventId.getDistributedMember(), key, objectValue, deltaBytes, isValueObject, callbackArgument, clientMessage.getMessageType() == 27, this.qManager.getState().getProcessedMarker() || !this.isDurableClient, newEvent, eventId);
                    this.isOpCompleted = true;
                    if (withCQs && isDeltaSent) {
                        objectValue = newEvent.getNewValue();
                    }
                }
                catch (InvalidDeltaException ignore) {
                    Part fullValuePart = this.requestFullValue(eventId, "Caught InvalidDeltaException.");
                    region.getCachePerfStats().incDeltaFullValuesRequested();
                    objectValue = fullValuePart.getObject();
                    isValueObject = fullValuePart.isObject();
                    region.basicBridgeClientUpdate(eventId.getDistributedMember(), key, objectValue, null, isValueObject, callbackArgument, clientMessage.getMessageType() == 27, this.qManager.getState().getProcessedMarker() || !this.isDurableClient, newEvent, eventId);
                    this.isOpCompleted = true;
                }
                finally {
                    if (newEvent != null) {
                        newEvent.release();
                    }
                }
                if (isDebugEnabled) {
                    logger.debug("Put entry for region: {} key: {} callbackArgument: {}", (Object)regionName, key, callbackArgument);
                }
            }
            if (withCQs) {
                Part numCqsPart = clientMessage.getPart(partCnt++);
                if (isDebugEnabled) {
                    logger.debug("Received message has CQ Event. Number of cqs interested in the event : {}", (Object)(numCqsPart.getInt() / 2));
                }
                this.processCqs(clientMessage, partCnt, numCqsPart.getInt(), clientMessage.getMessageType(), key, objectValue, deltaBytes, eventId);
                this.isOpCompleted = true;
            }
        }
        catch (Exception e) {
            String message = String.format("The following exception occurred while attempting to put entry (region: %s key: %s value: %s)", regionName, key, this.deserialize(valuePart.getSerializedForm()));
            this.handleException(message, e);
        }
    }

    private Part requestFullValue(EventID eventId, String reason) throws Exception {
        Part result;
        boolean isDebugEnabled;
        if (isUsedByTest) {
            fullValueRequested = true;
        }
        if (isDebugEnabled = logger.isDebugEnabled()) {
            logger.debug("{} Requesting full value...", (Object)reason);
        }
        if ((result = (Part)GetEventValueOp.executeOnPrimary(this.qManager.getPool(), eventId, null)) == null) {
            throw new Exception("Could not retrieve full value for " + eventId);
        }
        if (isDebugEnabled) {
            logger.debug("Full value received.");
        }
        return result;
    }

    private void handleInvalidate(Message clientMessage) {
        String regionName = null;
        Object key = null;
        boolean isDebugEnabled = logger.isDebugEnabled();
        try {
            LocalRegion region;
            VersionTag versionTag;
            this.isOpCompleted = false;
            if (isDebugEnabled) {
                logger.debug("Received invalidate message of length ({} bytes)", (Object)clientMessage.getPayloadLength());
            }
            int partCnt = 0;
            Part regionNamePart = clientMessage.getPart(partCnt++);
            Part keyPart = clientMessage.getPart(partCnt++);
            Part callbackArgumentPart = clientMessage.getPart(partCnt++);
            if ((versionTag = (VersionTag)clientMessage.getPart(partCnt++).getObject()) != null) {
                versionTag.replaceNullIDs((InternalDistributedMember)this.endpoint.getMemberId());
            }
            Part isInterestListPassedPart = clientMessage.getPart(partCnt++);
            Part hasCqsPart = clientMessage.getPart(partCnt++);
            regionName = regionNamePart.getCachedString();
            key = keyPart.getStringOrObject();
            Object callbackArgument = callbackArgumentPart.getObject();
            boolean withInterest = (Boolean)isInterestListPassedPart.getObject();
            boolean withCQs = (Boolean)hasCqsPart.getObject();
            if (isDebugEnabled) {
                logger.debug("Invalidating entry for region: {} key: {} callbackArgument: {} withInterest={} withCQs={} version={}", (Object)regionName, key, callbackArgument, (Object)withInterest, (Object)withCQs, (Object)versionTag);
            }
            if ((region = (LocalRegion)this.cacheHelper.getRegion(regionName)) == null) {
                if (isDebugEnabled && !this.quitting()) {
                    logger.debug("Region named {} does not exist", (Object)regionName);
                }
            } else if (region.hasServerProxy() && (withInterest || !withCQs)) {
                try {
                    Part eid = clientMessage.getPart(clientMessage.getNumberOfParts() - 1);
                    EventID eventId = (EventID)eid.getObject();
                    try {
                        region.basicBridgeClientInvalidate(eventId.getDistributedMember(), key, callbackArgument, this.qManager.getState().getProcessedMarker() || !this.isDurableClient, eventId, versionTag);
                    }
                    catch (ConcurrentCacheModificationException concurrentCacheModificationException) {
                        // empty catch block
                    }
                    this.isOpCompleted = true;
                    this.qManager.getState().incrementInvalidatedStats();
                    if (isDebugEnabled) {
                        logger.debug("Invalidated entry for region: {} key: {} callbackArgument: {}", (Object)regionName, key, callbackArgument);
                    }
                }
                catch (EntryNotFoundException ignore) {
                    if (isDebugEnabled && !this.quitting()) {
                        logger.debug("Already invalidated entry for region: {} key: {} callbackArgument: {}", (Object)regionName, key, callbackArgument);
                    }
                    this.isOpCompleted = true;
                }
            }
            if (withCQs) {
                Part regionOpType = clientMessage.getPart(partCnt++);
                Part numCqsPart = clientMessage.getPart(partCnt++);
                if (isDebugEnabled) {
                    logger.debug("Received message has CQ Event. Number of cqs interested in the event : {}", (Object)(numCqsPart.getInt() / 2));
                }
                this.processCqs(clientMessage, partCnt, numCqsPart.getInt(), regionOpType.getInt(), key, null);
                this.isOpCompleted = true;
            }
        }
        catch (Exception e) {
            String message = String.format("The following exception occurred while attempting to invalidate entry (region: %s key: %s)", regionName, key);
            this.handleException(message, e);
        }
    }

    private void handleDestroy(Message clientMessage) {
        String regionName = null;
        Object key = null;
        boolean isDebugEnabled = logger.isDebugEnabled();
        try {
            LocalRegion region;
            VersionTag versionTag;
            this.isOpCompleted = false;
            if (isDebugEnabled) {
                logger.debug("Received destroy message of length ({} bytes)", (Object)clientMessage.getPayloadLength());
            }
            int partCnt = 0;
            Part regionNamePart = clientMessage.getPart(partCnt++);
            Part keyPart = clientMessage.getPart(partCnt++);
            Part callbackArgumentPart = clientMessage.getPart(partCnt++);
            if ((versionTag = (VersionTag)clientMessage.getPart(partCnt++).getObject()) != null) {
                versionTag.replaceNullIDs((InternalDistributedMember)this.endpoint.getMemberId());
            }
            regionName = regionNamePart.getCachedString();
            key = keyPart.getStringOrObject();
            Part isInterestListPassedPart = clientMessage.getPart(partCnt++);
            Part hasCqsPart = clientMessage.getPart(partCnt++);
            boolean withInterest = (Boolean)isInterestListPassedPart.getObject();
            boolean withCQs = (Boolean)hasCqsPart.getObject();
            Object callbackArgument = callbackArgumentPart.getObject();
            if (isDebugEnabled) {
                logger.debug("Destroying entry for region: {} key: {} callbackArgument: {} withInterest={} withCQs={} version={}", (Object)regionName, key, callbackArgument, (Object)withInterest, (Object)withCQs, (Object)versionTag);
            }
            if ((region = (LocalRegion)this.cacheHelper.getRegion(regionName)) == null) {
                if (isDebugEnabled && !this.quitting()) {
                    logger.debug("Region named {} does not exist", (Object)regionName);
                }
            } else if (region.hasServerProxy() && (withInterest || !withCQs)) {
                EventID eventId = null;
                try {
                    Part eid = clientMessage.getPart(clientMessage.getNumberOfParts() - 1);
                    eventId = (EventID)eid.getObject();
                    try {
                        region.basicBridgeClientDestroy(eventId.getDistributedMember(), key, callbackArgument, this.qManager.getState().getProcessedMarker() || !this.isDurableClient, eventId, versionTag);
                    }
                    catch (ConcurrentCacheModificationException concurrentCacheModificationException) {
                        // empty catch block
                    }
                    this.isOpCompleted = true;
                    if (isDebugEnabled) {
                        logger.debug("Destroyed entry for region: {} key: {} callbackArgument: {}", (Object)regionName, key, callbackArgument);
                    }
                }
                catch (EntryNotFoundException ignore) {
                    if (isDebugEnabled && !this.quitting()) {
                        logger.debug("Already destroyed entry for region: {} key: {} callbackArgument: {} eventId={}", (Object)regionName, key, callbackArgument, (Object)eventId.expensiveToString());
                    }
                    this.isOpCompleted = true;
                }
            }
            if (withCQs) {
                Part numCqsPart = clientMessage.getPart(partCnt++);
                if (isDebugEnabled) {
                    logger.debug("Received message has CQ Event. Number of cqs interested in the event : {}", (Object)(numCqsPart.getInt() / 2));
                }
                this.processCqs(clientMessage, partCnt, numCqsPart.getInt(), clientMessage.getMessageType(), key, null);
                this.isOpCompleted = true;
            }
        }
        catch (Exception e) {
            String message = String.format("The following exception occurred while attempting to destroy entry (region: %s key: %s)", regionName, key);
            this.handleException(message, e);
        }
    }

    private void handleDestroyRegion(Message clientMessage) {
        String regionName = null;
        boolean isDebugEnabled = logger.isDebugEnabled();
        try {
            LocalRegion region;
            if (isDebugEnabled) {
                logger.debug("Received destroy region message of length ({} bytes)", (Object)clientMessage.getPayloadLength());
            }
            int partCnt = 0;
            Part regionNamePart = clientMessage.getPart(partCnt++);
            Part callbackArgumentPart = clientMessage.getPart(partCnt++);
            regionName = regionNamePart.getCachedString();
            Object callbackArgument = callbackArgumentPart.getObject();
            Part hasCqsPart = clientMessage.getPart(partCnt++);
            if (isDebugEnabled) {
                logger.debug("Destroying region: {} callbackArgument: {}", (Object)regionName, callbackArgument);
            }
            if (((Boolean)hasCqsPart.getObject()).booleanValue()) {
                Part numCqsPart = clientMessage.getPart(partCnt++);
                if (isDebugEnabled) {
                    logger.debug("Received message has CQ Event. Number of cqs interested in the event : {}", (Object)(numCqsPart.getInt() / 2));
                }
                this.processCqs(clientMessage, partCnt, numCqsPart.getInt(), clientMessage.getMessageType(), null, null);
            }
            if ((region = (LocalRegion)this.cacheHelper.getRegion(regionName)) == null) {
                if (isDebugEnabled && !this.quitting()) {
                    logger.debug("Region named {} does not exist", (Object)regionName);
                }
                return;
            }
            if (region.hasServerProxy()) {
                region.localDestroyRegion(callbackArgument);
                if (isDebugEnabled) {
                    logger.debug("Destroyed region: {} callbackArgument: {}", (Object)regionName, callbackArgument);
                }
            }
        }
        catch (RegionDestroyedException ignore) {
            if (isDebugEnabled) {
                logger.debug("region already destroyed: {}", regionName);
            }
        }
        catch (Exception e) {
            String message = String.format("Caught an exception while attempting to destroy region %s", regionName);
            this.handleException(message, e);
        }
    }

    private void handleClearRegion(Message clientMessage) {
        String regionName = null;
        boolean isDebugEnabled = logger.isDebugEnabled();
        try {
            LocalRegion region;
            if (isDebugEnabled) {
                logger.debug("{}: Received clear region message of length ({} bytes)", (Object)this, (Object)clientMessage.getPayloadLength());
            }
            int partCnt = 0;
            Part regionNamePart = clientMessage.getPart(partCnt++);
            Part callbackArgumentPart = clientMessage.getPart(partCnt++);
            Part hasCqsPart = clientMessage.getPart(partCnt++);
            regionName = regionNamePart.getCachedString();
            Object callbackArgument = callbackArgumentPart.getObject();
            if (isDebugEnabled) {
                logger.debug("Clearing region: {} callbackArgument: {}", (Object)regionName, callbackArgument);
            }
            if (((Boolean)hasCqsPart.getObject()).booleanValue()) {
                Part numCqsPart = clientMessage.getPart(partCnt++);
                if (isDebugEnabled) {
                    logger.debug("Received message has CQ Event. Number of cqs interested in the event : {}", (Object)(numCqsPart.getInt() / 2));
                }
                this.processCqs(clientMessage, partCnt, numCqsPart.getInt(), clientMessage.getMessageType(), null, null);
            }
            if ((region = (LocalRegion)this.cacheHelper.getRegion(regionName)) == null) {
                if (isDebugEnabled && !this.quitting()) {
                    logger.debug("Region named {} does not exist", (Object)regionName);
                }
                return;
            }
            if (region.hasServerProxy()) {
                region.basicBridgeClientClear(callbackArgument, this.qManager.getState().getProcessedMarker() || !this.isDurableClient);
                if (isDebugEnabled) {
                    logger.debug("Cleared region: {} callbackArgument: {}", (Object)regionName, callbackArgument);
                }
            }
        }
        catch (Exception e) {
            String message = String.format("Caught the following exception while attempting to clear region %s", regionName);
            this.handleException(message, e);
        }
    }

    private void handleInvalidateRegion(Message clientMessage) {
        String regionName = null;
        boolean isDebugEnabled = logger.isDebugEnabled();
        try {
            LocalRegion region;
            if (isDebugEnabled) {
                logger.debug("{}: Received invalidate region message of length ({} bytes)", (Object)this, (Object)clientMessage.getPayloadLength());
            }
            int partCnt = 0;
            Part regionNamePart = clientMessage.getPart(partCnt++);
            int n = ++partCnt;
            ++partCnt;
            Part hasCqsPart = clientMessage.getPart(n);
            regionName = regionNamePart.getCachedString();
            if (((Boolean)hasCqsPart.getObject()).booleanValue()) {
                Part numCqsPart = clientMessage.getPart(partCnt++);
                if (isDebugEnabled) {
                    logger.debug("Received message has CQ Event. Number of cqs interested in the event : {}", (Object)(numCqsPart.getInt() / 2));
                }
                this.processCqs(clientMessage, partCnt, numCqsPart.getInt(), clientMessage.getMessageType(), null, null);
            }
            if ((region = (LocalRegion)this.cacheHelper.getRegion(regionName)) == null && isDebugEnabled && !this.quitting()) {
                logger.debug("Region named {} does not exist", (Object)regionName);
            }
        }
        catch (Exception e) {
            String message = String.format("Caught the following exception while attempting to invalidate region %s.", regionName);
            this.handleException(message, e);
        }
    }

    private void handleRegisterInstantiator(Message clientMessage, EventID eventId) {
        block5: {
            String instantiatorClassName = null;
            boolean isDebugEnabled = logger.isDebugEnabled();
            try {
                int noOfParts = clientMessage.getNumberOfParts();
                if (isDebugEnabled) {
                    logger.debug("{}: Received register instantiators message of parts {}", (Object)this.getName(), (Object)noOfParts);
                }
                Assert.assertTrue((noOfParts - 1) % 3 == 0);
                for (int i = 0; i < noOfParts - 1; i += 3) {
                    instantiatorClassName = (String)CacheServerHelper.deserialize(clientMessage.getPart(i).getSerializedForm());
                    String instantiatedClassName = (String)CacheServerHelper.deserialize(clientMessage.getPart(i + 1).getSerializedForm());
                    int id = clientMessage.getPart(i + 2).getInt();
                    InternalInstantiator.register(instantiatorClassName, instantiatedClassName, id, false, eventId, null);
                }
                if (PoolImpl.IS_INSTANTIATOR_CALLBACK) {
                    ClientServerObserver clientServerObserver = ClientServerObserverHolder.getInstance();
                    clientServerObserver.afterReceivingFromServer(eventId);
                }
            }
            catch (Exception e) {
                if (!isDebugEnabled) break block5;
                logger.debug("{}: Caught following exception while attempting to read Instantiator : {}", (Object)this, instantiatorClassName, (Object)e);
            }
        }
    }

    private void handleRegisterDataSerializer(Message msg, EventID eventId) {
        block8: {
            Object dataSerializerClass = null;
            boolean isDebugEnabled = logger.isDebugEnabled();
            try {
                int noOfParts = msg.getNumberOfParts();
                if (isDebugEnabled) {
                    logger.debug("{}: Received register dataserializer message of parts {}", (Object)this.getName(), (Object)noOfParts);
                }
                int i = 0;
                while (i < noOfParts - 1) {
                    try {
                        int j;
                        String dataSerializerClassName = (String)CacheServerHelper.deserialize(msg.getPart(i).getSerializedForm());
                        int id = msg.getPart(i + 1).getInt();
                        InternalDataSerializer.register(dataSerializerClassName, false, eventId, null, id);
                        int numOfClasses = msg.getPart(i + 2).getInt();
                        for (j = 0; j < numOfClasses; ++j) {
                            String className = (String)CacheServerHelper.deserialize(msg.getPart(i + 3 + j).getSerializedForm());
                            InternalDataSerializer.updateSupportedClassesMap(dataSerializerClassName, className);
                        }
                        i += 3 + j;
                    }
                    catch (ClassNotFoundException e) {
                        if (!isDebugEnabled) continue;
                        logger.debug("{}: Caught following exception while attempting to read DataSerializer : {}", (Object)this, dataSerializerClass, (Object)e);
                    }
                }
                if (PoolImpl.IS_INSTANTIATOR_CALLBACK) {
                    ClientServerObserver bo = ClientServerObserverHolder.getInstance();
                    bo.afterReceivingFromServer(eventId);
                }
            }
            catch (Exception e) {
                if (!isDebugEnabled) break block8;
                logger.debug("{}: Caught following exception while attempting to read DataSerializer : {}", (Object)this, dataSerializerClass, (Object)e);
            }
        }
    }

    private int processCqs(Message clientMessage, int startMessagePart, int numCqParts, int messageType, Object key, Object value) {
        return this.processCqs(clientMessage, startMessagePart, numCqParts, messageType, key, value, null, null);
    }

    private int processCqs(Message clientMessage, int startMessagePart, int numCqParts, int messageType, Object key, Object value, byte[] delta, EventID eventId) {
        block7: {
            HashMap<String, Integer> cqs = new HashMap<String, Integer>();
            boolean isDebugEnabled = logger.isDebugEnabled();
            int cqCnt = 0;
            while (cqCnt < numCqParts) {
                StringBuilder sb = null;
                if (isDebugEnabled) {
                    sb = new StringBuilder(100);
                    sb.append("found these queries: ");
                }
                try {
                    Part cqNamePart = clientMessage.getPart(startMessagePart + cqCnt++);
                    Part cqOpPart = clientMessage.getPart(startMessagePart + cqCnt++);
                    cqs.put(cqNamePart.getString(), cqOpPart.getInt());
                    if (sb != null) {
                        sb.append(cqNamePart.getString()).append(" op=").append(cqOpPart.getInt()).append("  ");
                    }
                }
                catch (Exception ignore) {
                    logger.warn("Error while processing the CQ Message. Problem with reading message for CQ# : {}", (Object)cqCnt);
                }
                if (!isDebugEnabled) continue;
                logger.debug((CharSequence)sb);
            }
            CqService cqService = this.cache.getCqService();
            try {
                cqService.dispatchCqListeners(cqs, messageType, key, value, delta, this.qManager, eventId);
            }
            catch (Exception ex) {
                logger.warn("Failed to invoke CQ Dispatcher. Error :  {}", (Object)ex.getMessage());
                if (!isDebugEnabled) break block7;
                logger.debug("Failed to invoke CQ Dispatcher.", (Throwable)ex);
            }
        }
        return startMessagePart + numCqParts;
    }

    private void handleRegisterInterest(Message clientMessage) {
        String regionName = null;
        Object key = null;
        boolean isDebugEnabled = logger.isDebugEnabled();
        try {
            if (isDebugEnabled) {
                logger.debug("{}: Received add interest message of length ({} bytes)", (Object)this, (Object)clientMessage.getPayloadLength());
            }
            int partCnt = 0;
            Part regionNamePart = clientMessage.getPart(partCnt++);
            Part keyPart = clientMessage.getPart(partCnt++);
            Part interestTypePart = clientMessage.getPart(partCnt++);
            Part interestResultPolicyPart = clientMessage.getPart(partCnt++);
            Part isDurablePart = clientMessage.getPart(partCnt++);
            Part receiveUpdatesAsInvalidatesPart = clientMessage.getPart(partCnt);
            regionName = regionNamePart.getCachedString();
            key = keyPart.getStringOrObject();
            InterestType interestType2 = InterestType.valueOf((Integer)interestTypePart.getObject());
            byte interestResultPolicy = (Byte)interestResultPolicyPart.getObject();
            boolean isDurable = (Boolean)isDurablePart.getObject();
            boolean receiveUpdatesAsInvalidates = (Boolean)receiveUpdatesAsInvalidatesPart.getObject();
            LocalRegion region = (LocalRegion)this.cacheHelper.getRegion(regionName);
            if (region == null) {
                if (isDebugEnabled && !this.quitting()) {
                    logger.debug("{}: Region named {} does not exist", (Object)this, (Object)regionName);
                }
                return;
            }
            if (!region.hasServerProxy()) {
                return;
            }
            if (key instanceof List) {
                region.getServerProxy().addListInterest((List)key, InterestResultPolicy.fromOrdinal(interestResultPolicy), isDurable, receiveUpdatesAsInvalidates);
            } else {
                region.getServerProxy().addSingleInterest(key, interestType2, InterestResultPolicy.fromOrdinal(interestResultPolicy), isDurable, receiveUpdatesAsInvalidates);
            }
        }
        catch (Exception e) {
            String message = ": The following exception occurred while attempting to add interest (region: " + regionName + " key: " + key + "): ";
            this.handleException(message, e);
        }
    }

    private void handleUnregisterInterest(Message clientMessage) {
        String regionName = null;
        Object key = null;
        boolean isDebugEnabled = logger.isDebugEnabled();
        try {
            if (isDebugEnabled) {
                logger.debug("{}: Received remove interest message of length ({} bytes)", (Object)this, (Object)clientMessage.getPayloadLength());
            }
            int partCnt = 0;
            Part regionNamePart = clientMessage.getPart(partCnt++);
            Part keyPart = clientMessage.getPart(partCnt++);
            Part interestTypePart = clientMessage.getPart(partCnt++);
            Part isDurablePart = clientMessage.getPart(partCnt++);
            Part receiveUpdatesAsInvalidatesPart = clientMessage.getPart(partCnt);
            regionName = regionNamePart.getCachedString();
            key = keyPart.getStringOrObject();
            InterestType interestType2 = InterestType.valueOf((Integer)interestTypePart.getObject());
            boolean isDurable = (Boolean)isDurablePart.getObject();
            boolean receiveUpdatesAsInvalidates = (Boolean)receiveUpdatesAsInvalidatesPart.getObject();
            LocalRegion region = (LocalRegion)this.cacheHelper.getRegion(regionName);
            if (region == null) {
                if (isDebugEnabled) {
                    logger.debug("{}: Region named {} does not exist", (Object)this, (Object)regionName);
                }
                return;
            }
            if (!region.hasServerProxy()) {
                return;
            }
            if (key instanceof List) {
                region.getServerProxy().removeListInterest((List)key, isDurable, receiveUpdatesAsInvalidates);
            } else {
                region.getServerProxy().removeSingleInterest(key, interestType2, isDurable, receiveUpdatesAsInvalidates);
            }
        }
        catch (Exception e) {
            String message = ": The following exception occurred while attempting to add interest (region: " + regionName + " key: " + key + "): ";
            this.handleException(message, e);
        }
    }

    private void handleTombstoneOperation(Message clientMessage) {
        String regionName = "unknown";
        try {
            int partIdx = 0;
            regionName = clientMessage.getPart(partIdx++).getCachedString();
            int op = clientMessage.getPart(partIdx++).getInt();
            LocalRegion region = (LocalRegion)this.cacheHelper.getRegion(regionName);
            if (region == null) {
                if (!this.quitting() && logger.isDebugEnabled()) {
                    logger.debug("{}: Region named {} does not exist", (Object)this, (Object)regionName);
                }
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Received tombstone operation for region {} with operation={}", (Object)this, (Object)region, (Object)op);
            }
            if (!region.getConcurrencyChecksEnabled()) {
                return;
            }
            switch (op) {
                case 0: {
                    Map regionGCVersions = (Map)clientMessage.getPart(partIdx++).getObject();
                    EventID eventID = (EventID)clientMessage.getPart(partIdx).getObject();
                    region.expireTombstones(regionGCVersions, eventID, null);
                    break;
                }
                case 1: {
                    Set removedKeys = (Set)clientMessage.getPart(partIdx).getObject();
                    region.expireTombstoneKeys(removedKeys);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown operation type " + op);
                }
            }
        }
        catch (Exception e) {
            this.handleException(": exception while removing tombstones from " + regionName, e);
        }
    }

    private boolean quitting() {
        if (this.isInterrupted()) {
            return true;
        }
        if (!this.continueProcessing.get()) {
            return true;
        }
        if (this.cache != null && this.cache.getCancelCriterion().isCancelInProgress()) {
            return true;
        }
        return this.system.getCancelCriterion().isCancelInProgress();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForFailedUpdater() {
        block8: {
            boolean gotInterrupted = false;
            try {
                if (this.failedUpdater != null) {
                    logger.info("{} is waiting for {} to complete.", new Object[]{this, this.failedUpdater});
                    while (this.failedUpdater.isAlive()) {
                        if (this.quitting()) {
                            if (gotInterrupted) return;
                            if (this.failedUpdater == null) return;
                            break block8;
                        }
                        this.failedUpdater.join(5000L);
                    }
                }
                if (gotInterrupted) return;
                if (this.failedUpdater == null) return;
            }
            catch (InterruptedException ignore) {
                try {
                    return;
                }
                catch (Throwable throwable) {
                    if (gotInterrupted) throw throwable;
                    if (this.failedUpdater == null) throw throwable;
                    logger.info("{} has completed waiting for {}", new Object[]{this, this.failedUpdater});
                    this.failedUpdater = null;
                    throw throwable;
                }
            }
            logger.info("{} has completed waiting for {}", new Object[]{this, this.failedUpdater});
            this.failedUpdater = null;
            return;
        }
        logger.info("{} has completed waiting for {}", new Object[]{this, this.failedUpdater});
        this.failedUpdater = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMessages() {
        boolean isDebugEnabled = logger.isDebugEnabled();
        int headerReadTimeout = (int)Math.round((double)(this.serverQueueStatus.getPingInterval() * this.qManager.getPool().getSubscriptionTimeoutMultiplier()) * 1.25);
        try {
            Message clientMessage = this.initializeMessage();
            if (this.quitting()) {
                if (isDebugEnabled) {
                    logger.debug("processMessages quitting early because we have stopped");
                }
                return;
            }
            logger.info("{} : ready to process messages.", (Object)this);
            while (this.continueProcessing.get()) {
                if (this.quitting()) {
                    if (isDebugEnabled) {
                        logger.debug("termination detected");
                    }
                    return;
                }
                if (this.endpoint.isClosed()) {
                    if (isDebugEnabled) {
                        logger.debug("endpoint died");
                    }
                    this.continueProcessing.set(false);
                    break;
                }
                try {
                    boolean isCreateOrUpdate;
                    clientMessage.receiveWithHeaderReadTimeout(headerReadTimeout);
                    this.waitForFailedUpdater();
                    this.cache.waitForRegisterInterestsInProgress();
                    if (this.quitting()) {
                        if (isDebugEnabled) {
                            logger.debug("processMessages quitting before processing message");
                        }
                        break;
                    }
                    if (clientMessage.getMessageType() == 99) {
                        if (!isDebugEnabled) continue;
                        logger.debug("{}: Received ping", (Object)this);
                        continue;
                    }
                    boolean isDeltaSent = false;
                    boolean bl = isCreateOrUpdate = clientMessage.getMessageType() == 27 || clientMessage.getMessageType() == 28;
                    if (isCreateOrUpdate) {
                        isDeltaSent = (Boolean)clientMessage.getPart(2).getObject();
                    }
                    int numberOfParts = clientMessage.getNumberOfParts();
                    Part eid = clientMessage.getPart(numberOfParts - 1);
                    EventID eventId = (EventID)eid.getObject();
                    if (clientMessage.getMessageType() != 51 && clientMessage.getMessageType() != 67 && this.qManager.getState().verifyIfDuplicate(eventId, !this.isDurableClient && !isDeltaSent)) continue;
                    if (logger.isTraceEnabled(LogMarker.BRIDGE_SERVER_VERBOSE)) {
                        logger.trace(LogMarker.BRIDGE_SERVER_VERBOSE, "Processing event with id {}", (Object)eventId.expensiveToString());
                    }
                    this.isOpCompleted = true;
                    switch (clientMessage.getMessageType()) {
                        case 27: 
                        case 28: {
                            this.handleUpdate(clientMessage);
                            break;
                        }
                        case 15: {
                            this.handleInvalidate(clientMessage);
                            break;
                        }
                        case 16: {
                            this.handleDestroy(clientMessage);
                            break;
                        }
                        case 110: {
                            this.handleAuthenticate();
                            break;
                        }
                        case 17: {
                            this.handleDestroyRegion(clientMessage);
                            break;
                        }
                        case 36: {
                            this.handleClearRegion(clientMessage);
                            break;
                        }
                        case 51: {
                            this.handleRegisterInstantiator(clientMessage, eventId);
                            break;
                        }
                        case 67: {
                            this.handleRegisterDataSerializer(clientMessage, eventId);
                            break;
                        }
                        case 54: {
                            this.handleMarker(clientMessage);
                            break;
                        }
                        case 55: {
                            this.handleInvalidateRegion(clientMessage);
                            break;
                        }
                        case 65: {
                            this.handleRegisterInterest(clientMessage);
                            break;
                        }
                        case 66: {
                            this.handleUnregisterInterest(clientMessage);
                            break;
                        }
                        case 103: {
                            this.handleTombstoneOperation(clientMessage);
                            break;
                        }
                        default: {
                            logger.warn("{}: Received an unsupported message (type={})", new Object[]{this, MessageType.getString(clientMessage.getMessageType())});
                        }
                    }
                    if (!this.isOpCompleted || !this.isDurableClient && !isDeltaSent) continue;
                    this.qManager.getState().verifyIfDuplicate(eventId, true);
                }
                catch (InterruptedIOException ignore) {
                    this.continueProcessing.set(false);
                    if (!isDebugEnabled) continue;
                    logger.debug("InterruptedIOException");
                }
                catch (IOException e) {
                    if (!this.quitting()) {
                        ClientServerObserver clientServerObserver = ClientServerObserverHolder.getInstance();
                        clientServerObserver.beforeFailoverByCacheClientUpdater(this.location);
                        this.eManager.serverCrashed(this.endpoint);
                        if (isDebugEnabled) {
                            logger.debug("Caught the following exception and will exit", (Throwable)e);
                        }
                    }
                    this.continueProcessing.set(false);
                    if (!isDebugEnabled) continue;
                    logger.debug("terminated due to IOException");
                }
                catch (Exception e) {
                    if (!this.quitting()) {
                        ClientServerObserver clientServerObserver = ClientServerObserverHolder.getInstance();
                        clientServerObserver.beforeFailoverByCacheClientUpdater(this.location);
                        this.eManager.serverCrashed(this.endpoint);
                        String message = ": Caught the following exception and will exit: ";
                        this.handleException(message, e);
                    }
                    this.continueProcessing.set(false);
                    if (!isDebugEnabled) continue;
                    logger.debug("CCU terminated due to Exception");
                }
                finally {
                    clientMessage.clear();
                }
            }
        }
        finally {
            if (isDebugEnabled) {
                logger.debug("has stopped and cleaning the helper ..");
            }
            this.close();
            this.qManager.checkEndpoint(this, this.endpoint);
        }
    }

    private void handleAuthenticate() {
        if (this.qManager.getPool().getMultiuserAuthentication()) {
            throw new UnsupportedOperationException("Multi-user mode doesn't support re-authentication. This client will be closed.");
        }
        Long userId = AuthenticateUserOp.executeOn(this.location, (ExecutablePool)this.qManager.getPool());
        this.location.setUserId(userId);
    }

    private void handleException(String message, Exception exception) {
        boolean unexpected;
        boolean bl = unexpected = !this.quitting();
        if (unexpected && !(exception instanceof CancelException)) {
            logger.warn(String.format("%s : %s : %s", this, message, exception), (Throwable)exception);
        }
    }

    private Object deserialize(byte[] serializedBytes) {
        Object deserializedObject = serializedBytes;
        try (ByteArrayDataInput dis = new ByteArrayDataInput(serializedBytes);){
            deserializedObject = DataSerializer.readObject((DataInput)dis);
        }
        catch (IOException | ClassNotFoundException | PdxSerializationException exception) {
            // empty catch block
        }
        return deserializedObject;
    }

    protected int getLocalPort() {
        return this.socket.getLocalPort();
    }

    @Override
    public void onDisconnect(InternalDistributedSystem sys) {
        this.stopUpdater();
    }

    private void verifySocketBufferSize(int requestedBufferSize, int actualBufferSize, String type) {
        if (actualBufferSize < requestedBufferSize) {
            logger.info("Socket {} is {} instead of the requested {}.", new Object[]{type + " buffer size", actualBufferSize, requestedBufferSize});
        }
    }

    @Override
    public boolean isProcessing() {
        return this.continueProcessing.get();
    }

    static {
        fullValueRequested = false;
        MAX_CACHE_WAIT = Long.getLong("gemfire.CacheClientUpdater.MAX_WAIT", 120L);
    }

    public static class CCUStats
    implements MessageStats {
        @Immutable
        private static final StatisticsType type;
        private static final int messagesBeingReceivedId;
        private static final int messageBytesBeingReceivedId;
        private static final int receivedBytesId;
        private final Statistics stats;

        CCUStats(DistributedSystem ids, ServerLocation location) {
            this.stats = ids.createStatistics(type, "CacheClientUpdater-" + location);
        }

        public void close() {
            this.stats.close();
        }

        @Override
        public void incReceivedBytes(long v) {
            this.stats.incLong(receivedBytesId, v);
        }

        @Override
        public void incSentBytes(long v) {
        }

        @Override
        public void incMessagesBeingReceived(int bytes) {
            this.stats.incInt(messagesBeingReceivedId, 1);
            if (bytes > 0) {
                this.stats.incLong(messageBytesBeingReceivedId, (long)bytes);
            }
        }

        @Override
        public void decMessagesBeingReceived(int bytes) {
            this.stats.incInt(messagesBeingReceivedId, -1);
            if (bytes > 0) {
                this.stats.incLong(messageBytesBeingReceivedId, (long)(-bytes));
            }
        }

        public long startTime() {
            return DistributionStats.getStatTime();
        }

        static {
            StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
            type = f.createType("CacheClientUpdaterStats", "Statistics about incoming subscription data", new StatisticDescriptor[]{f.createLongCounter("receivedBytes", "Total number of bytes received from the server.", "bytes"), f.createIntGauge("messagesBeingReceived", "Current number of message being received off the network or being processed after reception.", "messages"), f.createLongGauge("messageBytesBeingReceived", "Current number of bytes consumed by messages being received or processed.", "bytes")});
            receivedBytesId = type.nameToId("receivedBytes");
            messagesBeingReceivedId = type.nameToId("messagesBeingReceived");
            messageBytesBeingReceivedId = type.nameToId("messageBytesBeingReceived");
        }
    }

    public static class StatisticsProvider {
        public CCUStats createStatistics(DistributedSystem system, ServerLocation location) {
            return new CCUStats(system, location);
        }
    }
}

