/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.internal.admin.GemFireVM;
import org.apache.geode.internal.admin.RegionSnapshot;

public class CompoundRegionSnapshot
implements RegionSnapshot {
    private static final long serialVersionUID = 6295026394298398004L;
    private final String name;
    private long lastModifiedTime = 0L;
    private long lastAccessTime = 0L;
    private long numHits = 0L;
    private long numMisses = 0L;
    private float hitRatio = 0.0f;
    private long hitResponders = 0L;
    private double hitRatioSum = 0.0;
    private final Set allCapControllers = new HashSet();
    private final Set allListeners = new HashSet();
    private final Set allDataPolicies = new HashSet();
    private final Set allRegionTtl = new HashSet();
    private final Set allEntryTtl = new HashSet();
    private final HashSet allCustomTtl = new HashSet();
    private final Set allRegionIdleTimeout = new HashSet();
    private final Set allEntryIdleTimeout = new HashSet();
    private final HashSet allCustomIdle = new HashSet();
    private final Set allScopes = new HashSet();
    private final Set allUserAttributes = new HashSet();
    private final Set allCacheLoaders = new HashSet();
    private final Set allCacheWriters = new HashSet();
    private final Set allLoadFactors = new HashSet();
    private final Set allInitialCaps = new HashSet();
    private final Set allConcLevels = new HashSet();
    private final Set allStatsEnabled = new HashSet();
    private final Set allKeyConstraints = new HashSet();
    private final Set allValueConstraints = new HashSet();

    public CompoundRegionSnapshot(String regionName) {
        this.name = regionName;
    }

    public void addCache(GemFireVM systemEntity, RegionSnapshot snap) {
        float hitRatio;
        long missCount;
        long hitCount;
        long access;
        long modified;
        if (!snap.getName().equals(this.name)) {
            throw new IllegalArgumentException("All snapshots in a compound snapshot must have the same name");
        }
        RegionAttributes ra = snap.getAttributes();
        if (ra != null) {
            CacheLoader loader;
            CacheWriter writer;
            CacheListener listener = ra.getCacheListener();
            if (listener != null) {
                this.allListeners.add(listener.toString());
            }
            if ((writer = ra.getCacheWriter()) != null) {
                this.allCacheWriters.add(writer.toString());
            }
            if ((loader = ra.getCacheLoader()) != null) {
                this.allCacheLoaders.add(loader);
            }
            this.allDataPolicies.add(ra.getDataPolicy());
            this.allRegionTtl.add(ra.getRegionTimeToLive());
            this.allEntryTtl.add(ra.getEntryTimeToLive());
            this.allCustomTtl.add(ra.getCustomEntryTimeToLive().toString());
            this.allRegionIdleTimeout.add(ra.getRegionIdleTimeout());
            this.allEntryIdleTimeout.add(ra.getEntryIdleTimeout());
            this.allCustomIdle.add(ra.getCustomEntryIdleTimeout().toString());
            this.allScopes.add(ra.getScope());
            this.allLoadFactors.add(Float.valueOf(ra.getLoadFactor()));
            this.allInitialCaps.add(ra.getInitialCapacity());
            this.allConcLevels.add(ra.getConcurrencyLevel());
            this.allStatsEnabled.add(ra.getStatisticsEnabled());
            this.allUserAttributes.add(snap.getUserAttribute());
            this.allKeyConstraints.add(ra.getKeyConstraint());
            this.allValueConstraints.add(ra.getValueConstraint());
        }
        if ((modified = snap.getLastModifiedTime()) > 0L && modified > this.lastModifiedTime) {
            this.lastModifiedTime = modified;
        }
        if ((access = snap.getLastAccessTime()) > 0L && access > this.lastAccessTime) {
            this.lastAccessTime = access;
        }
        if ((hitCount = snap.getNumberOfHits()) > 0L) {
            this.numHits += hitCount;
        }
        if ((missCount = snap.getNumberOfMisses()) > 0L) {
            this.numMisses += missCount;
        }
        if ((double)(hitRatio = snap.getHitRatio()) >= 0.0) {
            ++this.hitResponders;
            this.hitRatioSum += (double)hitRatio;
            this.hitRatio = (float)(this.hitRatioSum / (double)this.hitResponders);
        }
    }

    @Override
    public Object getName() {
        return this.name;
    }

    @Override
    public RegionAttributes getAttributes() {
        return null;
    }

    @Override
    public Object getUserAttribute() {
        return null;
    }

    public boolean isShared() {
        return false;
    }

    public Iterator getAllCapacityControllers() {
        return this.allCapControllers.iterator();
    }

    public Iterator getAllListeners() {
        return this.allListeners.iterator();
    }

    public Iterator getAllCacheWriters() {
        return this.allCacheWriters.iterator();
    }

    public Iterator getAllCacheLoaders() {
        return this.allCacheLoaders.iterator();
    }

    public Iterator getAllDataPolicies() {
        return this.allDataPolicies.iterator();
    }

    public Iterator getAllRegionTtl() {
        return this.allRegionTtl.iterator();
    }

    public Iterator getAllEntryTtl() {
        return this.allEntryTtl.iterator();
    }

    public Iterator getAllCustomTtl() {
        return this.allCustomTtl.iterator();
    }

    public Iterator getAllRegionIdleTimeout() {
        return this.allRegionIdleTimeout.iterator();
    }

    public Iterator getAllEntryIdleTimeout() {
        return this.allEntryIdleTimeout.iterator();
    }

    public Iterator getAllCustomIdleTimeout() {
        return this.allCustomIdle.iterator();
    }

    public Iterator getAllScopes() {
        return this.allScopes.iterator();
    }

    public Iterator getAllLoadFactors() {
        return this.allLoadFactors.iterator();
    }

    public Iterator getAllInitialCapacities() {
        return this.allInitialCaps.iterator();
    }

    public Iterator getAllConcurrencyLevels() {
        return this.allConcLevels.iterator();
    }

    public Iterator getAllStatsEnabled() {
        return this.allStatsEnabled.iterator();
    }

    public Iterator getAllUserAttributes() {
        return this.allUserAttributes.iterator();
    }

    public Iterator getAllKeyConstraint() {
        return this.allKeyConstraints.iterator();
    }

    public Iterator getAllValueConstraint() {
        return this.allValueConstraints.iterator();
    }

    @Override
    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public long getNumberOfHits() {
        return this.numHits;
    }

    @Override
    public long getNumberOfMisses() {
        return this.numMisses;
    }

    @Override
    public float getHitRatio() {
        return this.hitRatio;
    }
}

