/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.locks;

import java.util.function.LongSupplier;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.PoolStatHelper;
import org.apache.geode.distributed.internal.QueueStatHelper;
import org.apache.geode.distributed.internal.locks.DistributedLockStats;
import org.apache.geode.internal.statistics.StatisticsTypeFactoryImpl;

public class DLockStats
implements DistributedLockStats {
    @Immutable
    private static final StatisticsType type;
    private static final int grantorsId;
    private static final int servicesId;
    private static final int tokensId;
    private static final int grantTokensId;
    private static final int requestQueuesId;
    private static final int serialQueueSizeId;
    private static final int serialThreadsId;
    private static final int waitingQueueSizeId;
    private static final int waitingThreadsId;
    private static final int lockWaitsInProgressId;
    private static final int lockWaitsCompletedId;
    private static final int lockWaitTimeId;
    private static final int lockWaitsFailedId;
    private static final int lockWaitFailedTimeId;
    private static final int grantWaitsInProgressId;
    private static final int grantWaitsCompletedId;
    private static final int grantWaitTimeId;
    private static final int grantWaitsNotGrantorId;
    private static final int grantWaitNotGrantorTimeId;
    private static final int grantWaitsTimeoutId;
    private static final int grantWaitTimeoutTimeId;
    private static final int grantWaitsNotHolderId;
    private static final int grantWaitNotHolderTimeId;
    private static final int grantWaitsFailedId;
    private static final int grantWaitFailedTimeId;
    private static final int grantWaitsSuspendedId;
    private static final int grantWaitSuspendedTimeId;
    private static final int grantWaitsDestroyedId;
    private static final int grantWaitDestroyedTimeId;
    private static final int createGrantorsInProgressId;
    private static final int createGrantorsCompletedId;
    private static final int createGrantorTimeId;
    private static final int serviceCreatesInProgressId;
    private static final int serviceCreatesCompletedId;
    private static final int serviceCreateLatchTimeId;
    private static final int serviceInitLatchTimeId;
    private static final int grantorWaitsInProgressId;
    private static final int grantorWaitsCompletedId;
    private static final int grantorWaitTimeId;
    private static final int grantorWaitsFailedId;
    private static final int grantorWaitFailedTimeId;
    private static final int grantorThreadsInProgressId;
    private static final int grantorThreadsCompletedId;
    private static final int grantorThreadExpireAndGrantLocksTimeId;
    private static final int grantorThreadHandleRequestTimeoutsTimeId;
    private static final int grantorThreadRemoveUnusedTokensTimeId;
    private static final int grantorThreadTimeId;
    private static final int pendingRequestsId;
    private static final int destroyReadWaitsInProgressId;
    private static final int destroyReadWaitsCompletedId;
    private static final int destroyReadWaitTimeId;
    private static final int destroyReadWaitsFailedId;
    private static final int destroyReadWaitFailedTimeId;
    private static final int destroyWriteWaitsInProgressId;
    private static final int destroyWriteWaitsCompletedId;
    private static final int destroyWriteWaitTimeId;
    private static final int destroyWriteWaitsFailedId;
    private static final int destroyWriteWaitFailedTimeId;
    private static final int destroyReadsId;
    private static final int destroyWritesId;
    private static final int lockReleasesInProgressId;
    private static final int lockReleasesCompletedId;
    private static final int lockReleaseTimeId;
    private static final int becomeGrantorRequestsId;
    private static final int freeResourcesCompletedId;
    private static final int freeResourcesFailedId;
    private final Statistics stats;
    private final LongSupplier clock;

    public DLockStats(StatisticsFactory f, long statId) {
        this(f, "dlockStats", statId, DistributionStats::getStatTime);
    }

    @VisibleForTesting
    public DLockStats(StatisticsFactory factory, String textId, long statId, LongSupplier clock) {
        this.stats = factory == null ? null : factory.createAtomicStatistics(type, textId, statId);
        this.clock = clock;
    }

    private long getTime() {
        return this.clock.getAsLong();
    }

    public void close() {
        this.stats.close();
    }

    @Override
    public long getLockWaitsInProgress() {
        return this.stats.getLong(lockWaitsInProgressId);
    }

    @Override
    public long getLockWaitsCompleted() {
        return this.stats.getLong(lockWaitsCompletedId);
    }

    @Override
    public long getLockWaitsFailed() {
        return this.stats.getLong(lockWaitsFailedId);
    }

    @Override
    public long getLockWaitTime() {
        return this.stats.getLong(lockWaitTimeId);
    }

    @Override
    public long getLockWaitFailedTime() {
        return this.stats.getLong(lockWaitFailedTimeId);
    }

    @Override
    public long startLockWait() {
        this.stats.incLong(lockWaitsInProgressId, 1L);
        return this.getTime();
    }

    @Override
    public void endLockWait(long start, boolean success) {
        long ts = this.getTime();
        this.stats.incLong(lockWaitsInProgressId, -1L);
        if (success) {
            this.stats.incLong(lockWaitsCompletedId, 1L);
            if (DistributionStats.enableClockStats) {
                this.stats.incLong(lockWaitTimeId, ts - start);
            }
        } else {
            this.stats.incLong(lockWaitsFailedId, 1L);
            if (DistributionStats.enableClockStats) {
                this.stats.incLong(lockWaitFailedTimeId, ts - start);
            }
        }
    }

    @Override
    public long getWaitingQueueSize() {
        return this.stats.getLong(waitingQueueSizeId);
    }

    @Override
    public void incWaitingQueueSize(long messages) {
        this.stats.incLong(waitingQueueSizeId, messages);
    }

    @Override
    public long getSerialQueueSize() {
        return this.stats.getLong(serialQueueSizeId);
    }

    @Override
    public void incSerialQueueSize(long messages) {
        this.stats.incLong(serialQueueSizeId, messages);
    }

    @Override
    public long getNumSerialThreads() {
        return this.stats.getLong(serialThreadsId);
    }

    @Override
    public void incNumSerialThreads(long threads) {
        this.stats.incLong(serialThreadsId, threads);
    }

    @Override
    public long getWaitingThreads() {
        return this.stats.getLong(waitingThreadsId);
    }

    @Override
    public void incWaitingThreads(long threads) {
        this.stats.incLong(waitingThreadsId, threads);
    }

    @Override
    public long getServices() {
        return this.stats.getLong(servicesId);
    }

    @Override
    public void incServices(long val) {
        this.stats.incLong(servicesId, val);
    }

    @Override
    public long getGrantors() {
        return this.stats.getLong(grantorsId);
    }

    @Override
    public void incGrantors(long val) {
        this.stats.incLong(grantorsId, val);
    }

    @Override
    public long getTokens() {
        return this.stats.getLong(tokensId);
    }

    @Override
    public void incTokens(long val) {
        this.stats.incLong(tokensId, val);
    }

    @Override
    public long getGrantTokens() {
        return this.stats.getLong(grantTokensId);
    }

    @Override
    public void incGrantTokens(long val) {
        this.stats.incLong(grantTokensId, val);
    }

    @Override
    public long getRequestQueues() {
        return this.stats.getLong(requestQueuesId);
    }

    @Override
    public void incRequestQueues(long val) {
        this.stats.incLong(requestQueuesId, val);
    }

    @Override
    public long getGrantWaitsInProgress() {
        return this.stats.getLong(grantWaitsInProgressId);
    }

    @Override
    public long getGrantWaitsCompleted() {
        return this.stats.getLong(grantWaitsCompletedId);
    }

    @Override
    public long getGrantWaitsFailed() {
        return this.stats.getLong(grantWaitsFailedId);
    }

    public long getGrantWaitsSuspended() {
        return this.stats.getLong(grantWaitsSuspendedId);
    }

    public long getGrantWaitsDestroyed() {
        return this.stats.getLong(grantWaitsDestroyedId);
    }

    @Override
    public long getGrantWaitTime() {
        return this.stats.getLong(grantWaitTimeId);
    }

    @Override
    public long getGrantWaitFailedTime() {
        return this.stats.getLong(grantWaitFailedTimeId);
    }

    @Override
    public long startGrantWait() {
        this.stats.incLong(grantWaitsInProgressId, 1L);
        return this.getTime();
    }

    @Override
    public void endGrantWait(long start) {
        long ts = this.getTime();
        this.stats.incLong(grantWaitsInProgressId, -1L);
        this.stats.incLong(grantWaitsCompletedId, 1L);
        if (DistributionStats.enableClockStats) {
            this.stats.incLong(grantWaitTimeId, ts - start);
        }
    }

    @Override
    public void endGrantWaitNotGrantor(long start) {
        long ts = this.getTime();
        this.stats.incLong(grantWaitsInProgressId, -1L);
        this.stats.incLong(grantWaitsNotGrantorId, 1L);
        if (DistributionStats.enableClockStats) {
            this.stats.incLong(grantWaitNotGrantorTimeId, ts - start);
        }
    }

    @Override
    public void endGrantWaitTimeout(long start) {
        long ts = this.getTime();
        this.stats.incLong(grantWaitsInProgressId, -1L);
        this.stats.incLong(grantWaitsTimeoutId, 1L);
        if (DistributionStats.enableClockStats) {
            this.stats.incLong(grantWaitTimeoutTimeId, ts - start);
        }
    }

    @Override
    public void endGrantWaitNotHolder(long start) {
        long ts = this.getTime();
        this.stats.incLong(grantWaitsInProgressId, -1L);
        this.stats.incLong(grantWaitsNotHolderId, 1L);
        if (DistributionStats.enableClockStats) {
            this.stats.incLong(grantWaitNotHolderTimeId, ts - start);
        }
    }

    @Override
    public void endGrantWaitFailed(long start) {
        long ts = this.getTime();
        this.stats.incLong(grantWaitsInProgressId, -1L);
        this.stats.incLong(grantWaitsFailedId, 1L);
        if (DistributionStats.enableClockStats) {
            this.stats.incLong(grantWaitFailedTimeId, ts - start);
        }
    }

    @Override
    public void endGrantWaitSuspended(long start) {
        long ts = this.getTime();
        this.stats.incLong(grantWaitsInProgressId, -1L);
        this.stats.incLong(grantWaitsSuspendedId, 1L);
        if (DistributionStats.enableClockStats) {
            this.stats.incLong(grantWaitSuspendedTimeId, ts - start);
        }
    }

    @Override
    public void endGrantWaitDestroyed(long start) {
        long ts = this.getTime();
        this.stats.incLong(grantWaitsInProgressId, -1L);
        this.stats.incLong(grantWaitsDestroyedId, 1L);
        if (DistributionStats.enableClockStats) {
            this.stats.incLong(grantWaitDestroyedTimeId, ts - start);
        }
    }

    @Override
    public long getCreateGrantorsInProgress() {
        return this.stats.getLong(createGrantorsInProgressId);
    }

    @Override
    public long getCreateGrantorsCompleted() {
        return this.stats.getLong(createGrantorsCompletedId);
    }

    @Override
    public long getCreateGrantorTime() {
        return this.stats.getLong(createGrantorTimeId);
    }

    @Override
    public long startCreateGrantor() {
        this.stats.incLong(createGrantorsInProgressId, 1L);
        return this.getTime();
    }

    @Override
    public void endCreateGrantor(long start) {
        long ts = this.getTime();
        this.stats.incLong(createGrantorsInProgressId, -1L);
        this.stats.incLong(createGrantorsCompletedId, 1L);
        if (DistributionStats.enableClockStats) {
            this.stats.incLong(createGrantorTimeId, ts - start);
        }
    }

    @Override
    public long getServiceCreatesInProgress() {
        return this.stats.getLong(serviceCreatesInProgressId);
    }

    @Override
    public long getServiceCreatesCompleted() {
        return this.stats.getLong(serviceCreatesCompletedId);
    }

    @Override
    public long startServiceCreate() {
        this.stats.incLong(serviceCreatesInProgressId, 1L);
        return this.getTime();
    }

    @Override
    public void serviceCreateLatchReleased(long start) {
        if (DistributionStats.enableClockStats) {
            long ts = this.getTime();
            this.stats.incLong(serviceCreateLatchTimeId, ts - start);
        }
    }

    @Override
    public void serviceInitLatchReleased(long start) {
        long ts = this.getTime();
        this.stats.incLong(serviceCreatesInProgressId, -1L);
        this.stats.incLong(serviceCreatesCompletedId, 1L);
        if (DistributionStats.enableClockStats) {
            this.stats.incLong(serviceInitLatchTimeId, ts - start);
        }
    }

    @Override
    public long getServiceCreateLatchTime() {
        return this.stats.getLong(serviceCreateLatchTimeId);
    }

    @Override
    public long getServiceInitLatchTime() {
        return this.stats.getLong(serviceInitLatchTimeId);
    }

    @Override
    public long getGrantorWaitsInProgress() {
        return this.stats.getLong(grantorWaitsInProgressId);
    }

    @Override
    public long getGrantorWaitsCompleted() {
        return this.stats.getLong(grantorWaitsCompletedId);
    }

    @Override
    public long getGrantorWaitsFailed() {
        return this.stats.getLong(grantorWaitsFailedId);
    }

    @Override
    public long getGrantorWaitTime() {
        return this.stats.getLong(grantorWaitTimeId);
    }

    @Override
    public long getGrantorWaitFailedTime() {
        return this.stats.getLong(grantorWaitFailedTimeId);
    }

    @Override
    public long startGrantorWait() {
        this.stats.incLong(grantorWaitsInProgressId, 1L);
        return this.getTime();
    }

    @Override
    public void endGrantorWait(long start, boolean success) {
        long ts = this.getTime();
        this.stats.incLong(grantorWaitsInProgressId, -1L);
        if (success) {
            this.stats.incLong(grantorWaitsCompletedId, 1L);
            if (DistributionStats.enableClockStats) {
                this.stats.incLong(grantorWaitTimeId, ts - start);
            }
        } else {
            this.stats.incLong(grantorWaitsFailedId, 1L);
            if (DistributionStats.enableClockStats) {
                this.stats.incLong(grantorWaitFailedTimeId, ts - start);
            }
        }
    }

    @Override
    public long getGrantorThreadsInProgress() {
        return this.stats.getLong(grantorThreadsInProgressId);
    }

    @Override
    public long getGrantorThreadsCompleted() {
        return this.stats.getLong(grantorThreadsCompletedId);
    }

    @Override
    public long getGrantorThreadTime() {
        return this.stats.getLong(grantorThreadTimeId);
    }

    @Override
    public long getGrantorThreadExpireAndGrantLocksTime() {
        return this.stats.getLong(grantorThreadExpireAndGrantLocksTimeId);
    }

    @Override
    public long getGrantorThreadHandleRequestTimeoutsTime() {
        return this.stats.getLong(grantorThreadHandleRequestTimeoutsTimeId);
    }

    @Override
    public long getGrantorThreadRemoveUnusedTokensTime() {
        return this.stats.getLong(grantorThreadRemoveUnusedTokensTimeId);
    }

    @Override
    public long startGrantorThread() {
        this.stats.incLong(grantorThreadsInProgressId, 1L);
        return this.getTime();
    }

    @Override
    public long endGrantorThreadExpireAndGrantLocks(long start) {
        long ts = this.getTime();
        this.stats.incLong(grantorThreadExpireAndGrantLocksTimeId, ts - start);
        return this.getTime();
    }

    @Override
    public long endGrantorThreadHandleRequestTimeouts(long timing) {
        long ts = this.getTime();
        this.stats.incLong(grantorThreadHandleRequestTimeoutsTimeId, ts - timing);
        return this.getTime();
    }

    @Override
    public void endGrantorThreadRemoveUnusedTokens(long timing) {
        long ts = this.getTime();
        this.stats.incLong(grantorThreadRemoveUnusedTokensTimeId, ts - timing);
    }

    @Override
    public void endGrantorThread(long start) {
        long ts = this.getTime();
        this.stats.incLong(grantorThreadsInProgressId, -1L);
        this.stats.incLong(grantorThreadsCompletedId, 1L);
        if (DistributionStats.enableClockStats) {
            this.stats.incLong(grantorThreadTimeId, ts - start);
        }
    }

    @Override
    public long getPendingRequests() {
        return this.stats.getLong(pendingRequestsId);
    }

    @Override
    public void incPendingRequests(long val) {
        this.stats.incLong(pendingRequestsId, val);
    }

    @Override
    public long getDestroyReadWaitsInProgress() {
        return this.stats.getLong(destroyReadWaitsInProgressId);
    }

    @Override
    public long getDestroyReadWaitsCompleted() {
        return this.stats.getLong(destroyReadWaitsCompletedId);
    }

    @Override
    public long getDestroyReadWaitsFailed() {
        return this.stats.getLong(destroyReadWaitsFailedId);
    }

    @Override
    public long getDestroyReadWaitTime() {
        return this.stats.getLong(destroyReadWaitTimeId);
    }

    @Override
    public long getDestroyReadWaitFailedTime() {
        return this.stats.getLong(destroyReadWaitFailedTimeId);
    }

    @Override
    public long startDestroyReadWait() {
        this.stats.incLong(destroyReadWaitsInProgressId, 1L);
        return this.getTime();
    }

    @Override
    public void endDestroyReadWait(long start, boolean success) {
        long ts = this.getTime();
        this.stats.incLong(destroyReadWaitsInProgressId, -1L);
        if (success) {
            this.stats.incLong(destroyReadWaitsCompletedId, 1L);
            if (DistributionStats.enableClockStats) {
                this.stats.incLong(destroyReadWaitTimeId, ts - start);
            }
        } else {
            this.stats.incLong(destroyReadWaitsFailedId, 1L);
            if (DistributionStats.enableClockStats) {
                this.stats.incLong(destroyReadWaitFailedTimeId, ts - start);
            }
        }
    }

    @Override
    public long getDestroyWriteWaitsInProgress() {
        return this.stats.getLong(destroyWriteWaitsInProgressId);
    }

    @Override
    public long getDestroyWriteWaitsCompleted() {
        return this.stats.getLong(destroyWriteWaitsCompletedId);
    }

    @Override
    public long getDestroyWriteWaitsFailed() {
        return this.stats.getLong(destroyWriteWaitsFailedId);
    }

    @Override
    public long getDestroyWriteWaitTime() {
        return this.stats.getLong(destroyWriteWaitTimeId);
    }

    @Override
    public long getDestroyWriteWaitFailedTime() {
        return this.stats.getLong(destroyWriteWaitFailedTimeId);
    }

    @Override
    public long startDestroyWriteWait() {
        this.stats.incLong(destroyWriteWaitsInProgressId, 1L);
        return this.getTime();
    }

    @Override
    public void endDestroyWriteWait(long start, boolean success) {
        long ts = this.getTime();
        this.stats.incLong(destroyWriteWaitsInProgressId, -1L);
        if (success) {
            this.stats.incLong(destroyWriteWaitsCompletedId, 1L);
            if (DistributionStats.enableClockStats) {
                this.stats.incLong(destroyWriteWaitTimeId, ts - start);
            }
        } else {
            this.stats.incLong(destroyWriteWaitsFailedId, 1L);
            if (DistributionStats.enableClockStats) {
                this.stats.incLong(destroyWriteWaitFailedTimeId, ts - start);
            }
        }
    }

    @Override
    public long getDestroyReads() {
        return this.stats.getLong(destroyReadsId);
    }

    @Override
    public void incDestroyReads(long val) {
        this.stats.incLong(destroyReadsId, val);
    }

    @Override
    public long getDestroyWrites() {
        return this.stats.getLong(destroyWritesId);
    }

    @Override
    public void incDestroyWrites(long val) {
        this.stats.incLong(destroyWritesId, val);
    }

    @Override
    public long getLockReleasesInProgress() {
        return this.stats.getLong(lockReleasesInProgressId);
    }

    @Override
    public long getLockReleasesCompleted() {
        return this.stats.getLong(lockReleasesCompletedId);
    }

    @Override
    public long getLockReleaseTime() {
        return this.stats.getLong(lockReleaseTimeId);
    }

    @Override
    public long startLockRelease() {
        this.stats.incLong(lockReleasesInProgressId, 1L);
        return this.getTime();
    }

    @Override
    public void endLockRelease(long start) {
        long ts = this.getTime();
        this.stats.incLong(lockReleasesInProgressId, -1L);
        this.stats.incLong(lockReleasesCompletedId, 1L);
        if (DistributionStats.enableClockStats) {
            this.stats.incLong(lockReleaseTimeId, ts - start);
        }
    }

    @Override
    public long getBecomeGrantorRequests() {
        return this.stats.getLong(becomeGrantorRequestsId);
    }

    @Override
    public void incBecomeGrantorRequests() {
        this.stats.incLong(becomeGrantorRequestsId, 1L);
    }

    @Override
    public long getFreeResourcesCompleted() {
        return this.stats.getLong(freeResourcesCompletedId);
    }

    @Override
    public void incFreeResourcesCompleted() {
        this.stats.incLong(freeResourcesCompletedId, 1L);
    }

    @Override
    public long getFreeResourcesFailed() {
        return this.stats.getLong(freeResourcesFailedId);
    }

    @Override
    public void incFreeResourcesFailed() {
        this.stats.incLong(freeResourcesFailedId, 1L);
    }

    @Override
    public QueueStatHelper getSerialQueueHelper() {
        return new QueueStatHelper(){

            @Override
            public void add() {
                DLockStats.this.incSerialQueueSize(1L);
            }

            @Override
            public void remove() {
                DLockStats.this.incSerialQueueSize(-1L);
            }

            @Override
            public void remove(long count) {
                DLockStats.this.incSerialQueueSize(-count);
            }
        };
    }

    @Override
    public PoolStatHelper getWaitingPoolHelper() {
        return new PoolStatHelper(){

            @Override
            public void startJob() {
                DLockStats.this.incWaitingThreads(1L);
            }

            @Override
            public void endJob() {
                DLockStats.this.incWaitingThreads(-1L);
            }
        };
    }

    @Override
    public QueueStatHelper getWaitingQueueHelper() {
        return new QueueStatHelper(){

            @Override
            public void add() {
                DLockStats.this.incWaitingQueueSize(1L);
            }

            @Override
            public void remove() {
                DLockStats.this.incWaitingQueueSize(-1L);
            }

            @Override
            public void remove(long count) {
                DLockStats.this.incWaitingQueueSize(-count);
            }
        };
    }

    public Statistics getStats() {
        return this.stats;
    }

    static {
        String statName = "DLockStats";
        String statDescription = "Statistics on the gemfire distribution lock service.";
        String grantorsDesc = "The current number of lock grantors hosted by this system member.";
        String servicesDesc = "The current number of lock services used by this system member.";
        String tokensDesc = "The current number of lock tokens used by this system member.";
        String grantTokensDesc = "The current number of grant tokens used by local grantors.";
        String requestQueuesDesc = "The current number of lock request queues used by this system member.";
        String serialQueueSizeDesc = "The number of serial distribution messages currently waiting to be processed.";
        String serialThreadsDesc = "The number of threads currently processing serial/ordered messages.";
        String waitingQueueSizeDesc = "The number of distribution messages currently waiting for some other resource before they can be processed.";
        String waitingThreadsDesc = "The number of threads currently processing messages that had to wait for a resource.";
        String lockWaitsInProgressDesc = "Current number of threads waiting for a distributed lock.";
        String lockWaitsCompletedDesc = "Total number of times distributed lock wait has completed by successfully obtained the lock.";
        String lockWaitTimeDesc = "Total time spent waiting for a distributed lock that was obtained.";
        String lockWaitsFailedDesc = "Total number of times distributed lock wait has completed by failing to obtain the lock.";
        String lockWaitFailedTimeDesc = "Total time spent waiting for a distributed lock that we failed to obtain.";
        String grantWaitsInProgressDesc = "Current number of distributed lock requests being granted.";
        String grantWaitsCompletedDesc = "Total number of times granting of a lock request has completed by successfully granting the lock.";
        String grantWaitTimeDesc = "Total time spent attempting to grant a distributed lock.";
        String grantWaitsNotGrantorDesc = "Total number of times granting of lock request failed because not grantor.";
        String grantWaitNotGrantorTimeDesc = "Total time spent granting of lock requests that failed because not grantor.";
        String grantWaitsTimeoutDesc = "Total number of times granting of lock request failed because timeout.";
        String grantWaitTimeoutTimeDesc = "Total time spent granting of lock requests that failed because timeout.";
        String grantWaitsNotHolderDesc = "Total number of times granting of lock request failed because reentrant was not holder.";
        String grantWaitNotHolderTimeDesc = "Total time spent granting of lock requests that failed because reentrant was not holder.";
        String grantWaitsFailedDesc = "Total number of times granting of lock request failed because try locks failed.";
        String grantWaitFailedTimeDesc = "Total time spent granting of lock requests that failed because try locks failed.";
        String grantWaitsSuspendedDesc = "Total number of times granting of lock request failed because lock service was suspended.";
        String grantWaitSuspendedTimeDesc = "Total time spent granting of lock requests that failed because lock service was suspended.";
        String grantWaitsDestroyedDesc = "Total number of times granting of lock request failed because lock service was destroyed.";
        String grantWaitDestroyedTimeDesc = "Total time spent granting of lock requests that failed because lock service was destroyed.";
        String createGrantorsInProgressDesc = "Current number of initial grantors being created in this process.";
        String createGrantorsCompletedDesc = "Total number of initial grantors created in this process.";
        String createGrantorTimeDesc = "Total time spent waiting create the intial grantor for lock services.";
        String serviceCreatesInProgressDesc = "Current number of lock services being created in this process.";
        String serviceCreatesCompletedDesc = "Total number of lock services created in this process.";
        String serviceCreateLatchTimeDesc = "Total time spent creating lock services before releasing create latches.";
        String serviceInitLatchTimeDesc = "Total time spent creating lock services before releasing init latches.";
        String grantorWaitsInProgressDesc = "Current number of threads waiting for grantor latch to open.";
        String grantorWaitsCompletedDesc = "Total number of times waiting threads completed waiting for the grantor latch to open.";
        String grantorWaitTimeDesc = "Total time spent waiting for the grantor latch which resulted in success.";
        String grantorWaitsFailedDesc = "Total number of times waiting threads failed to finish waiting for the grantor latch to open.";
        String grantorWaitFailedTimeDesc = "Total time spent waiting for the grantor latch which resulted in failure.";
        String grantorThreadsInProgressDesc = "Current iterations of work performed by grantor thread(s).";
        String grantorThreadsCompletedDesc = "Total number of iterations of work performed by grantor thread(s).";
        String grantorThreadExpireAndGrantLocksTimeDesc = "Total time spent by grantor thread(s) performing expireAndGrantLocks tasks.";
        String grantorThreadHandleRequestTimeoutsTimeDesc = "Total time spent by grantor thread(s) performing handleRequestTimeouts tasks.";
        String grantorThreadRemoveUnusedTokensTimeDesc = "Total time spent by grantor thread(s) performing removeUnusedTokens tasks.";
        String grantorThreadTimeDesc = "Total time spent by grantor thread(s) performing all grantor tasks.";
        String pendingRequestsDesc = "The current number of pending lock requests queued by grantors in this process.";
        String destroyReadWaitsInProgressDesc = "Current number of threads waiting for a DLockService destroy read lock.";
        String destroyReadWaitsCompletedDesc = "Total number of times a DLockService destroy read lock wait has completed successfully.";
        String destroyReadWaitTimeDesc = "Total time spent waiting for a DLockService destroy read lock that was obtained.";
        String destroyReadWaitsFailedDesc = "Total number of times a DLockService destroy read lock wait has completed unsuccessfully.";
        String destroyReadWaitFailedTimeDesc = "Total time spent waiting for a DLockService destroy read lock that was not obtained.";
        String destroyWriteWaitsInProgressDesc = "Current number of thwrites waiting for a DLockService destroy write lock.";
        String destroyWriteWaitsCompletedDesc = "Total number of times a DLockService destroy write lock wait has completed successfully.";
        String destroyWriteWaitTimeDesc = "Total time spent waiting for a DLockService destroy write lock that was obtained.";
        String destroyWriteWaitsFailedDesc = "Total number of times a DLockService destroy write lock wait has completed unsuccessfully.";
        String destroyWriteWaitFailedTimeDesc = "Total time spent waiting for a DLockService destroy write lock that was not obtained.";
        String destroyReadsDesc = "The current number of DLockService destroy read locks held by this process.";
        String destroyWritesDesc = "The current number of DLockService destroy write locks held by this process.";
        String lockReleasesInProgressDesc = "Current number of threads releasing a distributed lock.";
        String lockReleasesCompletedDesc = "Total number of times distributed lock release has completed.";
        String lockReleaseTimeDesc = "Total time spent releasing a distributed lock.";
        String becomeGrantorRequestsDesc = "Total number of times this member has explicitly requested to become lock grantor.";
        String freeResourcesCompletedDesc = "Total number of times this member has freed resources for a distributed lock.";
        String freeResourcesFailedDesc = "Total number of times this member has attempted to free resources for a distributed lock which remained in use.";
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        type = f.createType(statName, statDescription, new StatisticDescriptor[]{f.createIntGauge("grantors", "The current number of lock grantors hosted by this system member.", "grantors"), f.createIntGauge("services", "The current number of lock services used by this system member.", "services"), f.createIntGauge("tokens", "The current number of lock tokens used by this system member.", "tokens"), f.createIntGauge("grantTokens", "The current number of grant tokens used by local grantors.", "grantTokens"), f.createIntGauge("requestQueues", "The current number of lock request queues used by this system member.", "requestQueues"), f.createIntGauge("serialQueueSize", "The number of serial distribution messages currently waiting to be processed.", "messages"), f.createIntGauge("serialThreads", "The number of threads currently processing serial/ordered messages.", "threads"), f.createIntGauge("waitingQueueSize", "The number of distribution messages currently waiting for some other resource before they can be processed.", "messages"), f.createIntGauge("waitingThreads", "The number of threads currently processing messages that had to wait for a resource.", "threads"), f.createIntGauge("lockWaitsInProgress", "Current number of threads waiting for a distributed lock.", "operations"), f.createIntCounter("lockWaitsCompleted", "Total number of times distributed lock wait has completed by successfully obtained the lock.", "operations"), f.createLongCounter("lockWaitTime", "Total time spent waiting for a distributed lock that was obtained.", "nanoseconds", false), f.createIntCounter("lockWaitsFailed", "Total number of times distributed lock wait has completed by failing to obtain the lock.", "operations"), f.createLongCounter("lockWaitFailedTime", "Total time spent waiting for a distributed lock that we failed to obtain.", "nanoseconds", false), f.createIntGauge("grantWaitsInProgress", "Current number of distributed lock requests being granted.", "operations"), f.createIntCounter("grantWaitsCompleted", "Total number of times granting of a lock request has completed by successfully granting the lock.", "operations"), f.createLongCounter("grantWaitTime", "Total time spent attempting to grant a distributed lock.", "nanoseconds", false), f.createIntCounter("grantWaitsNotGrantor", "Total number of times granting of lock request failed because not grantor.", "operations"), f.createLongCounter("grantWaitNotGrantorTime", "Total time spent granting of lock requests that failed because not grantor.", "nanoseconds", false), f.createIntCounter("grantWaitsTimeout", "Total number of times granting of lock request failed because timeout.", "operations"), f.createLongCounter("grantWaitTimeoutTime", "Total time spent granting of lock requests that failed because timeout.", "nanoseconds", false), f.createIntCounter("grantWaitsNotHolder", "Total number of times granting of lock request failed because reentrant was not holder.", "operations"), f.createLongCounter("grantWaitNotHolderTime", "Total time spent granting of lock requests that failed because reentrant was not holder.", "nanoseconds", false), f.createIntCounter("grantWaitsFailed", "Total number of times granting of lock request failed because try locks failed.", "operations"), f.createLongCounter("grantWaitFailedTime", "Total time spent granting of lock requests that failed because try locks failed.", "nanoseconds", false), f.createIntCounter("grantWaitsSuspended", "Total number of times granting of lock request failed because lock service was suspended.", "operations"), f.createLongCounter("grantWaitSuspendedTime", "Total time spent granting of lock requests that failed because lock service was suspended.", "nanoseconds", false), f.createIntCounter("grantWaitsDestroyed", "Total number of times granting of lock request failed because lock service was destroyed.", "operations"), f.createLongCounter("grantWaitDestroyedTime", "Total time spent granting of lock requests that failed because lock service was destroyed.", "nanoseconds", false), f.createIntGauge("createGrantorsInProgress", "Current number of initial grantors being created in this process.", "operations"), f.createIntCounter("createGrantorsCompleted", "Total number of initial grantors created in this process.", "operations"), f.createLongCounter("createGrantorTime", "Total time spent waiting create the intial grantor for lock services.", "nanoseconds", false), f.createIntGauge("serviceCreatesInProgress", "Current number of lock services being created in this process.", "operations"), f.createIntCounter("serviceCreatesCompleted", "Total number of lock services created in this process.", "operations"), f.createLongCounter("serviceCreateLatchTime", "Total time spent creating lock services before releasing create latches.", "nanoseconds", false), f.createLongCounter("serviceInitLatchTime", "Total time spent creating lock services before releasing init latches.", "nanoseconds", false), f.createIntGauge("grantorWaitsInProgress", "Current number of threads waiting for grantor latch to open.", "operations"), f.createIntCounter("grantorWaitsCompleted", "Total number of times waiting threads completed waiting for the grantor latch to open.", "operations"), f.createLongCounter("grantorWaitTime", "Total time spent waiting for the grantor latch which resulted in success.", "nanoseconds", false), f.createIntCounter("grantorWaitsFailed", "Total number of times waiting threads failed to finish waiting for the grantor latch to open.", "operations"), f.createLongCounter("grantorWaitFailedTime", "Total time spent waiting for the grantor latch which resulted in failure.", "nanoseconds", false), f.createIntGauge("grantorThreadsInProgress", "Current iterations of work performed by grantor thread(s).", "operations"), f.createIntCounter("grantorThreadsCompleted", "Total number of iterations of work performed by grantor thread(s).", "operations"), f.createLongCounter("grantorThreadExpireAndGrantLocksTime", "Total time spent by grantor thread(s) performing expireAndGrantLocks tasks.", "nanoseconds", false), f.createLongCounter("grantorThreadHandleRequestTimeoutsTime", "Total time spent by grantor thread(s) performing handleRequestTimeouts tasks.", "nanoseconds", false), f.createLongCounter("grantorThreadRemoveUnusedTokensTime", "Total time spent by grantor thread(s) performing removeUnusedTokens tasks.", "nanoseconds", false), f.createLongCounter("grantorThreadTime", "Total time spent by grantor thread(s) performing all grantor tasks.", "nanoseconds", false), f.createIntGauge("pendingRequests", "The current number of pending lock requests queued by grantors in this process.", "pendingRequests"), f.createIntGauge("destroyReadWaitsInProgress", "Current number of threads waiting for a DLockService destroy read lock.", "operations"), f.createIntCounter("destroyReadWaitsCompleted", "Total number of times a DLockService destroy read lock wait has completed successfully.", "operations"), f.createLongCounter("destroyReadWaitTime", "Total time spent waiting for a DLockService destroy read lock that was obtained.", "nanoseconds", false), f.createIntCounter("destroyReadWaitsFailed", "Total number of times a DLockService destroy read lock wait has completed unsuccessfully.", "operations"), f.createLongCounter("destroyReadWaitFailedTime", "Total time spent waiting for a DLockService destroy read lock that was not obtained.", "nanoseconds", false), f.createIntGauge("destroyWriteWaitsInProgress", "Current number of thwrites waiting for a DLockService destroy write lock.", "operations"), f.createIntCounter("destroyWriteWaitsCompleted", "Total number of times a DLockService destroy write lock wait has completed successfully.", "operations"), f.createLongCounter("destroyWriteWaitTime", "Total time spent waiting for a DLockService destroy write lock that was obtained.", "nanoseconds", false), f.createIntCounter("destroyWriteWaitsFailed", "Total number of times a DLockService destroy write lock wait has completed unsuccessfully.", "operations"), f.createLongCounter("destroyWriteWaitFailedTime", "Total time spent waiting for a DLockService destroy write lock that was not obtained.", "nanoseconds", false), f.createIntGauge("destroyReads", "The current number of DLockService destroy read locks held by this process.", "destroyReads"), f.createIntGauge("destroyWrites", "The current number of DLockService destroy write locks held by this process.", "destroyWrites"), f.createIntGauge("lockReleasesInProgress", "Current number of threads releasing a distributed lock.", "operations"), f.createIntCounter("lockReleasesCompleted", "Total number of times distributed lock release has completed.", "operations"), f.createLongCounter("lockReleaseTime", "Total time spent releasing a distributed lock.", "nanoseconds", false), f.createIntCounter("becomeGrantorRequests", "Total number of times this member has explicitly requested to become lock grantor.", "operations"), f.createIntCounter("freeResourcesCompleted", "Total number of times this member has freed resources for a distributed lock.", "operations"), f.createIntCounter("freeResourcesFailed", "Total number of times this member has attempted to free resources for a distributed lock which remained in use.", "operations")});
        grantorsId = type.nameToId("grantors");
        servicesId = type.nameToId("services");
        tokensId = type.nameToId("tokens");
        grantTokensId = type.nameToId("grantTokens");
        requestQueuesId = type.nameToId("requestQueues");
        serialQueueSizeId = type.nameToId("serialQueueSize");
        serialThreadsId = type.nameToId("serialThreads");
        waitingQueueSizeId = type.nameToId("waitingQueueSize");
        waitingThreadsId = type.nameToId("waitingThreads");
        lockWaitsInProgressId = type.nameToId("lockWaitsInProgress");
        lockWaitsCompletedId = type.nameToId("lockWaitsCompleted");
        lockWaitTimeId = type.nameToId("lockWaitTime");
        lockWaitsFailedId = type.nameToId("lockWaitsFailed");
        lockWaitFailedTimeId = type.nameToId("lockWaitFailedTime");
        grantWaitsInProgressId = type.nameToId("grantWaitsInProgress");
        grantWaitsCompletedId = type.nameToId("grantWaitsCompleted");
        grantWaitTimeId = type.nameToId("grantWaitTime");
        grantWaitsNotGrantorId = type.nameToId("grantWaitsNotGrantor");
        grantWaitNotGrantorTimeId = type.nameToId("grantWaitNotGrantorTime");
        grantWaitsTimeoutId = type.nameToId("grantWaitsTimeout");
        grantWaitTimeoutTimeId = type.nameToId("grantWaitTimeoutTime");
        grantWaitsNotHolderId = type.nameToId("grantWaitsNotHolder");
        grantWaitNotHolderTimeId = type.nameToId("grantWaitNotHolderTime");
        grantWaitsFailedId = type.nameToId("grantWaitsFailed");
        grantWaitFailedTimeId = type.nameToId("grantWaitFailedTime");
        grantWaitsSuspendedId = type.nameToId("grantWaitsSuspended");
        grantWaitSuspendedTimeId = type.nameToId("grantWaitSuspendedTime");
        grantWaitsDestroyedId = type.nameToId("grantWaitsDestroyed");
        grantWaitDestroyedTimeId = type.nameToId("grantWaitDestroyedTime");
        createGrantorsInProgressId = type.nameToId("createGrantorsInProgress");
        createGrantorsCompletedId = type.nameToId("createGrantorsCompleted");
        createGrantorTimeId = type.nameToId("createGrantorTime");
        serviceCreatesInProgressId = type.nameToId("serviceCreatesInProgress");
        serviceCreatesCompletedId = type.nameToId("serviceCreatesCompleted");
        serviceCreateLatchTimeId = type.nameToId("serviceCreateLatchTime");
        serviceInitLatchTimeId = type.nameToId("serviceInitLatchTime");
        grantorWaitsInProgressId = type.nameToId("grantorWaitsInProgress");
        grantorWaitsCompletedId = type.nameToId("grantorWaitsCompleted");
        grantorWaitTimeId = type.nameToId("grantorWaitTime");
        grantorWaitsFailedId = type.nameToId("grantorWaitsFailed");
        grantorWaitFailedTimeId = type.nameToId("grantorWaitFailedTime");
        grantorThreadsInProgressId = type.nameToId("grantorThreadsInProgress");
        grantorThreadsCompletedId = type.nameToId("grantorThreadsCompleted");
        grantorThreadExpireAndGrantLocksTimeId = type.nameToId("grantorThreadExpireAndGrantLocksTime");
        grantorThreadHandleRequestTimeoutsTimeId = type.nameToId("grantorThreadHandleRequestTimeoutsTime");
        grantorThreadRemoveUnusedTokensTimeId = type.nameToId("grantorThreadRemoveUnusedTokensTime");
        grantorThreadTimeId = type.nameToId("grantorThreadTime");
        pendingRequestsId = type.nameToId("pendingRequests");
        destroyReadWaitsInProgressId = type.nameToId("destroyReadWaitsInProgress");
        destroyReadWaitsCompletedId = type.nameToId("destroyReadWaitsCompleted");
        destroyReadWaitTimeId = type.nameToId("destroyReadWaitTime");
        destroyReadWaitsFailedId = type.nameToId("destroyReadWaitsFailed");
        destroyReadWaitFailedTimeId = type.nameToId("destroyReadWaitFailedTime");
        destroyWriteWaitsInProgressId = type.nameToId("destroyWriteWaitsInProgress");
        destroyWriteWaitsCompletedId = type.nameToId("destroyWriteWaitsCompleted");
        destroyWriteWaitTimeId = type.nameToId("destroyWriteWaitTime");
        destroyWriteWaitsFailedId = type.nameToId("destroyWriteWaitsFailed");
        destroyWriteWaitFailedTimeId = type.nameToId("destroyWriteWaitFailedTime");
        destroyReadsId = type.nameToId("destroyReads");
        destroyWritesId = type.nameToId("destroyWrites");
        lockReleasesInProgressId = type.nameToId("lockReleasesInProgress");
        lockReleasesCompletedId = type.nameToId("lockReleasesCompleted");
        lockReleaseTimeId = type.nameToId("lockReleaseTime");
        becomeGrantorRequestsId = type.nameToId("becomeGrantorRequests");
        freeResourcesCompletedId = type.nameToId("freeResourcesCompleted");
        freeResourcesFailedId = type.nameToId("freeResourcesFailed");
    }
}

