/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.io.NotSerializableException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.api.Membership;
import org.apache.geode.distributed.internal.membership.api.MembershipView;
import org.apache.geode.distributed.internal.membership.api.QuorumChecker;

public interface Distribution {
    public void start();

    public MembershipView<InternalDistributedMember> getView();

    public InternalDistributedMember getLocalMember();

    public Set<InternalDistributedMember> send(List<InternalDistributedMember> var1, DistributionMessage var2) throws NotSerializableException;

    public Set<InternalDistributedMember> directChannelSend(List<InternalDistributedMember> var1, DistributionMessage var2) throws NotSerializableException;

    public Map<String, Long> getMessageState(DistributedMember var1, boolean var2);

    public void waitForMessageState(InternalDistributedMember var1, Map<String, Long> var2) throws InterruptedException, TimeoutException;

    public boolean requestMemberRemoval(InternalDistributedMember var1, String var2);

    public boolean verifyMember(InternalDistributedMember var1, String var2);

    public <V> V doWithViewLocked(Supplier<V> var1);

    public boolean memberExists(InternalDistributedMember var1);

    public boolean isConnected();

    public void beSick();

    public void beHealthy();

    public void playDead();

    public boolean isBeingSick();

    public void disconnect(boolean var1);

    public void shutdown();

    public void shutdownMessageReceived(InternalDistributedMember var1, String var2);

    public void waitForEventProcessing() throws InterruptedException;

    public void startEventProcessing();

    public void setShutdown();

    public void setReconnectCompleted(boolean var1);

    public boolean shutdownInProgress();

    public void emergencyClose();

    public void addSurpriseMemberForTesting(InternalDistributedMember var1, long var2);

    public void suspectMembers(Set<InternalDistributedMember> var1, String var2);

    public void suspectMember(InternalDistributedMember var1, String var2);

    public Throwable getShutdownCause();

    public boolean addSurpriseMember(InternalDistributedMember var1);

    public void startupMessageFailed(InternalDistributedMember var1, String var2);

    public boolean testMulticast();

    public boolean isSurpriseMember(InternalDistributedMember var1);

    public QuorumChecker getQuorumChecker();

    public DistributedMember getCoordinator();

    public Set<InternalDistributedMember> getMembersNotShuttingDown();

    public boolean waitForDeparture(InternalDistributedMember var1) throws TimeoutException, InterruptedException;

    public boolean waitForDeparture(InternalDistributedMember var1, long var2) throws TimeoutException, InterruptedException;

    public void forceUDPMessagingForCurrentThread();

    public void releaseUDPMessagingForCurrentThread();

    public void setCloseInProgress();

    public Membership<InternalDistributedMember> getMembership();
}

