/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.pubsub;

import java.util.Arrays;
import java.util.List;
import org.apache.geode.redis.internal.executor.GlobPattern;
import org.apache.geode.redis.internal.netty.Client;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;
import org.apache.geode.redis.internal.pubsub.AbstractSubscription;
import org.apache.geode.redis.internal.pubsub.Subscription;
import org.apache.geode.redis.internal.pubsub.Subscriptions;

class PatternSubscription
extends AbstractSubscription {
    final GlobPattern pattern;

    public PatternSubscription(Client client, GlobPattern pattern, ExecutionHandlerContext context, Subscriptions subscriptions) {
        super(client, context, subscriptions);
        if (pattern == null) {
            throw new IllegalArgumentException("pattern cannot be null");
        }
        this.pattern = pattern;
    }

    @Override
    public Subscription.Type getType() {
        return Subscription.Type.PATTERN;
    }

    @Override
    public List<Object> createResponse(byte[] channel, byte[] message) {
        return Arrays.asList("pmessage", this.pattern.globPattern(), channel, message);
    }

    @Override
    public boolean isEqualTo(Object channelOrPattern, Client client) {
        return this.pattern != null && this.pattern.equals(channelOrPattern) && this.getClient().equals(client);
    }

    @Override
    public boolean matches(byte[] channel) {
        return this.pattern.matches(new String(channel));
    }

    @Override
    public byte[] getSubscriptionName() {
        return this.pattern.globPattern().getBytes();
    }
}

