/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.execute;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.BucketSetHelper;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class FunctionExecutionNodePruner {
    public static final Logger logger = LogService.getLogger();

    public static HashMap<InternalDistributedMember, int[]> pruneNodes(PartitionedRegion pr, Set<Integer> buckets) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("FunctionExecutionNodePruner: The buckets to be pruned are: {}", buckets);
        }
        HashMap<InternalDistributedMember, int[]> nodeToBucketsMap = new HashMap<InternalDistributedMember, int[]>();
        HashMap<InternalDistributedMember, int[]> prunedNodeToBucketsMap = new HashMap<InternalDistributedMember, int[]>();
        try {
            for (Integer bucketId : buckets) {
                Set<InternalDistributedMember> nodes = pr.getRegionAdvisor().getBucketOwners(bucketId);
                if (nodes.isEmpty()) {
                    if (isDebugEnabled) {
                        logger.debug("FunctionExecutionNodePruner: The buckets owners of the bucket: {} are empty, double check if they are all offline", (Object)bucketId);
                    }
                    nodes.add(pr.getOrCreateNodeForBucketRead(bucketId));
                }
                if (isDebugEnabled) {
                    logger.debug("FunctionExecutionNodePruner: The buckets owners of the bucket: {} are: {}", (Object)bucketId, nodes);
                }
                for (InternalDistributedMember node : nodes) {
                    int[] bucketArray;
                    if (nodeToBucketsMap.get(node) == null) {
                        bucketArray = new int[buckets.size() + 1];
                        bucketArray[0] = 0;
                        BucketSetHelper.add(bucketArray, bucketId);
                        nodeToBucketsMap.put(node, bucketArray);
                        continue;
                    }
                    bucketArray = (int[])nodeToBucketsMap.get(node);
                    BucketSetHelper.add(bucketArray, bucketId);
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (isDebugEnabled) {
            logger.debug("FunctionExecutionNodePruner: The node to buckets map is: {}", nodeToBucketsMap);
        }
        int[] currentBucketArray = new int[buckets.size() + 1];
        currentBucketArray[0] = 0;
        InternalDistributedMember localNode = pr.getRegionAdvisor().getDistributionManager().getId();
        if (nodeToBucketsMap.get(localNode) != null) {
            int[] bucketArray = (int[])nodeToBucketsMap.get(localNode);
            if (isDebugEnabled) {
                logger.debug("FunctionExecutionNodePruner: Adding the node: {} which is local and buckets {} to prunedMap", (Object)localNode, (Object)bucketArray);
            }
            System.arraycopy(bucketArray, 0, currentBucketArray, 0, bucketArray[0] + 1);
            prunedNodeToBucketsMap.put(localNode, bucketArray);
            nodeToBucketsMap.remove(localNode);
        }
        while (!FunctionExecutionNodePruner.arrayAndSetAreEqual(buckets, currentBucketArray) && nodeToBucketsMap.size() != 0) {
            InternalDistributedMember node = FunctionExecutionNodePruner.findNextNode(nodeToBucketsMap.entrySet(), currentBucketArray);
            if (node == null) {
                if (!isDebugEnabled) break;
                logger.debug("FunctionExecutionNodePruner: Breaking out of prunedMap calculation due to no available nodes for remaining buckets");
                break;
            }
            int[] bucketArray = (int[])nodeToBucketsMap.get(node);
            if (BucketSetHelper.length(bucketArray = FunctionExecutionNodePruner.removeAllElements(bucketArray, currentBucketArray)) != 0) {
                currentBucketArray = FunctionExecutionNodePruner.addAllElements(currentBucketArray, bucketArray);
                prunedNodeToBucketsMap.put(node, bucketArray);
                if (isDebugEnabled) {
                    logger.debug("FunctionExecutionNodePruner: Adding the node: {} and buckets {} to prunedMap", (Object)node, (Object)bucketArray);
                }
            }
            nodeToBucketsMap.remove(node);
        }
        if (isDebugEnabled) {
            logger.debug("FunctionExecutionNodePruner: The final prunedNodeToBucket calculated is: {}", prunedNodeToBucketsMap);
        }
        return prunedNodeToBucketsMap;
    }

    private static InternalDistributedMember findNextNode(Set<Map.Entry<InternalDistributedMember, int[]>> entrySet, int[] currentBucketArray) {
        InternalDistributedMember node = null;
        int max = -1;
        ArrayList<InternalDistributedMember> nodesOfEqualSize = new ArrayList<InternalDistributedMember>();
        for (Map.Entry<InternalDistributedMember, int[]> entry : entrySet) {
            int[] buckets = entry.getValue();
            int[] tempbuckets = new int[buckets.length];
            System.arraycopy(buckets, 0, tempbuckets, 0, buckets[0] + 1);
            tempbuckets = FunctionExecutionNodePruner.removeAllElements(tempbuckets, currentBucketArray);
            if (max < BucketSetHelper.length(tempbuckets)) {
                max = BucketSetHelper.length(tempbuckets);
                node = entry.getKey();
                nodesOfEqualSize.clear();
                nodesOfEqualSize.add(node);
                continue;
            }
            if (max != BucketSetHelper.length(tempbuckets)) continue;
            nodesOfEqualSize.add(node);
        }
        return nodesOfEqualSize.size() > 0 ? (InternalDistributedMember)nodesOfEqualSize.get(PartitionedRegion.RANDOM.nextInt(nodesOfEqualSize.size())) : null;
    }

    public static Map<Integer, Set> groupByBucket(PartitionedRegion pr, Set routingKeys, boolean primaryMembersNeeded, boolean hasRoutingObjects, boolean isBucketSetAsFilter) {
        HashMap<Integer, Set> bucketToKeysMap = new HashMap<Integer, Set>();
        for (Object key : routingKeys) {
            Integer bucketId = isBucketSetAsFilter ? (Integer)key : (hasRoutingObjects ? Integer.valueOf(PartitionedRegionHelper.getHashKey(pr, key)) : Integer.valueOf(PartitionedRegionHelper.getHashKey(pr, Operation.FUNCTION_EXECUTION, key, null, null)));
            InternalDistributedMember mem = null;
            mem = primaryMembersNeeded ? pr.getOrCreateNodeForBucketWrite(bucketId, null) : pr.getOrCreateNodeForBucketRead(bucketId);
            if (mem == null) {
                throw new FunctionException(String.format("No target node found for KEY, %s", key));
            }
            HashSet bucketKeys = (HashSet)bucketToKeysMap.get(bucketId);
            if (bucketKeys == null) {
                bucketKeys = new HashSet();
                bucketToKeysMap.put(bucketId, bucketKeys);
            }
            bucketKeys.add(key);
        }
        return bucketToKeysMap;
    }

    public static int[] getBucketSet(PartitionedRegion pr, Set routingKeys, boolean hasRoutingObjects, boolean isBucketSetAsFilter) {
        int[] bucketArray = null;
        for (Object key : routingKeys) {
            Integer bucketId = isBucketSetAsFilter ? (Integer)key : (hasRoutingObjects ? Integer.valueOf(PartitionedRegionHelper.getHashKey(pr, key)) : Integer.valueOf(PartitionedRegionHelper.getHashKey(pr, Operation.FUNCTION_EXECUTION, key, null, null)));
            if (bucketArray == null) {
                bucketArray = new int[routingKeys.size() + 1];
                bucketArray[0] = 0;
            }
            BucketSetHelper.add(bucketArray, bucketId);
        }
        return bucketArray;
    }

    public static HashMap<InternalDistributedMember, int[]> groupByMemberToBuckets(PartitionedRegion pr, Set<Integer> bucketSet, boolean primaryOnly) {
        if (primaryOnly) {
            HashMap<InternalDistributedMember, int[]> memberToBucketsMap = new HashMap<InternalDistributedMember, int[]>();
            try {
                for (Integer bucketId : bucketSet) {
                    InternalDistributedMember mem = pr.getOrCreateNodeForBucketWrite(bucketId, null);
                    int[] bucketArray = memberToBucketsMap.get(mem);
                    if (bucketArray == null) {
                        bucketArray = new int[bucketSet.size() + 1];
                        memberToBucketsMap.put(mem, bucketArray);
                        bucketArray[0] = 0;
                    }
                    BucketSetHelper.add(bucketArray, bucketId);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            return memberToBucketsMap;
        }
        return FunctionExecutionNodePruner.pruneNodes(pr, bucketSet);
    }

    private static boolean arrayAndSetAreEqual(Set<Integer> setA, int[] arrayB) {
        Set<Integer> setB = BucketSetHelper.toSet(arrayB);
        return setA.equals(setB);
    }

    private static int[] removeAllElements(int[] arrayA, int[] arrayB) {
        if (BucketSetHelper.length(arrayA) == 0 || BucketSetHelper.length(arrayB) == 0) {
            return arrayA;
        }
        Set<Integer> inSet = BucketSetHelper.toSet(arrayA);
        Set<Integer> subSet = BucketSetHelper.toSet(arrayB);
        inSet.removeAll(subSet);
        int[] outArray = BucketSetHelper.fromSet(inSet);
        return outArray;
    }

    private static int[] addAllElements(int[] arrayA, int[] arrayB) {
        if (BucketSetHelper.length(arrayB) == 0) {
            return arrayA;
        }
        Set<Integer> inSet = BucketSetHelper.toSet(arrayA);
        Set<Integer> addSet = BucketSetHelper.toSet(arrayB);
        inSet.addAll(addSet);
        int[] outArray = BucketSetHelper.fromSet(inSet);
        return outArray;
    }
}

