/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import org.apache.geode.internal.cache.backup.ScriptGenerator;

class UnixScriptGenerator
implements ScriptGenerator {
    private static final String SCRIPT_FILE_NAME = "restore.sh";

    UnixScriptGenerator() {
    }

    @Override
    public void writePreamble(BufferedWriter writer) throws IOException {
        writer.write("#!/bin/bash -e");
        writer.newLine();
        writer.write("cd `dirname $0`");
        writer.newLine();
    }

    @Override
    public void writeComment(BufferedWriter writer, String string) throws IOException {
        writer.write("# " + string);
        writer.newLine();
    }

    @Override
    public void writeCopyDirectoryContents(BufferedWriter writer, File backup, File original, boolean backupHasFiles) throws IOException {
        if (backupHasFiles) {
            writer.write("mkdir -p '" + original + "'");
            writer.newLine();
            writer.write("cp -rp '" + backup + "'/* '" + original + "'");
            writer.newLine();
        }
    }

    @Override
    public void writeCopyFile(BufferedWriter writer, File backup, File original) throws IOException {
        writer.write("mkdir -p '" + original.getParent() + "'");
        writer.newLine();
        writer.write("cp -p '" + backup + "' '" + original + "'");
        writer.newLine();
    }

    @Override
    public void writeExistenceTest(BufferedWriter writer, File file) throws IOException {
        writer.write("test -e '" + file + "' && echo '" + "Backup not restored. Refusing to overwrite " + file + "' && exit 1 ");
        writer.newLine();
    }

    @Override
    public void writeExit(BufferedWriter writer) {
    }

    @Override
    public String getScriptName() {
        return SCRIPT_FILE_NAME;
    }
}

