/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.SystemFailure;
import org.apache.geode.admin.AdminDistributedSystem;
import org.apache.geode.admin.AdminException;
import org.apache.geode.admin.CacheDoesNotExistException;
import org.apache.geode.admin.ConfigurationParameter;
import org.apache.geode.admin.RuntimeAdminException;
import org.apache.geode.admin.StatisticResource;
import org.apache.geode.admin.SystemMember;
import org.apache.geode.admin.SystemMemberCache;
import org.apache.geode.admin.SystemMemberType;
import org.apache.geode.admin.internal.ConfigurationParameterImpl;
import org.apache.geode.admin.internal.ConfigurationParameterListener;
import org.apache.geode.admin.internal.InetAddressUtils;
import org.apache.geode.admin.internal.InetAddressUtilsWithLogging;
import org.apache.geode.admin.internal.StatisticResourceImpl;
import org.apache.geode.admin.internal.SystemMemberCacheImpl;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.Role;
import org.apache.geode.distributed.internal.DistributionConfigImpl;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Config;
import org.apache.geode.internal.ConfigSource;
import org.apache.geode.internal.admin.GemFireVM;
import org.apache.geode.internal.admin.StatResource;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class SystemMemberImpl
implements SystemMember,
ConfigurationParameterListener {
    private static final Logger logger = LogService.getLogger();
    protected String id;
    protected InternalDistributedMember internalId;
    protected String name;
    protected String host;
    protected Map parms = new HashMap();
    protected AdminDistributedSystem system;
    private GemFireVM vm;

    protected SystemMemberImpl(AdminDistributedSystem system) throws AdminException {
        this.system = system;
        this.refreshConfig(this.getDefaultConfig());
    }

    public SystemMemberImpl(AdminDistributedSystem system, GemFireVM vm) throws AdminException {
        this(system);
        this.setGemFireVM(vm);
    }

    protected SystemMemberImpl(AdminDistributedSystem system, InternalDistributedMember member) throws AdminException {
        this(system);
        this.updateByInternalDistributedMember(member);
    }

    protected Config getDefaultConfig() {
        Properties props = new Properties();
        return new DistributionConfigImpl(props);
    }

    @Override
    public AdminDistributedSystem getDistributedSystem() {
        return this.system;
    }

    public InternalDistributedMember getInternalId() {
        return this.internalId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public InetAddress getHostAddress() {
        return InetAddressUtilsWithLogging.toInetAddress(this.getHost());
    }

    @Override
    public String getLog() {
        String childTail = null;
        String mainTail = null;
        GemFireVM vm = this.getGemFireVM();
        if (vm != null) {
            String[] log = vm.getSystemLogs();
            if (log != null && log.length > 0) {
                mainTail = log[0];
            }
            if (log != null && log.length > 1) {
                childTail = log[1];
            }
        }
        if (childTail == null && mainTail == null) {
            return "No log file configured, log messages will be directed to stdout.";
        }
        StringBuffer result = new StringBuffer();
        if (mainTail != null) {
            result.append(mainTail);
        }
        if (childTail != null) {
            result.append("\n-------------------- tail of child log --------------------\n");
            result.append(childTail);
        }
        return result.toString();
    }

    @Override
    public Properties getLicense() {
        GemFireVM vm = this.getGemFireVM();
        if (vm == null) {
            return null;
        }
        return new Properties();
    }

    @Override
    public String getVersion() {
        GemFireVM vm = this.getGemFireVM();
        if (vm == null) {
            return null;
        }
        return vm.getVersionInfo();
    }

    @Override
    public StatisticResource[] getStat(String statisticsTypeName) throws AdminException {
        StatisticResource[] res = new StatisticResource[]{};
        if (this.vm != null) {
            res = this.getStatsImpl(this.vm.getStats(statisticsTypeName));
        }
        return res.length == 0 ? null : res;
    }

    @Override
    public StatisticResource[] getStats() throws AdminException {
        StatisticResource[] statsImpl = new StatisticResource[]{};
        if (this.vm != null) {
            statsImpl = this.getStatsImpl(this.vm.getStats(null));
        }
        return statsImpl;
    }

    @Override
    public boolean hasCache() {
        GemFireVM member = this.getGemFireVM();
        if (member == null) {
            return false;
        }
        return member.getCacheInfo() != null;
    }

    @Override
    public SystemMemberCache getCache() throws AdminException {
        GemFireVM vm = this.getGemFireVM();
        if (vm == null) {
            return null;
        }
        try {
            return this.createSystemMemberCache(vm);
        }
        catch (CancelException ex) {
            return null;
        }
        catch (CacheDoesNotExistException ex) {
            return null;
        }
    }

    @Override
    public void refreshConfig() throws AdminException {
        GemFireVM vm = this.getGemFireVM();
        if (vm == null) {
            return;
        }
        this.refreshConfig(vm.getConfig());
    }

    public void refreshConfig(Config config) throws AdminException {
        if (config == null) {
            throw new AdminException(String.format("Failed to refresh configuration parameters for: %s", this.getId()));
        }
        String[] names = config.getAttributeNames();
        if (names == null || names.length < 1) {
            throw new AdminException(String.format("Failed to refresh configuration parameters for: %s", this.getId()));
        }
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            Object value = config.getAttributeObject(name);
            if (value == null) continue;
            ConfigurationParameter parm = this.createConfigurationParameter(name, config.getAttributeDescription(name), value, config.getAttributeType(name), config.isAttributeModifiable(name));
            ((ConfigurationParameterImpl)parm).addConfigurationParameterListener(this);
            this.parms.put(name, parm);
        }
    }

    @Override
    public ConfigurationParameter[] getConfiguration() {
        ConfigurationParameter[] array = new ConfigurationParameter[this.parms.size()];
        this.parms.values().toArray(array);
        return array;
    }

    @Override
    public ConfigurationParameter[] setConfiguration(ConfigurationParameter[] parms) throws AdminException {
        for (int i = 0; i < parms.length; ++i) {
            ConfigurationParameter parm = parms[i];
            this.parms.put(parm.getName(), parm);
        }
        GemFireVM vm = this.getGemFireVM();
        if (vm != null) {
            Config config = vm.getConfig();
            for (int i = 0; i < parms.length; ++i) {
                config.setAttributeObject(parms[i].getName(), parms[i].getValue(), ConfigSource.runtime());
            }
            vm.setConfig(config);
        }
        return this.getConfiguration();
    }

    @Override
    public SystemMemberType getType() {
        return SystemMemberType.APPLICATION;
    }

    @Override
    public void configurationParameterValueChanged(ConfigurationParameter parm) {
        try {
            this.setConfiguration(new ConfigurationParameter[]{parm});
        }
        catch (AdminException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw new RuntimeAdminException(e);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public String toString() {
        return this.getName();
    }

    protected GemFireVM getGemFireVM() {
        return this.vm;
    }

    void setGemFireVM(GemFireVM vm) throws AdminException {
        this.vm = vm;
        if (vm != null) {
            this.internalId = vm.getId();
            this.id = this.internalId.toString();
            this.name = vm.getName();
            this.host = InetAddressUtils.toHostString(vm.getHost());
        } else {
            this.internalId = null;
            this.id = null;
            this.host = this.getHost();
        }
        if ("".equals(this.name)) {
            this.name = this.id;
        }
        if (vm != null) {
            this.refreshConfig();
        }
    }

    private void updateByInternalDistributedMember(InternalDistributedMember member) {
        if (member != null) {
            this.internalId = member;
            this.id = this.internalId.toString();
            this.host = this.internalId.getHost();
            this.name = this.internalId.getName();
            if (this.name == null || "".equals(this.name)) {
                this.name = this.id;
            }
        }
    }

    protected StatisticResource createStatisticResource(StatResource stat) throws AdminException {
        return new StatisticResourceImpl(stat, this);
    }

    protected ConfigurationParameter createConfigurationParameter(String name, String description, Object value, Class type, boolean userModifiable) {
        return new ConfigurationParameterImpl(name, description, value, type, userModifiable);
    }

    protected SystemMemberCache createSystemMemberCache(GemFireVM vm) throws AdminException {
        return new SystemMemberCacheImpl(vm);
    }

    protected StatisticResource[] getStatsImpl(StatResource[] stats) throws AdminException {
        ArrayList<StatisticResource> statList = new ArrayList<StatisticResource>();
        for (int i = 0; i < stats.length; ++i) {
            statList.add(this.createStatisticResource(stats[i]));
        }
        return statList.toArray(new StatisticResource[0]);
    }

    @Override
    public String[] getRoles() {
        Set<Role> roles = this.internalId.getRoles();
        String[] roleNames = new String[roles.size()];
        Iterator<Role> iter = roles.iterator();
        for (int i = 0; i < roleNames.length; ++i) {
            Role role = iter.next();
            roleNames[i] = role.getName();
        }
        return roleNames;
    }

    @Override
    public DistributedMember getDistributedMember() {
        return this.internalId;
    }
}

