/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import javax.naming.NamingException;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.jndi.JNDIInvoker;
import org.apache.geode.management.cli.CliFunction;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.i18n.CliStrings;

public class DestroyJndiBindingFunction
extends CliFunction<Object[]> {
    @Override
    public CliFunctionResult executeFunction(FunctionContext<Object[]> context) {
        String jndiName = (String)((Object[])context.getArguments())[0];
        boolean destroyingDataSource = (Boolean)((Object[])context.getArguments())[1];
        String typeName = "Jndi binding";
        if (destroyingDataSource) {
            typeName = "Data source";
            if (!this.isValidDataSource(jndiName)) {
                return new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.ERROR, CliStrings.format((String)"Data Source {0} has invalid type for destroy data-source, destroy jndi-binding command should be used.", (Object)jndiName));
            }
        }
        String RESULT_MESSAGE = "{0} \"{1}\" destroyed on \"{2}\"";
        String EXCEPTION_RESULT_MESSAGE = "{0} \"{1}\" not found on \"{2}\"";
        try {
            JNDIInvoker.unMapDatasource((String)jndiName);
            return new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.OK, CliStrings.format((String)"{0} \"{1}\" destroyed on \"{2}\"", (Object[])new Object[]{typeName, jndiName, context.getMemberName()}));
        }
        catch (NamingException e) {
            return new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.OK, CliStrings.format((String)"{0} \"{1}\" not found on \"{2}\"", (Object[])new Object[]{typeName, jndiName, context.getMemberName()}));
        }
    }

    boolean isValidDataSource(String jndiName) {
        return JNDIInvoker.isValidDataSource((String)jndiName);
    }
}

