/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.flume.Channel;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.Sink;
import org.apache.flume.Transaction;
import org.apache.flume.conf.Configurable;
import org.apache.flume.instrumentation.SinkCounter;
import org.apache.flume.sink.AbstractSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSink
extends AbstractSink
implements Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(HttpSink.class);
    private static final int HTTP_STATUS_CONTINUE = 100;
    private static final int DEFAULT_CONNECT_TIMEOUT = 5000;
    private static final int DEFAULT_REQUEST_TIMEOUT = 5000;
    private static final String DEFAULT_CONTENT_TYPE = "text/plain";
    private static final String DEFAULT_ACCEPT_HEADER = "text/plain";
    private URL endpointUrl;
    private SinkCounter sinkCounter;
    private int connectTimeout = 5000;
    private int requestTimeout = 5000;
    private String contentTypeHeader = "text/plain";
    private String acceptHeader = "text/plain";
    private boolean defaultBackoff;
    private boolean defaultRollback;
    private boolean defaultIncrementMetrics;
    private HashMap<String, Boolean> backoffOverrides = new HashMap();
    private HashMap<String, Boolean> rollbackOverrides = new HashMap();
    private HashMap<String, Boolean> incrementMetricsOverrides = new HashMap();
    private ConnectionBuilder connectionBuilder;

    public final void configure(Context context) {
        String configuredEndpoint = context.getString("endpoint", "");
        LOG.info("Read endpoint URL from configuration : " + configuredEndpoint);
        try {
            this.endpointUrl = new URL(configuredEndpoint);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Endpoint URL invalid", e);
        }
        this.connectTimeout = context.getInteger("connectTimeout", Integer.valueOf(5000));
        if (this.connectTimeout <= 0) {
            throw new IllegalArgumentException("Connect timeout must be a non-zero and positive");
        }
        LOG.info("Using connect timeout : " + this.connectTimeout);
        this.requestTimeout = context.getInteger("requestTimeout", Integer.valueOf(5000));
        if (this.requestTimeout <= 0) {
            throw new IllegalArgumentException("Request timeout must be a non-zero and positive");
        }
        LOG.info("Using request timeout : " + this.requestTimeout);
        this.acceptHeader = context.getString("acceptHeader", "text/plain");
        LOG.info("Using Accept header value : " + this.acceptHeader);
        this.contentTypeHeader = context.getString("contentTypeHeader", "text/plain");
        LOG.info("Using Content-Type header value : " + this.contentTypeHeader);
        this.defaultBackoff = context.getBoolean("defaultBackoff", Boolean.valueOf(true));
        LOG.info("Channel backoff by default is " + this.defaultBackoff);
        this.defaultRollback = context.getBoolean("defaultRollback", Boolean.valueOf(true));
        LOG.info("Transaction rollback by default is " + this.defaultRollback);
        this.defaultIncrementMetrics = context.getBoolean("defaultIncrementMetrics", Boolean.valueOf(false));
        LOG.info("Incrementing metrics by default is " + this.defaultIncrementMetrics);
        this.parseConfigOverrides("backoff", context, this.backoffOverrides);
        this.parseConfigOverrides("rollback", context, this.rollbackOverrides);
        this.parseConfigOverrides("incrementMetrics", context, this.incrementMetricsOverrides);
        if (this.sinkCounter == null) {
            this.sinkCounter = new SinkCounter(this.getName());
        }
        this.connectionBuilder = new ConnectionBuilder();
    }

    public final void start() {
        LOG.info("Starting HttpSink");
        this.sinkCounter.start();
    }

    public final void stop() {
        LOG.info("Stopping HttpSink");
        this.sinkCounter.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Sink.Status process() throws EventDeliveryException {
        Sink.Status status;
        block26: {
            status = null;
            OutputStream outputStream = null;
            Channel ch = this.getChannel();
            Transaction txn = ch.getTransaction();
            txn.begin();
            try {
                Event event = ch.take();
                byte[] eventBody = null;
                if (event != null) {
                    eventBody = event.getBody();
                }
                if (eventBody != null && eventBody.length > 0) {
                    this.sinkCounter.incrementEventDrainAttemptCount();
                    LOG.debug("Sending request : " + new String(event.getBody()));
                    try {
                        HttpURLConnection connection = this.connectionBuilder.getConnection();
                        outputStream = connection.getOutputStream();
                        outputStream.write(eventBody);
                        outputStream.flush();
                        outputStream.close();
                        int httpStatusCode = connection.getResponseCode();
                        LOG.debug("Got status code : " + httpStatusCode);
                        if (httpStatusCode < 400) {
                            connection.getInputStream().close();
                        } else {
                            LOG.debug("bad request");
                            connection.getErrorStream().close();
                        }
                        LOG.debug("Response processed and closed");
                        if (httpStatusCode >= 100) {
                            String httpStatusString = String.valueOf(httpStatusCode);
                            boolean shouldRollback = this.findOverrideValue(httpStatusString, this.rollbackOverrides, this.defaultRollback);
                            if (shouldRollback) {
                                txn.rollback();
                            } else {
                                txn.commit();
                            }
                            boolean shouldBackoff = this.findOverrideValue(httpStatusString, this.backoffOverrides, this.defaultBackoff);
                            status = shouldBackoff ? Sink.Status.BACKOFF : Sink.Status.READY;
                            boolean shouldIncrementMetrics = this.findOverrideValue(httpStatusString, this.incrementMetricsOverrides, this.defaultIncrementMetrics);
                            if (shouldIncrementMetrics) {
                                this.sinkCounter.incrementEventDrainSuccessCount();
                            }
                            if (shouldRollback) {
                                if (shouldBackoff) {
                                    LOG.info(String.format("Got status code %d from HTTP server. Rolled back event and backed off.", httpStatusCode));
                                } else {
                                    LOG.info(String.format("Got status code %d from HTTP server. Rolled back event for retry.", httpStatusCode));
                                }
                            }
                            break block26;
                        }
                        txn.rollback();
                        status = Sink.Status.BACKOFF;
                        LOG.warn("Malformed response returned from server, retrying");
                    }
                    catch (IOException e) {
                        txn.rollback();
                        status = Sink.Status.BACKOFF;
                        LOG.error("Error opening connection, or request timed out", (Throwable)e);
                        this.sinkCounter.incrementEventWriteFail();
                    }
                    break block26;
                }
                txn.commit();
                status = Sink.Status.BACKOFF;
                LOG.warn("Processed empty event");
            }
            catch (Throwable t) {
                txn.rollback();
                status = Sink.Status.BACKOFF;
                LOG.error("Error sending HTTP request, retrying", t);
                this.sinkCounter.incrementEventWriteOrChannelFail(t);
                if (t instanceof Error) {
                    throw (Error)t;
                }
            }
            finally {
                txn.close();
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException event) {}
                }
            }
        }
        return status;
    }

    private void parseConfigOverrides(String propertyName, Context context, Map<String, Boolean> override) {
        Map config = context.getSubProperties(propertyName + ".");
        if (config != null) {
            for (Map.Entry value : config.entrySet()) {
                LOG.info(String.format("Read %s value for status code %s as %s", propertyName, value.getKey(), value.getValue()));
                if (override.containsKey(value.getKey())) {
                    LOG.warn(String.format("Ignoring duplicate config value for %s.%s", propertyName, value.getKey()));
                    continue;
                }
                override.put((String)value.getKey(), Boolean.valueOf((String)value.getValue()));
            }
        }
    }

    private boolean findOverrideValue(String statusCode, HashMap<String, Boolean> overrides, boolean defaultValue) {
        Boolean overrideValue = overrides.get(statusCode);
        if (overrideValue == null && (overrideValue = overrides.get(statusCode.substring(0, 1) + "XX")) == null) {
            overrideValue = defaultValue;
        }
        return overrideValue;
    }

    final void setConnectionBuilder(ConnectionBuilder builder) {
        this.connectionBuilder = builder;
    }

    final void setSinkCounter(SinkCounter newSinkCounter) {
        this.sinkCounter = newSinkCounter;
    }

    class ConnectionBuilder {
        ConnectionBuilder() {
        }

        public HttpURLConnection getConnection() throws IOException {
            HttpURLConnection connection = (HttpURLConnection)HttpSink.this.endpointUrl.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", HttpSink.this.contentTypeHeader);
            connection.setRequestProperty("Accept", HttpSink.this.acceptHeader);
            connection.setConnectTimeout(HttpSink.this.connectTimeout);
            connection.setReadTimeout(HttpSink.this.requestTimeout);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.connect();
            return connection;
        }
    }
}

