/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.protobuf.ByteString;
import org.hbase.async.Bytes;
import org.hbase.async.FilterComparator;
import org.hbase.async.generated.ComparatorPB;
import org.jboss.netty.buffer.ChannelBuffer;

public final class SubstringComparator
extends FilterComparator {
    private static final byte[] NAME = Bytes.UTF8("org.apache.hadoop.hbase.filter.SubstringComparator");
    private final String substr;

    public SubstringComparator(String substr) {
        this.substr = substr;
    }

    public String substring() {
        return this.substr;
    }

    @Override
    byte[] name() {
        return NAME;
    }

    @Override
    ComparatorPB.Comparator toProtobuf() {
        ByteString byte_string = ComparatorPB.SubstringComparator.newBuilder().setSubstr(this.substr).build().toByteString();
        return super.toProtobuf(byte_string);
    }

    @Override
    void serializeOld(ChannelBuffer buf) {
        super.serializeOld(buf);
        buf.writeByte(0);
        buf.writeByte((int)((byte)NAME.length));
        buf.writeBytes(NAME);
        byte[] expr_bytes = Bytes.UTF8(this.substr);
        buf.writeShort(expr_bytes.length);
        buf.writeBytes(expr_bytes);
    }

    @Override
    int predictSerializedSize() {
        return super.predictSerializedSize() + 1 + 1 + NAME.length + 2 + Bytes.UTF8(this.substr).length;
    }

    public String toString() {
        return String.format("%s(%s)", this.getClass().getSimpleName(), this.substr);
    }
}

