/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.traffic;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.traffic.AbstractTrafficShapingHandler;
import org.jboss.netty.handler.traffic.TrafficCounter;
import org.jboss.netty.util.ObjectSizeEstimator;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ChannelHandler.Sharable
public class GlobalTrafficShapingHandler
extends AbstractTrafficShapingHandler {
    private Map<Integer, List<ToSend>> messagesQueues = new HashMap<Integer, List<ToSend>>();

    void createGlobalTrafficCounter() {
        if (this.timer != null) {
            TrafficCounter tc = new TrafficCounter(this, this.timer, "GlobalTC", this.checkInterval);
            this.setTrafficCounter(tc);
            tc.start();
        }
    }

    public GlobalTrafficShapingHandler(Timer timer, long writeLimit, long readLimit, long checkInterval) {
        super(timer, writeLimit, readLimit, checkInterval);
        this.createGlobalTrafficCounter();
    }

    public GlobalTrafficShapingHandler(Timer timer, long writeLimit, long readLimit, long checkInterval, long maxTime) {
        super(timer, writeLimit, readLimit, checkInterval, maxTime);
        this.createGlobalTrafficCounter();
    }

    public GlobalTrafficShapingHandler(Timer timer, long writeLimit, long readLimit) {
        super(timer, writeLimit, readLimit);
        this.createGlobalTrafficCounter();
    }

    public GlobalTrafficShapingHandler(Timer timer, long checkInterval) {
        super(timer, checkInterval);
        this.createGlobalTrafficCounter();
    }

    public GlobalTrafficShapingHandler(Timer timer) {
        super(timer);
        this.createGlobalTrafficCounter();
    }

    public GlobalTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long writeLimit, long readLimit, long checkInterval) {
        super(objectSizeEstimator, timer, writeLimit, readLimit, checkInterval);
        this.createGlobalTrafficCounter();
    }

    public GlobalTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long writeLimit, long readLimit, long checkInterval, long maxTime) {
        super(objectSizeEstimator, timer, writeLimit, readLimit, checkInterval, maxTime);
        this.createGlobalTrafficCounter();
    }

    public GlobalTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long writeLimit, long readLimit) {
        super(objectSizeEstimator, timer, writeLimit, readLimit);
        this.createGlobalTrafficCounter();
    }

    public GlobalTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long checkInterval) {
        super(objectSizeEstimator, timer, checkInterval);
        this.createGlobalTrafficCounter();
    }

    public GlobalTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer) {
        super(objectSizeEstimator, timer);
        this.createGlobalTrafficCounter();
    }

    @Override
    protected synchronized void submitWrite(final ChannelHandlerContext ctx, MessageEvent evt, long delay) throws Exception {
        Integer key = ctx.getChannel().getId();
        List<ToSend> messagesQueue = this.messagesQueues.get(key);
        if (delay == 0L && (messagesQueue == null || messagesQueue.isEmpty())) {
            this.internalSubmitWrite(ctx, evt);
            return;
        }
        if (this.timer == null) {
            Thread.sleep(delay);
            this.internalSubmitWrite(ctx, evt);
            return;
        }
        if (messagesQueue == null) {
            messagesQueue = new LinkedList<ToSend>();
            this.messagesQueues.put(key, messagesQueue);
        }
        ToSend newToSend = new ToSend(delay, evt);
        messagesQueue.add(newToSend);
        final List<ToSend> mqfinal = messagesQueue;
        this.timer.newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                GlobalTrafficShapingHandler.this.sendAllValid(ctx, mqfinal);
            }
        }, delay + 1L, TimeUnit.MILLISECONDS);
    }

    private synchronized void sendAllValid(ChannelHandlerContext ctx, List<ToSend> messagesQueue) throws Exception {
        while (!messagesQueue.isEmpty()) {
            ToSend newToSend = messagesQueue.remove(0);
            if (newToSend.date <= System.currentTimeMillis()) {
                this.internalSubmitWrite(ctx, newToSend.toSend);
                continue;
            }
            messagesQueue.add(0, newToSend);
            break;
        }
    }

    @Override
    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        Integer key = ctx.getChannel().getId();
        LinkedList messagesQueue = new LinkedList();
        this.messagesQueues.put(key, messagesQueue);
    }

    @Override
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        Integer key = ctx.getChannel().hashCode();
        List<ToSend> mq = this.messagesQueues.remove(key);
        if (mq != null) {
            mq.clear();
        }
        super.channelClosed(ctx, e);
    }

    private static final class ToSend {
        final long date;
        final MessageEvent toSend;

        private ToSend(long delay, MessageEvent toSend) {
            this.date = System.currentTimeMillis() + delay;
            this.toSend = toSend;
        }
    }
}

