/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
public final class CommonTypeStrategy
implements TypeStrategy {
    @Override
    public Optional<DataType> inferType(CallContext callContext) {
        List<LogicalType> actualTypes = callContext.getArgumentDataTypes().stream().map(DataType::getLogicalType).collect(Collectors.toList());
        return LogicalTypeMerging.findCommonType(actualTypes).map(TypeConversions::fromLogicalToDataType);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof CommonTypeStrategy;
    }

    public int hashCode() {
        return CommonTypeStrategy.class.hashCode();
    }
}

