/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.internal;

import java.util.Collections;
import java.util.Optional;
import org.apache.flink.table.api.CompiledPlan;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TablePipeline;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.SinkModifyOperation;

class TablePipelineImpl
implements TablePipeline {
    private final TableEnvironmentInternal tableEnvironment;
    private final ModifyOperation operation;

    TablePipelineImpl(TableEnvironmentInternal tableEnvironment, ModifyOperation operation) {
        this.tableEnvironment = tableEnvironment;
        this.operation = operation;
    }

    ModifyOperation getOperation() {
        return this.operation;
    }

    @Override
    public CompiledPlan compilePlan() throws TableException {
        return this.tableEnvironment.compilePlan(Collections.singletonList(this.operation));
    }

    @Override
    public TableResult execute() {
        return this.tableEnvironment.executeInternal(this.operation);
    }

    @Override
    public String explain(ExplainDetail ... extraDetails) {
        return this.tableEnvironment.explainInternal(Collections.singletonList(this.operation), extraDetails);
    }

    @Override
    public Optional<ObjectIdentifier> getSinkIdentifier() {
        SinkModifyOperation sinkModifyOperation;
        if (this.operation instanceof SinkModifyOperation && !(sinkModifyOperation = (SinkModifyOperation)this.operation).getContextResolvedTable().isAnonymous()) {
            return Optional.of(sinkModifyOperation.getContextResolvedTable().getIdentifier());
        }
        return Optional.empty();
    }

    public String toString() {
        if (this.operation instanceof SinkModifyOperation) {
            return "TablePipeline with sink table '" + ((SinkModifyOperation)this.operation).getContextResolvedTable().getIdentifier() + "'";
        }
        return "TablePipeline with sink '" + this.operation.getClass().getSimpleName() + "'";
    }
}

