/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

@Internal
public class SerializedValue<T>
implements Serializable {
    private static final long serialVersionUID = -3564011643393683761L;
    private final byte[] serializedData;

    protected SerializedValue(byte[] serializedData) {
        Preconditions.checkNotNull(serializedData, "Serialized data must not be null");
        Preconditions.checkArgument(serializedData.length != 0, "Serialized data must not be empty");
        this.serializedData = serializedData;
    }

    public SerializedValue(T value) throws IOException {
        Preconditions.checkNotNull(value, "Value must not be null");
        this.serializedData = InstantiationUtil.serializeObject(value);
    }

    public T deserializeValue(ClassLoader loader) throws IOException, ClassNotFoundException {
        Preconditions.checkNotNull(loader, "No classloader has been passed");
        return InstantiationUtil.deserializeObject(this.serializedData, loader);
    }

    public byte[] getByteArray() {
        return this.serializedData;
    }

    public static <T> SerializedValue<T> fromBytes(byte[] serializedData) {
        return new SerializedValue<byte[]>(serializedData);
    }

    public int hashCode() {
        return Arrays.hashCode(this.serializedData);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SerializedValue) {
            SerializedValue other = (SerializedValue)obj;
            return Arrays.equals(this.serializedData, other.serializedData);
        }
        return false;
    }

    public String toString() {
        return "SerializedValue";
    }
}

