/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.compact;

import java.util.List;
import java.util.concurrent.Callable;
import org.apache.flink.table.store.file.compact.CompactResult;
import org.apache.flink.table.store.file.data.DataFileMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompactTask
implements Callable<CompactResult> {
    private static final Logger LOG = LoggerFactory.getLogger(CompactTask.class);
    private final List<DataFileMeta> inputs;

    public CompactTask(List<DataFileMeta> inputs) {
        this.inputs = inputs;
    }

    @Override
    public CompactResult call() throws Exception {
        long startMillis = System.currentTimeMillis();
        CompactResult result = this.doCompact(this.inputs);
        if (LOG.isDebugEnabled()) {
            this.logMetric(startMillis, result.before(), result.after());
        }
        return result;
    }

    protected String logMetric(long startMillis, List<DataFileMeta> compactBefore, List<DataFileMeta> compactAfter) {
        return String.format("Done compacting %d files to %d files in %dms. Rewrite input file size = %d, output file size = %d", compactBefore.size(), compactAfter.size(), System.currentTimeMillis() - startMillis, this.collectRewriteSize(compactBefore), this.collectRewriteSize(compactAfter));
    }

    protected abstract CompactResult doCompact(List<DataFileMeta> var1) throws Exception;

    private long collectRewriteSize(List<DataFileMeta> files) {
        return files.stream().mapToLong(DataFileMeta::fileSize).sum();
    }
}

