/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class FormatDescriptor {
    private final String format;
    private final Map<String, String> options;

    private FormatDescriptor(String format, Map<String, String> options) {
        this.format = format;
        this.options = Collections.unmodifiableMap(options);
    }

    public static Builder forFormat(String format) {
        Preconditions.checkNotNull(format, "Format descriptors require a format identifier.");
        return new Builder(format);
    }

    public String getFormat() {
        return this.format;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public String toString() {
        return String.format("%s[%s]", this.format, this.options);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FormatDescriptor that = (FormatDescriptor)obj;
        return this.format.equals(that.format) && this.options.equals(that.options);
    }

    public int hashCode() {
        return Objects.hash(this.format, this.options);
    }

    @PublicEvolving
    public static class Builder {
        private final String format;
        private final Map<String, String> options = new HashMap<String, String>();

        private Builder(String format) {
            this.format = format;
        }

        public <T> Builder option(ConfigOption<T> configOption, T value) {
            Preconditions.checkNotNull(configOption, "Config option must not be null.");
            Preconditions.checkNotNull(value, "Value must not be null.");
            this.options.put(configOption.key(), (String)ConfigurationUtils.convertValue(value, String.class));
            return this;
        }

        public Builder option(String key, String value) {
            Preconditions.checkNotNull(key, "Key must not be null.");
            Preconditions.checkNotNull(value, "Value must not be null.");
            this.options.put(key, value);
            return this;
        }

        public FormatDescriptor build() {
            return new FormatDescriptor(this.format, this.options);
        }
    }
}

