/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.schema;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.table.store.CoreOptions;
import org.apache.flink.table.store.file.schema.ArrayDataType;
import org.apache.flink.table.store.file.schema.AtomicDataType;
import org.apache.flink.table.store.file.schema.DataField;
import org.apache.flink.table.store.file.schema.DataType;
import org.apache.flink.table.store.file.schema.MapDataType;
import org.apache.flink.table.store.file.schema.MultisetDataType;
import org.apache.flink.table.store.file.schema.RowDataType;
import org.apache.flink.table.store.file.schema.UpdateSchema;
import org.apache.flink.table.store.file.utils.JsonSerdeUtil;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public class TableSchema
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long id;
    private final List<DataField> fields;
    private final int highestFieldId;
    private final List<String> partitionKeys;
    private final List<String> primaryKeys;
    private final Map<String, String> options;
    private final String comment;

    public TableSchema(long id, List<DataField> fields, int highestFieldId, List<String> partitionKeys, List<String> primaryKeys, Map<String, String> options, String comment) {
        this.id = id;
        this.fields = fields;
        this.highestFieldId = highestFieldId;
        this.partitionKeys = partitionKeys;
        this.primaryKeys = primaryKeys;
        this.options = Collections.unmodifiableMap(options);
        this.comment = comment;
        this.trimmedPrimaryKeys();
    }

    public long id() {
        return this.id;
    }

    public List<DataField> fields() {
        return this.fields;
    }

    public List<String> fieldNames() {
        return this.fields.stream().map(DataField::name).collect(Collectors.toList());
    }

    public int highestFieldId() {
        return this.highestFieldId;
    }

    public List<String> partitionKeys() {
        return this.partitionKeys;
    }

    public List<String> primaryKeys() {
        return this.primaryKeys;
    }

    public List<String> trimmedPrimaryKeys() {
        if (this.primaryKeys.size() > 0) {
            Preconditions.checkState(this.primaryKeys.containsAll(this.partitionKeys), String.format("Primary key constraint %s should include all partition fields %s", this.primaryKeys, this.partitionKeys));
            List<String> adjusted = this.primaryKeys.stream().filter(pk -> !this.partitionKeys.contains(pk)).collect(Collectors.toList());
            Preconditions.checkState(adjusted.size() > 0, String.format("Primary key constraint %s should not be same with partition fields %s, this will result in only one record in a partition", this.primaryKeys, this.partitionKeys));
            return adjusted;
        }
        return this.primaryKeys;
    }

    public Map<String, String> options() {
        return this.options;
    }

    public List<String> originalBucketKeys() {
        String key = this.options.get(CoreOptions.BUCKET_KEY.key());
        if (StringUtils.isNullOrWhitespaceOnly(key)) {
            return Collections.emptyList();
        }
        List<String> bucketKeys = Arrays.asList(key.split(","));
        if (!this.containsAll(this.fieldNames(), bucketKeys)) {
            throw new RuntimeException(String.format("Field names %s should contains all bucket keys %s.", this.fieldNames(), bucketKeys));
        }
        if (bucketKeys.stream().anyMatch(this.partitionKeys::contains)) {
            throw new RuntimeException(String.format("Bucket keys %s should not in partition keys %s.", bucketKeys, this.partitionKeys));
        }
        if (this.primaryKeys.size() > 0 && !this.containsAll(this.primaryKeys, bucketKeys)) {
            throw new RuntimeException(String.format("Primary keys %s should contains all bucket keys %s.", this.primaryKeys, bucketKeys));
        }
        return bucketKeys;
    }

    private boolean containsAll(List<String> all, List<String> contains) {
        return new HashSet<String>(all).containsAll(new HashSet<String>(contains));
    }

    public String comment() {
        return this.comment;
    }

    public RowType logicalRowType() {
        return (RowType)new RowDataType((boolean)false, this.fields).logicalType;
    }

    public RowType logicalPartitionType() {
        return this.projectedLogicalRowType(this.partitionKeys);
    }

    public RowType logicalBucketKeyType() {
        List<String> bucketKeys = this.originalBucketKeys();
        if (bucketKeys.isEmpty()) {
            bucketKeys = this.trimmedPrimaryKeys();
        }
        if (bucketKeys.isEmpty()) {
            bucketKeys = this.fieldNames();
        }
        return this.projectedLogicalRowType(bucketKeys);
    }

    public RowType logicalTrimmedPrimaryKeysType() {
        return this.projectedLogicalRowType(this.trimmedPrimaryKeys());
    }

    public int[] projection(List<String> projectedFieldNames) {
        List<String> fieldNames = this.fieldNames();
        return projectedFieldNames.stream().mapToInt(fieldNames::indexOf).toArray();
    }

    private RowType projectedLogicalRowType(List<String> projectedFieldNames) {
        List<String> fieldNames = this.fieldNames();
        return (RowType)new RowDataType((boolean)false, projectedFieldNames.stream().map((Function<String, DataField>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$projectedLogicalRowType$1(java.util.List java.lang.String ), (Ljava/lang/String;)Lorg/apache/flink/table/store/file/schema/DataField;)((TableSchema)this, fieldNames)).collect(Collectors.toList())).logicalType;
    }

    public TableSchema copy(Map<String, String> newOptions) {
        return new TableSchema(this.id, this.fields, this.highestFieldId, this.partitionKeys, this.primaryKeys, newOptions, this.comment);
    }

    public String toString() {
        return JsonSerdeUtil.toJson(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableSchema tableSchema = (TableSchema)o;
        return Objects.equals(this.fields, tableSchema.fields) && Objects.equals(this.partitionKeys, tableSchema.partitionKeys) && Objects.equals(this.primaryKeys, tableSchema.primaryKeys) && Objects.equals(this.options, tableSchema.options) && Objects.equals(this.comment, tableSchema.comment);
    }

    public int hashCode() {
        return Objects.hash(this.fields, this.partitionKeys, this.primaryKeys, this.options, this.comment);
    }

    public UpdateSchema toUpdateSchema() {
        return new UpdateSchema(this.logicalRowType(), this.partitionKeys, this.primaryKeys, this.options, this.comment);
    }

    public static List<DataField> newFields(RowType rowType) {
        return ((RowDataType)TableSchema.toDataType(rowType, new AtomicInteger(-1))).fields();
    }

    public static DataType toDataType(LogicalType type, AtomicInteger currentHighestFieldId) {
        if (type instanceof ArrayType) {
            DataType element = TableSchema.toDataType(((ArrayType)type).getElementType(), currentHighestFieldId);
            return new ArrayDataType(type.isNullable(), element);
        }
        if (type instanceof MultisetType) {
            DataType element = TableSchema.toDataType(((MultisetType)type).getElementType(), currentHighestFieldId);
            return new MultisetDataType(type.isNullable(), element);
        }
        if (type instanceof MapType) {
            DataType key = TableSchema.toDataType(((MapType)type).getKeyType(), currentHighestFieldId);
            DataType value = TableSchema.toDataType(((MapType)type).getValueType(), currentHighestFieldId);
            return new MapDataType(type.isNullable(), key, value);
        }
        if (type instanceof RowType) {
            ArrayList<DataField> fields = new ArrayList<DataField>();
            for (RowType.RowField field : ((RowType)type).getFields()) {
                int id = currentHighestFieldId.incrementAndGet();
                DataType fieldType = TableSchema.toDataType(field.getType(), currentHighestFieldId);
                fields.add(new DataField(id, field.getName(), fieldType, field.getDescription().orElse(null)));
            }
            return new RowDataType(type.isNullable(), fields);
        }
        return new AtomicDataType(type);
    }

    public static int currentHighestFieldId(List<DataField> fields) {
        HashSet<Integer> fieldIds = new HashSet<Integer>();
        TableSchema.collectFieldIds(new RowDataType(fields), fieldIds);
        return fieldIds.stream().max(Integer::compareTo).orElse(-1);
    }

    private static void collectFieldIds(DataType type, Set<Integer> fieldIds) {
        if (type instanceof ArrayDataType) {
            TableSchema.collectFieldIds(((ArrayDataType)type).elementType(), fieldIds);
        } else if (type instanceof MultisetDataType) {
            TableSchema.collectFieldIds(((MultisetDataType)type).elementType(), fieldIds);
        } else if (type instanceof MapDataType) {
            TableSchema.collectFieldIds(((MapDataType)type).keyType(), fieldIds);
            TableSchema.collectFieldIds(((MapDataType)type).valueType(), fieldIds);
        } else if (type instanceof RowDataType) {
            for (DataField field : ((RowDataType)type).fields()) {
                if (fieldIds.contains(field.id())) {
                    throw new RuntimeException(String.format("Broken schema, field id %s is duplicated.", field.id()));
                }
                fieldIds.add(field.id());
                TableSchema.collectFieldIds(field.type(), fieldIds);
            }
        }
    }

    private /* synthetic */ DataField lambda$projectedLogicalRowType$1(List fieldNames, String k) {
        return this.fields.get(fieldNames.indexOf(k));
    }
}

