/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.internal;

import java.io.File;
import org.apache.flink.FlinkVersion;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.CompiledPlan;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.delegation.InternalPlan;

@Internal
class CompiledPlanImpl
implements CompiledPlan {
    private final TableEnvironmentInternal tableEnvironment;
    private final InternalPlan internalPlan;

    CompiledPlanImpl(TableEnvironmentInternal tableEnvironment, InternalPlan internalPlan) {
        this.tableEnvironment = tableEnvironment;
        this.internalPlan = internalPlan;
    }

    InternalPlan unwrap() {
        return this.internalPlan;
    }

    @Override
    public String asJsonString() {
        return this.internalPlan.asJsonString();
    }

    @Override
    public void writeToFile(File file, boolean ignoreIfExists) {
        this.internalPlan.writeToFile(file, ignoreIfExists, this.tableEnvironment.getConfig().get(TableConfigOptions.PLAN_FORCE_RECOMPILE) == false);
    }

    @Override
    public FlinkVersion getFlinkVersion() {
        return this.internalPlan.getFlinkVersion();
    }

    @Override
    public TableResult execute() {
        return this.tableEnvironment.executePlan(this.internalPlan);
    }

    @Override
    public String explain(ExplainDetail ... extraDetails) {
        return this.tableEnvironment.explainPlan(this.internalPlan, extraDetails);
    }

    public String toString() {
        return this.explain(new ExplainDetail[0]);
    }
}

