/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.heartbeat;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HeartbeatManagerOptions;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.heartbeat.HeartbeatListener;
import org.apache.flink.runtime.heartbeat.HeartbeatManager;
import org.apache.flink.runtime.heartbeat.HeartbeatManagerImpl;
import org.apache.flink.runtime.heartbeat.HeartbeatManagerSenderImpl;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.slf4j.Logger;

public class HeartbeatServices {
    protected final long heartbeatInterval;
    protected final long heartbeatTimeout;
    protected final int failedRpcRequestsUntilUnreachable;

    public HeartbeatServices(long heartbeatInterval, long heartbeatTimeout) {
        this(heartbeatInterval, heartbeatTimeout, -1);
    }

    public HeartbeatServices(long heartbeatInterval, long heartbeatTimeout, int failedRpcRequestsUntilUnreachable) {
        Preconditions.checkArgument(0L < heartbeatInterval, "The heartbeat interval must be larger than 0.");
        Preconditions.checkArgument(heartbeatInterval <= heartbeatTimeout, "The heartbeat timeout should be larger or equal than the heartbeat interval.");
        Preconditions.checkArgument(failedRpcRequestsUntilUnreachable > 0 || failedRpcRequestsUntilUnreachable == -1, "The number of failed heartbeat RPC requests has to be larger than 0 or -1 (deactivated).");
        this.heartbeatInterval = heartbeatInterval;
        this.heartbeatTimeout = heartbeatTimeout;
        this.failedRpcRequestsUntilUnreachable = failedRpcRequestsUntilUnreachable;
    }

    public <I, O> HeartbeatManager<I, O> createHeartbeatManager(ResourceID resourceId, HeartbeatListener<I, O> heartbeatListener, ScheduledExecutor mainThreadExecutor, Logger log) {
        return new HeartbeatManagerImpl<I, O>(this.heartbeatTimeout, this.failedRpcRequestsUntilUnreachable, resourceId, heartbeatListener, mainThreadExecutor, log);
    }

    public <I, O> HeartbeatManager<I, O> createHeartbeatManagerSender(ResourceID resourceId, HeartbeatListener<I, O> heartbeatListener, ScheduledExecutor mainThreadExecutor, Logger log) {
        return new HeartbeatManagerSenderImpl<I, O>(this.heartbeatInterval, this.heartbeatTimeout, this.failedRpcRequestsUntilUnreachable, resourceId, heartbeatListener, mainThreadExecutor, log);
    }

    public static HeartbeatServices fromConfiguration(Configuration configuration) {
        long heartbeatInterval = configuration.getLong(HeartbeatManagerOptions.HEARTBEAT_INTERVAL);
        long heartbeatTimeout = configuration.getLong(HeartbeatManagerOptions.HEARTBEAT_TIMEOUT);
        int failedRpcRequestsUntilUnreachable = configuration.get(HeartbeatManagerOptions.HEARTBEAT_RPC_FAILURE_THRESHOLD);
        return new HeartbeatServices(heartbeatInterval, heartbeatTimeout, failedRpcRequestsUntilUnreachable);
    }
}

