/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.data;

import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.store.file.data.DataFileMeta;
import org.apache.flink.table.store.file.stats.BinaryTableStats;
import org.apache.flink.table.store.file.utils.ObjectSerializer;
import org.apache.flink.table.store.file.utils.SerializationUtils;
import org.apache.flink.table.store.utils.RowDataUtils;

public class DataFileMetaSerializer
extends ObjectSerializer<DataFileMeta> {
    private static final long serialVersionUID = 1L;

    public DataFileMetaSerializer() {
        super(DataFileMeta.schema());
    }

    @Override
    public RowData toRow(DataFileMeta meta) {
        return GenericRowData.of((Object[])new Object[]{StringData.fromString((String)meta.fileName()), meta.fileSize(), meta.rowCount(), SerializationUtils.serializeBinaryRow(meta.minKey()), SerializationUtils.serializeBinaryRow(meta.maxKey()), meta.keyStats().toRowData(), meta.valueStats().toRowData(), meta.minSequenceNumber(), meta.maxSequenceNumber(), meta.schemaId(), meta.level(), RowDataUtils.toStringArrayData(meta.extraFiles())});
    }

    @Override
    public DataFileMeta fromRow(RowData row) {
        return new DataFileMeta(row.getString(0).toString(), row.getLong(1), row.getLong(2), SerializationUtils.deserializeBinaryRow(row.getBinary(3)), SerializationUtils.deserializeBinaryRow(row.getBinary(4)), BinaryTableStats.fromRowData(row.getRow(5, 3)), BinaryTableStats.fromRowData(row.getRow(6, 3)), row.getLong(7), row.getLong(8), row.getLong(9), row.getInt(10), RowDataUtils.fromStringArrayData(row.getArray(11)));
    }
}

