/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.listener;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.listener.CatalogContext;
import org.apache.flink.table.catalog.listener.TableModificationEvent;

@PublicEvolving
public interface AlterTableEvent
extends TableModificationEvent {
    public CatalogBaseTable newTable();

    public boolean ignoreIfNotExists();

    public static AlterTableEvent createEvent(final CatalogContext context, final ObjectIdentifier identifier, final CatalogBaseTable newTable, final boolean ignoreIfNotExists) {
        return new AlterTableEvent(){

            @Override
            public CatalogBaseTable newTable() {
                return newTable;
            }

            @Override
            public boolean ignoreIfNotExists() {
                return ignoreIfNotExists;
            }

            @Override
            public ObjectIdentifier identifier() {
                return identifier;
            }

            @Override
            public CatalogBaseTable table() {
                throw new IllegalStateException("There is no table in AlterTableEvent, use identifier() instead.");
            }

            @Override
            public boolean isTemporary() {
                return false;
            }

            @Override
            public CatalogContext context() {
                return context;
            }
        };
    }
}

