/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.handler.session;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.table.gateway.api.SqlGatewayService;
import org.apache.flink.table.gateway.api.session.SessionHandle;
import org.apache.flink.table.gateway.api.utils.SqlGatewayException;
import org.apache.flink.table.gateway.rest.handler.AbstractSqlGatewayRestHandler;
import org.apache.flink.table.gateway.rest.message.session.GetSessionConfigResponseBody;
import org.apache.flink.table.gateway.rest.message.session.SessionHandleIdPathParameter;
import org.apache.flink.table.gateway.rest.message.session.SessionMessageParameters;
import org.apache.flink.table.gateway.rest.util.SqlGatewayRestAPIVersion;

public class GetSessionConfigHandler
extends AbstractSqlGatewayRestHandler<EmptyRequestBody, GetSessionConfigResponseBody, SessionMessageParameters> {
    public GetSessionConfigHandler(SqlGatewayService service, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, GetSessionConfigResponseBody, SessionMessageParameters> messageHeaders) {
        super(service, responseHeaders, messageHeaders);
    }

    @Override
    protected CompletableFuture<GetSessionConfigResponseBody> handleRequest(SqlGatewayRestAPIVersion version, @Nonnull HandlerRequest<EmptyRequestBody> request) throws RestHandlerException {
        try {
            SessionHandle sessionHandle = (SessionHandle)request.getPathParameter(SessionHandleIdPathParameter.class);
            Map<String, String> sessionConfig = this.service.getSessionConfig(sessionHandle);
            return CompletableFuture.completedFuture(new GetSessionConfigResponseBody(sessionConfig));
        }
        catch (SqlGatewayException e) {
            throw new RestHandlerException(e.getMessage(), HttpResponseStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }
}

