/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.Consumer;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.util.RecordAndPosition;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.function.SupplierWithException;
import org.apache.flink.util.function.ThrowingRunnable;

@PublicEvolving
public final class Utils {
    public static <E> E doWithCleanupOnException(Closeable toCleanUp, SupplierWithException<E, IOException> code) throws IOException {
        try {
            return (E)code.get();
        }
        catch (Throwable t) {
            IOUtils.closeQuietly((AutoCloseable)toCleanUp);
            ExceptionUtils.rethrowIOException((Throwable)t);
            return null;
        }
    }

    public static void doWithCleanupOnException(Closeable toCleanUp, ThrowingRunnable<IOException> code) throws IOException {
        Utils.doWithCleanupOnException(toCleanUp, () -> {
            code.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void forEachRemaining(BulkFormat.Reader<T> reader, Consumer<? super T> action) throws IOException {
        try {
            BulkFormat.RecordIterator<T> batch;
            while ((batch = reader.readBatch()) != null) {
                RecordAndPosition<T> record;
                while ((record = batch.next()) != null) {
                    action.accept(record.getRecord());
                }
                batch.releaseBatch();
            }
        }
        finally {
            reader.close();
        }
    }

    private Utils() {
    }
}

