/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.writer;

import com.aliyun.oss.model.PartETag;
import java.io.IOException;
import java.util.List;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.fs.osshadoop.OSSAccessor;
import org.apache.flink.fs.osshadoop.writer.OSSRecoverable;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSSCommitter
implements RecoverableFsDataOutputStream.Committer {
    private static final Logger LOG = LoggerFactory.getLogger(OSSCommitter.class);
    private OSSAccessor ossAccessor;
    private String objectName;
    private String uploadId;
    private List<PartETag> partETags;
    private long totalLength;

    public OSSCommitter(OSSAccessor ossAccessor, String objectName, String uploadId, List<PartETag> partETags, long totalLength) {
        this.ossAccessor = (OSSAccessor)Preconditions.checkNotNull((Object)ossAccessor);
        this.objectName = (String)Preconditions.checkNotNull((Object)objectName);
        this.uploadId = (String)Preconditions.checkNotNull((Object)uploadId);
        this.partETags = (List)Preconditions.checkNotNull(partETags);
        this.totalLength = totalLength;
    }

    public void commit() throws IOException {
        if (this.totalLength > 0L) {
            LOG.info("Committing {} with multi-part upload ID {}", (Object)this.objectName, (Object)this.uploadId);
            this.ossAccessor.completeMultipartUpload(this.objectName, this.uploadId, this.partETags);
        } else {
            LOG.debug("No data to commit for file: {}", (Object)this.objectName);
        }
    }

    public void commitAfterRecovery() throws IOException {
        if (this.totalLength > 0L) {
            try {
                LOG.info("Trying to commit after recovery {} with multi-part upload ID {}", (Object)this.objectName, (Object)this.uploadId);
                this.ossAccessor.completeMultipartUpload(this.objectName, this.uploadId, this.partETags);
            }
            catch (Exception e) {
                LOG.info("Failed to commit after recovery {} with multi-part upload ID {}. exception {}", new Object[]{this.objectName, this.uploadId, e});
            }
        } else {
            LOG.debug("No data to commit for file: {}", (Object)this.objectName);
        }
    }

    public RecoverableWriter.CommitRecoverable getRecoverable() {
        return new OSSRecoverable(this.uploadId, this.objectName, this.partETags, null, this.totalLength, 0L);
    }
}

