/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.optimize;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.planner.calcite.CalciteConfig;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.RexFactory;
import org.apache.flink.table.planner.delegation.StreamPlanner;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.nodes.calcite.LegacySink;
import org.apache.flink.table.planner.plan.nodes.calcite.Sink;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalDataStreamScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalIntermediateTableScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalLegacyTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalRel;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalTableSourceScan;
import org.apache.flink.table.planner.plan.optimize.CommonSubGraphBasedOptimizer;
import org.apache.flink.table.planner.plan.optimize.RelNodeBlock;
import org.apache.flink.table.planner.plan.optimize.RelNodeBlockPlanBuilder$;
import org.apache.flink.table.planner.plan.optimize.StreamNonDeterministicPhysicalPlanResolver;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkStreamProgram$;
import org.apache.flink.table.planner.plan.optimize.program.StreamOptimizeContext;
import org.apache.flink.table.planner.plan.schema.IntermediateRelTable;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.plan.trait.MiniBatchInterval;
import org.apache.flink.table.planner.plan.trait.MiniBatchIntervalTrait;
import org.apache.flink.table.planner.plan.trait.MiniBatchIntervalTrait$;
import org.apache.flink.table.planner.plan.trait.MiniBatchIntervalTraitDef$;
import org.apache.flink.table.planner.plan.trait.MiniBatchMode;
import org.apache.flink.table.planner.plan.trait.ModifyKindSet;
import org.apache.flink.table.planner.plan.trait.ModifyKindSetTrait;
import org.apache.flink.table.planner.plan.trait.ModifyKindSetTraitDef$;
import org.apache.flink.table.planner.plan.trait.RelModifiedMonotonicity;
import org.apache.flink.table.planner.plan.trait.RelWindowProperties;
import org.apache.flink.table.planner.plan.trait.UpdateKind;
import org.apache.flink.table.planner.plan.trait.UpdateKindTrait;
import org.apache.flink.table.planner.plan.trait.UpdateKindTraitDef$;
import org.apache.flink.table.planner.plan.utils.FlinkRexUtil$;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.util.Preconditions;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001B\u0001\u0003\u0001E\u0011!e\u0015;sK\u0006l7i\\7n_:\u001cVOY$sCBD')Y:fI>\u0003H/[7ju\u0016\u0014(BA\u0002\u0005\u0003!y\u0007\u000f^5nSj,'BA\u0003\u0007\u0003\u0011\u0001H.\u00198\u000b\u0005\u001dA\u0011a\u00029mC:tWM\u001d\u0006\u0003\u0013)\tQ\u0001^1cY\u0016T!a\u0003\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\ta2i\\7n_:\u001cVOY$sCBD')Y:fI>\u0003H/[7ju\u0016\u0014\b\u0002C\u0004\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0011\u0005aYR\"A\r\u000b\u0005i1\u0011A\u00033fY\u0016<\u0017\r^5p]&\u0011A$\u0007\u0002\u000e'R\u0014X-Y7QY\u0006tg.\u001a:\t\u000by\u0001A\u0011A\u0010\u0002\rqJg.\u001b;?)\t\u0001\u0013\u0005\u0005\u0002\u0014\u0001!)q!\ba\u0001/!)1\u0005\u0001C\u0005I\u0005\u0011r\u000e\u001d;j[&TXmU5oW\ncwnY6t)\r)cG\u0010\t\u0004MA\u001adBA\u0014.\u001d\tA3&D\u0001*\u0015\tQ\u0003#\u0001\u0004=e>|GOP\u0005\u0002Y\u0005)1oY1mC&\u0011afL\u0001\ba\u0006\u001c7.Y4f\u0015\u0005a\u0013BA\u00193\u0005\r\u0019V-\u001d\u0006\u0003]=\u0002\"a\u0005\u001b\n\u0005U\u0012!\u0001\u0004*fY:{G-\u001a\"m_\u000e\\\u0007\"B\u001c#\u0001\u0004A\u0014a\u0003;bE2,7i\u001c8gS\u001e\u0004\"!\u000f\u001f\u000e\u0003iR!a\u000f\u0005\u0002\u0007\u0005\u0004\u0018.\u0003\u0002>u\tYA+\u00192mK\u000e{gNZ5h\u0011\u0015y$\u00051\u0001&\u0003)\u0019\u0018N\\6CY>\u001c7n\u001d\u0005\u0006\u0003\u0002!\tFQ\u0001\u000bI>|\u0005\u000f^5nSj,GCA\u0013D\u0011\u0015!\u0005\t1\u0001F\u0003\u0015\u0011xn\u001c;t!\r1\u0003G\u0012\t\u0003\u000f2k\u0011\u0001\u0013\u0006\u0003\u0013*\u000b1A]3m\u0015\tYE\"A\u0004dC2\u001c\u0017\u000e^3\n\u00055C%a\u0002*fY:{G-\u001a\u0005\u0006\u001f\u0002!I\u0001U\u0001\u000e_B$\u0018.\\5{K\ncwnY6\u0015\u0007E+v\u000b\u0005\u0002S'6\tq&\u0003\u0002U_\t!QK\\5u\u0011\u00151f\n1\u00014\u0003\u0015\u0011Gn\\2l\u0011\u0015Af\n1\u0001Z\u0003-I7oU5oW\ncwnY6\u0011\u0005IS\u0016BA.0\u0005\u001d\u0011un\u001c7fC:DQ!\u0018\u0001\u0005\ny\u000bAb\u001c9uS6L'0\u001a+sK\u0016$RAR0bG.DQ\u0001\u0019/A\u0002\u0019\u000bqA]3m\u001d>$W\rC\u0003c9\u0002\u0007\u0011,\u0001\u000bva\u0012\fG/\u001a\"fM>\u0014XMU3rk&\u0014X\r\u001a\u0005\u0006Ir\u0003\r!Z\u0001\u0012[&t\u0017NQ1uG\"Le\u000e^3sm\u0006d\u0007C\u00014j\u001b\u00059'B\u00015\u0005\u0003\u0015!(/Y5u\u0013\tQwMA\tNS:L')\u0019;dQ&sG/\u001a:wC2DQ\u0001\u0017/A\u0002eCQ!\u001c\u0001\u0005\n9\fq\u0005\u001d:pa\u0006<\u0017\r^3Va\u0012\fG/Z&j]\u0012\fe\u000eZ'j]&\u0014\u0015\r^2i\u0013:$XM\u001d<bYR)\u0011k\u001c9re\")a\u000b\u001ca\u0001g!)!\r\u001ca\u00013\")A\r\u001ca\u0001K\")\u0001\f\u001ca\u00013\")A\u000f\u0001C\u0005k\u00069\"/Z:fi&sG/\u001a:nK\u0012L\u0017\r^3SKN,H\u000e\u001e\u000b\u0003#ZDQAV:A\u0002MBQ\u0001\u001f\u0001\u0005\ne\f!d\u0019:fCR,\u0017J\u001c;fe6,G-[1uKJ+G\u000eV1cY\u0016$\u0012B_A\u0001\u0003+\t9\"!\t\u0011\u0005mtX\"\u0001?\u000b\u0005u$\u0011AB:dQ\u0016l\u0017-\u0003\u0002\u0000y\n!\u0012J\u001c;fe6,G-[1uKJ+G\u000eV1cY\u0016Dq!a\u0001x\u0001\u0004\t)!\u0001\u0003oC6,\u0007\u0003BA\u0004\u0003\u001fqA!!\u0003\u0002\fA\u0011\u0001fL\u0005\u0004\u0003\u001by\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0012\u0005M!AB*ue&twMC\u0002\u0002\u000e=BQ\u0001Y<A\u0002\u0019Cq!!\u0007x\u0001\u0004\tY\"A\u0007n_\u0012Lg-_&j]\u0012\u001cV\r\u001e\t\u0004M\u0006u\u0011bAA\u0010O\niQj\u001c3jMf\\\u0015N\u001c3TKRDa!a\tx\u0001\u0004I\u0016AF5t+B$\u0017\r^3CK\u001a|'/\u001a*fcVL'/\u001a3\t\u000f\u0005\u001d\u0002\u0001\"\u0003\u0002*\u0005iq-\u001a;V]&\fX/Z&fsN$B!a\u000b\u0002PA\"\u0011QFA!!\u0019\ty#!\u000f\u0002>5\u0011\u0011\u0011\u0007\u0006\u0005\u0003g\t)$\u0001\u0003vi&d'BAA\u001c\u0003\u0011Q\u0017M^1\n\t\u0005m\u0012\u0011\u0007\u0002\u0004'\u0016$\b\u0003BA \u0003\u0003b\u0001\u0001\u0002\u0007\u0002D\u0005\u0015\u0012\u0011!A\u0001\u0006\u0003\t)EA\u0002`IE\nB!a\u0012\u0002NA\u0019!+!\u0013\n\u0007\u0005-sFA\u0004O_RD\u0017N\\4\u0011\r\u0005=\u0012\u0011HA\u0003\u0011\u0019\u0001\u0017Q\u0005a\u0001\r\"9\u00111\u000b\u0001\u0005R\u0005U\u0013\u0001\u00049pgR|\u0005\u000f^5nSj,GcA#\u0002X!9\u0011\u0011LA)\u0001\u0004)\u0015\u0001C3ya\u0006tG-\u001a3")
public class StreamCommonSubGraphBasedOptimizer
extends CommonSubGraphBasedOptimizer {
    public final StreamPlanner org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner;

    private Seq<RelNodeBlock> optimizeSinkBlocks(TableConfig tableConfig, Seq<RelNodeBlock> sinkBlocks) {
        sinkBlocks.foreach((Function1 & Serializable & scala.Serializable)sinkBlock -> {
            StreamCommonSubGraphBasedOptimizer.$anonfun$optimizeSinkBlocks$1(tableConfig, sinkBlock);
            return BoxedUnit.UNIT;
        });
        if (sinkBlocks.size() == 1) {
            RelNodeBlock block2 = (RelNodeBlock)sinkBlocks.head();
            RelNode optimizedTree = this.optimizeTree(block2.getPlan(), block2.isUpdateBeforeRequired(), block2.getMiniBatchInterval(), true);
            block2.setOptimizedPlan(optimizedTree);
            return sinkBlocks;
        }
        sinkBlocks.foreach((Function1 & Serializable & scala.Serializable)b -> {
            this.optimizeBlock(b, true);
            return BoxedUnit.UNIT;
        });
        sinkBlocks.foreach((Function1 & Serializable & scala.Serializable)b -> {
            this.propagateUpdateKindAndMiniBatchInterval(b, b.isUpdateBeforeRequired(), b.getMiniBatchInterval(), true);
            return BoxedUnit.UNIT;
        });
        sinkBlocks.foreach((Function1 & Serializable & scala.Serializable)block -> {
            this.resetIntermediateResult(block);
            return BoxedUnit.UNIT;
        });
        sinkBlocks.foreach((Function1 & Serializable & scala.Serializable)b -> {
            this.optimizeBlock(b, true);
            return BoxedUnit.UNIT;
        });
        return sinkBlocks;
    }

    @Override
    public Seq<RelNodeBlock> doOptimize(Seq<RelNode> roots) {
        Seq<RelNodeBlock> seq;
        TableConfig tableConfig = this.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.getTableConfig();
        Seq<RelNodeBlock> sinkBlocks = RelNodeBlockPlanBuilder$.MODULE$.buildRelNodeBlockPlan(roots, (ReadableConfig)tableConfig);
        Boolean origMiniBatchEnabled = (Boolean)tableConfig.get(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED);
        try {
            Object object = Predef$.MODULE$.Boolean2boolean(origMiniBatchEnabled) ? tableConfig.set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((!FlinkRexUtil$.MODULE$.shouldSkipMiniBatch(sinkBlocks) ? 1 : 0) != 0)) : BoxedUnit.UNIT;
            seq = this.optimizeSinkBlocks(tableConfig, sinkBlocks);
        }
        finally {
            tableConfig.getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)origMiniBatchEnabled);
        }
        return seq;
    }

    private void optimizeBlock(RelNodeBlock block, boolean isSinkBlock) {
        RelNode blockLogicalPlan;
        block.children().foreach((Function1 & Serializable & scala.Serializable)child -> {
            StreamCommonSubGraphBasedOptimizer.$anonfun$optimizeBlock$1(this, child);
            return BoxedUnit.UNIT;
        });
        RelNode relNode = blockLogicalPlan = block.getPlan();
        boolean bl = relNode instanceof LegacySink ? true : relNode instanceof Sink;
        if (bl) {
            Predef$.MODULE$.require(isSinkBlock);
            RelNode optimizedTree = this.optimizeTree(blockLogicalPlan, block.isUpdateBeforeRequired(), block.getMiniBatchInterval(), true);
            block.setOptimizedPlan(optimizedTree);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            RelNode optimizedPlan = this.optimizeTree(relNode, block.isUpdateBeforeRequired(), block.getMiniBatchInterval(), isSinkBlock);
            ModifyKindSetTrait modifyKindSetTrait = optimizedPlan.getTraitSet().getTrait(ModifyKindSetTraitDef$.MODULE$.INSTANCE());
            String name = this.createUniqueIntermediateRelTableName();
            IntermediateRelTable intermediateRelTable = this.createIntermediateRelTable(name, optimizedPlan, modifyKindSetTrait.modifyKindSet(), block.isUpdateBeforeRequired());
            TableScan newTableScan = this.wrapIntermediateRelTableToTableScan(intermediateRelTable, name);
            block.setNewOutputNode(newTableScan);
            block.setOutputTableName(name);
            block.setOptimizedPlan(optimizedPlan);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private RelNode optimizeTree(RelNode relNode, boolean updateBeforeRequired, MiniBatchInterval miniBatchInterval, boolean isSinkBlock) {
        TableConfig tableConfig = this.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.getTableConfig();
        CalciteConfig calciteConfig = TableConfigUtils.getCalciteConfig(tableConfig);
        FlinkChainedProgram programs = (FlinkChainedProgram)calciteConfig.getStreamProgram().getOrElse((Function0 & Serializable & scala.Serializable)() -> FlinkStreamProgram$.MODULE$.buildProgram((ReadableConfig)tableConfig));
        Preconditions.checkNotNull((Object)programs);
        FlinkContext context = ShortcutUtils.unwrapContext(relNode);
        return programs.optimize(relNode, new StreamOptimizeContext(this, updateBeforeRequired, miniBatchInterval, isSinkBlock, tableConfig, context){
            private final /* synthetic */ StreamCommonSubGraphBasedOptimizer $outer;
            private final boolean updateBeforeRequired$1;
            private final MiniBatchInterval miniBatchInterval$1;
            private final boolean isSinkBlock$1;
            private final TableConfig tableConfig$2;
            private final FlinkContext context$1;

            public <C> C unwrap(Class<C> clazz) {
                return (C)FlinkContext.unwrap$(this, clazz);
            }

            public boolean isBatchMode() {
                return false;
            }

            public TableConfig getTableConfig() {
                return this.tableConfig$2;
            }

            public FunctionCatalog getFunctionCatalog() {
                return this.$outer.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.functionCatalog();
            }

            public CatalogManager getCatalogManager() {
                return this.$outer.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.catalogManager();
            }

            public ModuleManager getModuleManager() {
                return this.$outer.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.moduleManager();
            }

            public RexFactory getRexFactory() {
                return this.context$1.getRexFactory();
            }

            public FlinkRelBuilder getFlinkRelBuilder() {
                return this.$outer.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.createRelBuilder();
            }

            public boolean isUpdateBeforeRequired() {
                return this.updateBeforeRequired$1;
            }

            public MiniBatchInterval getMiniBatchInterval() {
                return this.miniBatchInterval$1;
            }

            public boolean needFinalTimeIndicatorConversion() {
                return this.isSinkBlock$1;
            }

            public ClassLoader getClassLoader() {
                return this.context$1.getClassLoader();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.updateBeforeRequired$1 = updateBeforeRequired$1;
                this.miniBatchInterval$1 = miniBatchInterval$1;
                this.isSinkBlock$1 = isSinkBlock$1;
                this.tableConfig$2 = tableConfig$2;
                this.context$1 = context$1;
                FlinkContext.$init$(this);
            }
        });
    }

    private void propagateUpdateKindAndMiniBatchInterval(RelNodeBlock block, boolean updateBeforeRequired, MiniBatchInterval miniBatchInterval, boolean isSinkBlock) {
        RelNode blockLogicalPlan = block.getPlan();
        RelNode optimizedPlan = this.optimizeTree(blockLogicalPlan, updateBeforeRequired, miniBatchInterval, isSinkBlock);
        StreamCommonSubGraphBasedOptimizer.propagateTraits$1(optimizedPlan, block);
        block.children().foreach((Function1 & Serializable & scala.Serializable)child -> {
            this.propagateUpdateKindAndMiniBatchInterval(child, child.isUpdateBeforeRequired(), child.getMiniBatchInterval(), false);
            return BoxedUnit.UNIT;
        });
    }

    private void resetIntermediateResult(RelNodeBlock block) {
        block.setNewOutputNode(null);
        block.setOutputTableName(null);
        block.setOptimizedPlan(null);
        block.children().foreach((Function1 & Serializable & scala.Serializable)child -> {
            StreamCommonSubGraphBasedOptimizer.$anonfun$resetIntermediateResult$1(this, child);
            return BoxedUnit.UNIT;
        });
    }

    private IntermediateRelTable createIntermediateRelTable(String name, RelNode relNode, ModifyKindSet modifyKindSet, boolean isUpdateBeforeRequired) {
        Set<? extends Set<String>> uniqueKeys = this.getUniqueKeys(relNode);
        FlinkRelMetadataQuery fmq = FlinkRelMetadataQuery.reuseOrCreate(this.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.createRelBuilder().getCluster().getMetadataQuery());
        RelModifiedMonotonicity monotonicity = fmq.getRelModifiedMonotonicity(relNode);
        RelWindowProperties windowProperties = fmq.getRelWindowProperties(relNode);
        FlinkStatistic statistic = FlinkStatistic$.MODULE$.builder().uniqueKeys(uniqueKeys).relModifiedMonotonicity(monotonicity).relWindowProperties(windowProperties).build();
        return new IntermediateRelTable(Collections.singletonList(name), relNode, modifyKindSet, isUpdateBeforeRequired, fmq.getUpsertKeys(relNode), statistic);
    }

    private Set<? extends Set<String>> getUniqueKeys(RelNode relNode) {
        RelDataType rowType = relNode.getRowType();
        FlinkRelMetadataQuery fmq = FlinkRelMetadataQuery.reuseOrCreate(this.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.createRelBuilder().getCluster().getMetadataQuery());
        Set<ImmutableBitSet> uniqueKeys = fmq.getUniqueKeys(relNode);
        return uniqueKeys != null ? JavaConversions$.MODULE$.deprecated$u0020mutableSetAsJavaSet((scala.collection.mutable.Set)((SetLike)JavaConversions$.MODULE$.deprecated$u0020asScalaSet(uniqueKeys).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StreamCommonSubGraphBasedOptimizer.$anonfun$getUniqueKeys$1(x$1)))).map((Function1 & Serializable & scala.Serializable)uniqueKey -> {
            void var2_2;
            HashSet keys = new HashSet();
            JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(uniqueKey.asList()).foreach((Function1 & Serializable & scala.Serializable)idx -> BoxesRunTime.boxToBoolean((boolean)keys.add(rowType.getFieldNames().get(Predef$.MODULE$.Integer2int(idx)))));
            return var2_2;
        }, Set$.MODULE$.canBuildFrom())) : null;
    }

    @Override
    public Seq<RelNode> postOptimize(Seq<RelNode> expanded) {
        return JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(StreamNonDeterministicPhysicalPlanResolver.resolvePhysicalPlan(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(expanded), this.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.getTableConfig()));
    }

    public static final /* synthetic */ void $anonfun$optimizeSinkBlocks$1(TableConfig tableConfig$1, RelNodeBlock sinkBlock) {
        MiniBatchInterval miniBatchInterval;
        sinkBlock.setUpdateBeforeRequired(false);
        if (Predef$.MODULE$.Boolean2boolean((Boolean)tableConfig$1.get(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED))) {
            long miniBatchLatency = ((Duration)tableConfig$1.get(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY)).toMillis();
            Preconditions.checkArgument((miniBatchLatency > 0L ? 1 : 0) != 0, (String)"MiniBatch Latency must be greater than 0 ms.", (Object[])new Object[]{null});
            miniBatchInterval = new MiniBatchInterval(miniBatchLatency, MiniBatchMode.ProcTime);
        } else {
            miniBatchInterval = MiniBatchIntervalTrait$.MODULE$.NONE().getMiniBatchInterval();
        }
        MiniBatchInterval miniBatchInterval2 = miniBatchInterval;
        sinkBlock.setMiniBatchInterval(miniBatchInterval2);
    }

    public static final /* synthetic */ void $anonfun$optimizeBlock$1(StreamCommonSubGraphBasedOptimizer $this, RelNodeBlock child) {
        block0: {
            if (!child.getNewOutputNode().isEmpty()) break block0;
            $this.optimizeBlock(child, false);
        }
    }

    private static final void propagateTraits$1(RelNode rel, RelNodeBlock block$1) {
        RelNode relNode = rel;
        boolean bl = relNode instanceof StreamPhysicalDataStreamScan ? true : (relNode instanceof StreamPhysicalIntermediateTableScan ? true : (relNode instanceof StreamPhysicalLegacyTableSourceScan ? true : relNode instanceof StreamPhysicalTableSourceScan));
        if (bl) {
            BoxedUnit boxedUnit;
            TableScan scan = (TableScan)rel;
            UpdateKindTrait updateKindTrait = scan.getTraitSet().getTrait(UpdateKindTraitDef$.MODULE$.INSTANCE());
            MiniBatchIntervalTrait miniBatchIntervalTrait = scan.getTraitSet().getTrait(MiniBatchIntervalTraitDef$.MODULE$.INSTANCE());
            String tableName = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(scan.getTable().getQualifiedName()).mkString(".");
            Seq inputBlocks = (Seq)block$1.children().filter((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)tableName.equals(b.getOutputTableName())));
            Preconditions.checkArgument((inputBlocks.size() <= 1 ? 1 : 0) != 0);
            if (inputBlocks.size() == 1) {
                RelNodeBlock childBlock = (RelNodeBlock)inputBlocks.head();
                childBlock.setMiniBatchInterval(miniBatchIntervalTrait.getMiniBatchInterval());
                UpdateKind updateKind = updateKindTrait.updateKind();
                UpdateKind updateKind2 = UpdateKind.BEFORE_AND_AFTER;
                boolean requireUB = !(updateKind != null ? !((Object)((Object)updateKind)).equals((Object)updateKind2) : updateKind2 != null);
                childBlock.setUpdateBeforeRequired(requireUB || childBlock.isUpdateBeforeRequired());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (relNode instanceof StreamPhysicalRel) {
            StreamPhysicalRel streamPhysicalRel = (StreamPhysicalRel)relNode;
            JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(streamPhysicalRel.getInputs()).foreach((Function1 & Serializable & scala.Serializable)e -> {
                StreamCommonSubGraphBasedOptimizer.propagateTraits$1(e, block$1);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$resetIntermediateResult$1(StreamCommonSubGraphBasedOptimizer $this, RelNodeBlock child) {
        block0: {
            if (!child.getNewOutputNode().nonEmpty()) break block0;
            $this.resetIntermediateResult(child);
        }
    }

    public static final /* synthetic */ boolean $anonfun$getUniqueKeys$1(ImmutableBitSet x$1) {
        return JavaConversions$.MODULE$.deprecated$u0020iterableAsScalaIterable((Iterable)x$1).nonEmpty();
    }

    public StreamCommonSubGraphBasedOptimizer(StreamPlanner planner) {
        this.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner = planner;
    }
}

