/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.fs.impl.StoreImplementationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncableDataOutputStream
extends DataOutputStream
implements Syncable,
StreamCapabilities {
    private static final Logger LOG = LoggerFactory.getLogger(SyncableDataOutputStream.class);

    public SyncableDataOutputStream(OutputStream out) {
        super(out);
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS"})
    public OutputStream getOutStream() {
        return this.out;
    }

    @Override
    public boolean hasCapability(String capability) {
        return StoreImplementationUtils.hasCapability(this.out, capability);
    }

    @Override
    public void hflush() throws IOException {
        if (this.out instanceof Syncable) {
            ((Syncable)((Object)this.out)).hflush();
        }
    }

    @Override
    public void hsync() throws IOException {
        if (this.out instanceof Syncable) {
            ((Syncable)((Object)this.out)).hsync();
        }
    }

    @Override
    public void close() throws IOException {
        IOException ioeFromFlush = null;
        try {
            this.flush();
        }
        catch (IOException e) {
            ioeFromFlush = e;
            throw e;
        }
        finally {
            try {
                this.out.close();
            }
            catch (IOException e) {
                if (ioeFromFlush == e) {
                    LOG.debug("flush() and close() throwing back same Exception. Just swallowing the latter", (Throwable)e);
                }
                throw e;
            }
        }
    }
}

