/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.utils;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CommandLineRunner;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DependencyOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.FlexJSDiagnosticGroups;
import com.google.javascript.jscomp.ModuleIdentifier;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.WarningLevel;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;

public class JSClosureCompilerWrapper {
    private Compiler compiler_;
    private CompilerOptions options_;
    private List<SourceFile> jsExternsFiles_;
    private List<SourceFile> jsSourceFiles_;
    public String targetFilePath;

    public JSClosureCompilerWrapper(List<String> args) {
        Compiler.setLoggingLevel((Level)Level.INFO);
        this.compiler_ = new Compiler();
        ArrayList<String> splitArgs = new ArrayList<String>();
        for (String s : args) {
            if (s.contains(" ")) {
                String[] parts = s.split(" ");
                Collections.addAll(splitArgs, parts);
                continue;
            }
            splitArgs.add(s);
        }
        String[] stringArgs = new String[splitArgs.size()];
        splitArgs.toArray(stringArgs);
        this.options_ = new CompilerOptionsParser(stringArgs).getOptions();
        this.jsSourceFiles_ = new ArrayList<SourceFile>();
        this.jsExternsFiles_ = new ArrayList<SourceFile>();
        this.initOptions(args);
        this.initExterns();
    }

    public void addJSExternsFile(String fileName) {
        this.addJSExternsFile(SourceFile.fromFile((String)fileName));
    }

    public void addJSExternsFile(SourceFile file) {
        this.jsExternsFiles_.add(file);
    }

    public void addJSSourceFile(String fileName) {
        this.addJSSourceFile(SourceFile.fromFile((String)fileName));
    }

    public void addJSSourceFile(SourceFile file) {
        this.jsSourceFiles_.add(file);
    }

    public void compile() {
        System.out.println("list of source files");
        for (SourceFile file : this.jsSourceFiles_) {
            System.out.println(file.getName());
        }
        System.out.println("end of list of source files");
        this.compiler_.compile(this.jsExternsFiles_, this.jsSourceFiles_, this.options_);
        try {
            FileWriter targetFile = new FileWriter(this.targetFilePath);
            targetFile.write(this.compiler_.toSource());
            targetFile.close();
            FileWriter sourceMapFile = new FileWriter(this.options_.sourceMapOutputPath);
            this.compiler_.getSourceMap().appendTo((Appendable)sourceMapFile, "");
            sourceMapFile.close();
        }
        catch (IOException error) {
            System.out.println(error);
        }
    }

    private void initExterns() {
        try {
            List defaultExterns = CommandLineRunner.getDefaultExterns();
            for (SourceFile defaultExtern : defaultExterns) {
                this.addJSExternsFile(defaultExtern);
            }
        }
        catch (IOException error) {
            System.out.println(error);
        }
    }

    private void initOptions(List<String> args) {
        String JS_FLAG = "--js ";
        boolean hasCompilationLevel = false;
        boolean hasWarningLevel = false;
        for (String s : args) {
            if (s.startsWith("--js ")) {
                this.addJSSourceFile(s.substring("--js ".length()));
            }
            if (s.startsWith("--compilation_level ") || s.startsWith("-O ")) {
                hasCompilationLevel = true;
            }
            if (!s.startsWith("--warning_level ") && !s.startsWith("-W ")) continue;
            hasWarningLevel = true;
        }
        if (!hasCompilationLevel) {
            CompilationLevel.ADVANCED_OPTIMIZATIONS.setOptionsForCompilationLevel(this.options_);
        }
        if (!hasWarningLevel) {
            WarningLevel.VERBOSE.setOptionsForWarningLevel(this.options_);
        }
        String[] asdocTags = new String[]{"productversion", "playerversion", "langversion", "copy", "asparam", "asreturn", "asprivate", "flexjsignoreimport", "flexjsignorecoercion", "flexjsnoimplicitstringconversion"};
        this.options_.setExtraAnnotationNames(Arrays.asList(asdocTags));
    }

    public void setOptions(String sourceMapPath, boolean useStrictPublishing, boolean manageDependencies, String projectName) {
        if (useStrictPublishing) {
            this.options_.setDefineToBooleanLiteral("goog.DEBUG", false);
            this.options_.setLanguageIn(CompilerOptions.LanguageMode.ECMASCRIPT5_STRICT);
            this.options_.setPreferSingleQuotes(true);
            this.options_.setFoldConstants(true);
            this.options_.setDeadAssignmentElimination(true);
            this.options_.setInlineConstantVars(true);
            this.options_.setInlineFunctions(true);
            this.options_.setInlineLocalFunctions(true);
            this.options_.setCrossModuleCodeMotion(true);
            this.options_.setCoalesceVariableNames(true);
            this.options_.setCrossModuleMethodMotion(true);
            this.options_.setInlineProperties(true);
            this.options_.setInlineVariables(true);
            this.options_.setSmartNameRemoval(true);
            this.options_.setRemoveDeadCode(true);
            this.options_.setExtractPrototypeMemberDeclarations(true);
            this.options_.setRemoveUnusedPrototypeProperties(true);
            this.options_.setRemoveUnusedPrototypePropertiesInExterns(false);
            this.options_.setRemoveUnusedClassProperties(true);
            this.options_.setRemoveUnusedVariables(CompilerOptions.Reach.ALL);
            this.options_.setCollapseVariableDeclarations(true);
            this.options_.setCollapseAnonymousFunctions(true);
            this.options_.setAliasAllStrings(true);
            this.options_.setConvertToDottedProperties(true);
            this.options_.setRewriteFunctionExpressions(true);
            this.options_.setOptimizeParameters(true);
            this.options_.setOptimizeReturns(true);
            this.options_.setOptimizeCalls(true);
            this.options_.setOptimizeArgumentsArray(true);
            this.options_.setGenerateExports(true);
            this.options_.setExportLocalPropertyDefinitions(true);
            DependencyOptions dopts = new DependencyOptions();
            ArrayList<ModuleIdentifier> entryPoints = new ArrayList<ModuleIdentifier>();
            entryPoints.add(ModuleIdentifier.forClosure((String)projectName));
            dopts.setDependencyPruning(manageDependencies).setDependencySorting(manageDependencies).setMoocherDropping(manageDependencies).setEntryPoints(entryPoints);
            this.options_.setDependencyOptions(dopts);
            this.options_.setWarningLevel(DiagnosticGroups.ACCESS_CONTROLS, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.CONST, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.CONSTANT_PROPERTY, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.STRICT_MODULE_DEP_CHECK, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.VISIBILITY, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.DEPRECATED, CheckLevel.OFF);
            this.options_.setWarningLevel(DiagnosticGroups.AMBIGUOUS_FUNCTION_DECL, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.CHECK_EVENTFUL_OBJECT_DISPOSAL, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.MISSING_PROVIDE, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.CHECK_REGEXP, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.CHECK_TYPES, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.CHECK_USELESS_CODE, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.CHECK_VARIABLES, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.DEBUGGER_STATEMENT_PRESENT, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.DUPLICATE_MESSAGE, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.DUPLICATE_VARS, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.ES3, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.ES5_STRICT, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.EXTERNS_VALIDATION, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.GLOBAL_THIS, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.FILEOVERVIEW_JSDOC, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.INTERNET_EXPLORER_CHECKS, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.INVALID_CASTS, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.LINT_CHECKS, CheckLevel.OFF);
            this.options_.setWarningLevel(DiagnosticGroups.MISPLACED_TYPE_ANNOTATION, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.MISSING_PROPERTIES, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.MISSING_PROVIDE, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.MISSING_REQUIRE, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.MISSING_RETURN, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.NEW_CHECK_TYPES, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.NON_STANDARD_JSDOC, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.REPORT_UNKNOWN_TYPES, CheckLevel.OFF);
            this.options_.setWarningLevel(DiagnosticGroups.SUSPICIOUS_CODE, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.TWEAKS, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.TYPE_INVALIDATION, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.UNDEFINED_NAMES, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.UNDEFINED_VARIABLES, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.UNKNOWN_DEFINES, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.USE_OF_GOOG_BASE, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.VIOLATED_MODULE_DEP, CheckLevel.WARNING);
            this.options_.setWarningLevel(DiagnosticGroups.DEPRECATED_ANNOTATIONS, CheckLevel.OFF);
            this.options_.setWarningLevel(FlexJSDiagnosticGroups.FLEXJS_NOT_A_CONSTRUCTOR, CheckLevel.OFF);
            this.options_.setWarningLevel(FlexJSDiagnosticGroups.FLEXJS_SUPER_CALL_TO_DIFFERENT_NAME, CheckLevel.OFF);
            this.options_.setWarningLevel(FlexJSDiagnosticGroups.FLEXJS_UNKNOWN_JSDOC_TYPE_NAME, CheckLevel.OFF);
        }
        this.options_.sourceMapFormat = SourceMap.Format.V3;
        this.options_.sourceMapOutputPath = sourceMapPath + ".map";
    }

    private static class CompilerOptionsParser
    extends CommandLineRunner {
        public CompilerOptionsParser(String[] args) {
            super(args);
        }

        public CompilerOptions getOptions() {
            return this.createOptions();
        }
    }
}

