/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.js;

import org.apache.flex.compiler.codegen.IDocEmitter;
import org.apache.flex.compiler.codegen.IEmitter;
import org.apache.flex.compiler.codegen.IEmitterTokens;
import org.apache.flex.compiler.codegen.js.IJSEmitter;
import org.apache.flex.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.JSDocEmitterTokens;
import org.apache.flex.compiler.tree.as.IASNode;

public class JSDocEmitter
implements IDocEmitter,
IEmitter {
    private int currentIndent = 0;
    protected IEmitter emitter;
    private StringBuilder builder;
    private boolean bufferWrite;

    protected StringBuilder getBuilder() {
        return this.builder;
    }

    public boolean isBufferWrite() {
        return this.bufferWrite;
    }

    @Override
    public void setBufferWrite(boolean value) {
        this.bufferWrite = value;
    }

    @Override
    public String flushBuffer() {
        this.setBufferWrite(false);
        String result = this.builder.toString();
        this.builder.setLength(0);
        return result;
    }

    public JSDocEmitter(IJSEmitter emitter) {
        this.emitter = emitter;
        this.builder = new StringBuilder();
    }

    @Override
    public void indentPush() {
        ++this.currentIndent;
    }

    @Override
    public void indentPop() {
        --this.currentIndent;
    }

    @Override
    public void write(IEmitterTokens value) {
        this.write(value.getToken());
    }

    @Override
    public void write(String value) {
        if (!this.bufferWrite) {
            this.emitter.write(value);
        } else {
            this.builder.append(value);
        }
    }

    @Override
    public void writeNewline() {
        this.write(ASEmitterTokens.NEW_LINE);
    }

    @Override
    public void writeNewline(String value) {
        this.write(value);
        this.writeNewline();
    }

    @Override
    public void writeNewline(IEmitterTokens value) {
        this.writeNewline(value.getToken());
    }

    @Override
    public void writeNewline(String value, boolean pushIndent) {
        if (pushIndent) {
            this.indentPush();
        } else {
            this.indentPop();
        }
        this.write(value);
        this.writeNewline();
    }

    @Override
    public void writeNewline(IEmitterTokens value, boolean pushIndent) {
        this.writeNewline(value.getToken(), pushIndent);
    }

    @Override
    public void writeToken(IEmitterTokens value) {
        this.writeToken(value.getToken());
    }

    @Override
    public void writeToken(String value) {
        this.write(value);
        this.write(ASEmitterTokens.SPACE);
    }

    public void writeBlockClose() {
        this.write(ASEmitterTokens.BLOCK_CLOSE);
    }

    public void writeBlockOpen() {
        this.write(ASEmitterTokens.BLOCK_OPEN);
    }

    @Override
    public void begin() {
        this.writeNewline(JSDocEmitterTokens.JSDOC_OPEN);
    }

    @Override
    public void end() {
        this.write(ASEmitterTokens.SPACE);
        this.writeNewline(JSDocEmitterTokens.JSDOC_CLOSE);
    }

    @Override
    public String stringifyNode(IASNode node) {
        return null;
    }
}

