/*
 * Decompiled with CFR 0.152.
 */
package flash.util;

import flash.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

public final class FileUtils {
    private static HashMap<String, String> filemap = null;
    private static boolean checkCase = false;

    public static final String canonicalPath(String string) {
        if (string == null) {
            return null;
        }
        return FileUtils.canonicalPath(new File(string));
    }

    public static String canonicalPath(File file) {
        return FileUtils.canonicalFile(file).getPath();
    }

    public static File canonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file.getAbsoluteFile();
        }
    }

    public static synchronized String getTheRealPathBecauseCanonicalizeDoesNotFixCase(File file) {
        if (filemap == null) {
            filemap = new HashMap();
            checkCase = System.getProperty("os.name").toLowerCase().startsWith("windows");
        }
        String string = FileUtils.canonicalPath(file);
        if (!checkCase || !file.exists()) {
            return string;
        }
        if (filemap.containsKey(string)) {
            return filemap.get(string);
        }
        String string2 = file.getName();
        File file2 = new File(string);
        File file3 = new File(file2.getParent());
        String[] stringArray = file3.list();
        if (stringArray != null) {
            int n;
            int n2 = stringArray.length;
            File[] fileArray = new File[n2];
            for (n = 0; n < n2; ++n) {
                fileArray[n] = new File(file2.getPath(), stringArray[n]);
            }
            for (n = 0; n < fileArray.length; ++n) {
                if (!fileArray[n].getName().equalsIgnoreCase(string2)) continue;
                filemap.put(string, fileArray[n].getAbsolutePath());
                return fileArray[n].getAbsolutePath();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file, String string) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            StringBuilder stringBuilder = new StringBuilder((int)file.length());
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            bufferedInputStream.mark(3);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, FileUtils.consumeBOM(bufferedInputStream, string));
            char[] cArray = new char[2000];
            int n = 0;
            while ((n = ((Reader)inputStreamReader).read(cArray, 0, cArray.length)) >= 0) {
                stringBuilder.append(cArray, 0, n);
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
    }

    public static String readFile(String string, String string2) throws IOException {
        return FileUtils.readFile(new File(string), string2);
    }

    public static final String consumeBOM(InputStream inputStream, String string) throws IOException {
        return FileUtils.consumeBOM(inputStream, string, false);
    }

    public static final String consumeBOM(InputStream inputStream, String string, boolean bl) throws IOException {
        inputStream.mark(3);
        if (inputStream.read() == 239 && inputStream.read() == 187 && inputStream.read() == 191) {
            if (System.getProperty("flex.platform.CLR") != null) {
                return "UTF8";
            }
            return "UTF-8";
        }
        inputStream.reset();
        int n = inputStream.read();
        int n2 = inputStream.read();
        if (n == 255 && n2 == 254 || n == 254 && n2 == 255) {
            if (!bl) {
                inputStream.reset();
            }
            if (System.getProperty("flex.platform.CLR") != null) {
                return "UTF16";
            }
            return "UTF-16";
        }
        inputStream.reset();
        if (string != null && string.length() != 0) {
            return string;
        }
        return System.getProperty("file.encoding");
    }

    public static File getAbsoluteFile(File file) {
        File file2;
        block2: {
            file2 = null;
            try {
                file2 = file == null ? null : file.getAbsoluteFile();
            }
            catch (SecurityException securityException) {
                if (!Trace.pathResolver) break block2;
                Trace.trace(securityException.getMessage());
            }
        }
        return file2;
    }

    public static File getCanonicalFile(File file) throws IOException {
        return new File(file.getCanonicalPath());
    }

    public static File getParentFile(File file) {
        String string = file.getParent();
        if (string == null) {
            return null;
        }
        return new File(string);
    }

    public static File[] listFiles(File file) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            return null;
        }
        File[] fileArray = new File[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            fileArray[i] = new File(file.getPath(), stringArray[i]);
        }
        return fileArray;
    }

    public static File[] listFiles(File file, FilenameFilter filenameFilter) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            return null;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (filenameFilter != null && !filenameFilter.accept(file, stringArray[i])) continue;
            arrayList.add(new File(file.getPath(), stringArray[i]));
        }
        return arrayList.toArray(new File[0]);
    }

    public static URL toURL(File file) throws MalformedURLException {
        String string = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!string.endsWith("/") && file.isDirectory()) {
            string = string + "/";
        }
        return new URL("file", "", string);
    }

    public static String addPathComponents(String string, String string2, char c) {
        int n;
        int n2;
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        for (n2 = string.length() - 1; n2 >= 0 && string.charAt(n2) == c; --n2) {
        }
        for (n = 0; n < string2.length() && string2.charAt(n) == c; ++n) {
        }
        String string3 = string.substring(0, n2 + 1);
        String string4 = string2.substring(n);
        String string5 = "";
        if (string3.length() > 0 && string4.length() > 0) {
            string5 = string5 + c;
        }
        return string3 + string5 + string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean renameFile(File file, File file2) {
        Object object;
        if (!file.exists()) {
            return false;
        }
        long l = file.length();
        try {
            if (file2.exists() && !file2.delete()) {
                object = new File(file2.getAbsolutePath() + ".old");
                if (((File)object).exists()) {
                    ((File)object).delete();
                }
                if (file2.renameTo((File)object) && ((File)object).delete()) {
                    // empty if block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (file.renameTo(file2)) {
                return true;
            }
            object = new BufferedInputStream(new FileInputStream(file));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            byte[] byArray = new byte[8192];
            try {
                int n;
                for (long i = file.length(); i > 0L; i -= (long)n) {
                    n = ((FilterInputStream)object).read(byArray);
                    if (n < 0) {
                        boolean bl = false;
                        return bl;
                    }
                    bufferedOutputStream.write(byArray, 0, n);
                    bufferedOutputStream.flush();
                }
            }
            finally {
                ((BufferedInputStream)object).close();
                bufferedOutputStream.close();
            }
            long l2 = file2.length();
            if (l2 != l) return false;
            file.delete();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        byte[] byArray = new byte[8192];
        int n = 0;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        try {
            while ((n = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            if (Trace.error) {
                iOException.printStackTrace();
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);){
            int n2 = 0;
            for (int i = 0; n2 >= 0 && i < byArray.length; i += n2) {
                n2 = bufferedInputStream.read(byArray, i, byArray.length - i);
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeClassToFile(String string, String string2, String string3, String string4) throws IOException {
        String string5 = string2.replace('.', File.separatorChar);
        String string6 = FileUtils.addPathComponents(string, string5, File.separatorChar);
        new File(string6).mkdirs();
        String string7 = FileUtils.addPathComponents(string6, string3, File.separatorChar);
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string7), "UTF-8"));
            bufferedWriter.write(string4);
            bufferedWriter.flush();
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean isAbsolute(File file) {
        boolean bl;
        block2: {
            bl = false;
            try {
                bl = file.isAbsolute();
            }
            catch (SecurityException securityException) {
                if (!Trace.pathResolver) break block2;
                Trace.trace(securityException.getMessage());
            }
        }
        return bl;
    }

    public static boolean exists(File file) {
        boolean bl;
        block2: {
            bl = false;
            try {
                bl = file.exists();
            }
            catch (SecurityException securityException) {
                if (!Trace.pathResolver) break block2;
                Trace.trace(securityException.getMessage());
            }
        }
        return bl;
    }

    public static boolean isFile(File file) {
        boolean bl;
        block2: {
            bl = false;
            try {
                bl = file.isFile();
            }
            catch (SecurityException securityException) {
                if (!Trace.pathResolver) break block2;
                Trace.trace(securityException.getMessage());
            }
        }
        return bl;
    }

    public static boolean isDirectory(File file) {
        boolean bl;
        block2: {
            bl = false;
            try {
                bl = file.isDirectory();
            }
            catch (SecurityException securityException) {
                if (!Trace.pathResolver) break block2;
                Trace.trace(securityException.getMessage());
            }
        }
        return bl;
    }
}

