/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.tree.mxml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.flex.compiler.common.IEmbedResolver;
import org.apache.flex.compiler.common.ISourceLocation;
import org.apache.flex.compiler.definitions.IClassDefinition;
import org.apache.flex.compiler.exceptions.CodegenInterruptedException;
import org.apache.flex.compiler.internal.projects.ASProject;
import org.apache.flex.compiler.internal.projects.FlexProject;
import org.apache.flex.compiler.internal.tree.as.NodeBase;
import org.apache.flex.compiler.internal.tree.mxml.MXMLCompilerDirectiveNodeBase;
import org.apache.flex.compiler.internal.tree.mxml.MXMLFileNode;
import org.apache.flex.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.flex.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.flex.compiler.internal.units.EmbedCompilationUnit;
import org.apache.flex.compiler.internal.units.EmbedCompilationUnitFactory;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.mxml.IMXMLEmbedNode;
import org.apache.flex.compiler.tree.mxml.IMXMLFileNode;
import org.apache.flex.compiler.units.ICompilationUnit;
import org.apache.flex.utils.FilenameNormalization;

class MXMLEmbedNode
extends MXMLCompilerDirectiveNodeBase
implements IMXMLEmbedNode,
IEmbedResolver {
    private String containingSourceFilename = null;

    MXMLEmbedNode(MXMLNodeBase parent) {
        super(parent);
        if (parent != null) {
            this.setContainingSourceFilename();
        }
    }

    @Override
    public void setParent(NodeBase parent) {
        super.setParent(parent);
        if (parent != null) {
            this.setContainingSourceFilename();
        }
    }

    private void setContainingSourceFilename() {
        IMXMLFileNode fileNode = (IMXMLFileNode)this.getAncestorOfType(IMXMLFileNode.class);
        this.containingSourceFilename = FilenameNormalization.normalize(fileNode.getSourcePath());
    }

    @Override
    public void initializeFromText(MXMLTreeBuilder builder, String text, ISourceLocation location) {
        this.parseTextAndSetAttributes(builder, text, location, "Embed");
        MXMLFileNode fileNode = builder.getFileNode();
        fileNode.addEmbedNode(this);
    }

    @Override
    public EmbedCompilationUnit resolveCompilationUnit(ICompilerProject project, Collection<ICompilerProblem> problems) throws InterruptedException {
        assert (project instanceof ASProject);
        return EmbedCompilationUnitFactory.getCompilationUnit((ASProject)project, this.containingSourceFilename, this, this.attributes, problems);
    }

    @Override
    public EmbedCompilationUnit resolveCompilationUnit(ICompilerProject project) throws InterruptedException {
        assert (project instanceof ASProject);
        ArrayList ignoredProblems = new ArrayList();
        return this.resolveCompilationUnit(project, (Collection)ignoredProblems);
    }

    @Override
    public IClassDefinition getClassReference(ICompilerProject project) {
        IClassDefinition classReference = super.getClassReference(project);
        if (classReference != null) {
            return classReference;
        }
        try {
            LinkedList problems = new LinkedList();
            ICompilationUnit cu = this.resolveCompilationUnit(project, (Collection)problems);
            if (cu == null) {
                return null;
            }
            this.setClassReference((FlexProject)project, ((EmbedCompilationUnit)cu).getName());
        }
        catch (InterruptedException e) {
            throw new CodegenInterruptedException(e);
        }
        return super.getClassReference(project);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLEmbedID;
    }

    @Override
    public String getName() {
        return "Embed";
    }
}

