/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.tree.mxml;

import org.apache.flex.compiler.common.ISourceLocation;
import org.apache.flex.compiler.constants.IASLanguageConstants;
import org.apache.flex.compiler.definitions.ITypeDefinition;
import org.apache.flex.compiler.internal.projects.FlexProject;
import org.apache.flex.compiler.internal.tree.as.NodeBase;
import org.apache.flex.compiler.internal.tree.mxml.MXMLCompilerDirectiveNodeBase;
import org.apache.flex.compiler.internal.tree.mxml.MXMLEmbedNode;
import org.apache.flex.compiler.internal.tree.mxml.MXMLInstanceNode;
import org.apache.flex.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.flex.compiler.internal.tree.mxml.MXMLResourceNode;
import org.apache.flex.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.flex.compiler.problems.EmbedTypeNotEmbeddableProblem;
import org.apache.flex.compiler.problems.MXMLUnrecognizedCompilerDirectiveProblem;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.tree.mxml.IMXMLNode;

class MXMLCompilerDirectiveParser {
    MXMLCompilerDirectiveParser() {
    }

    public static MXMLInstanceNode parse(MXMLTreeBuilder builder, IMXMLNode parent, ISourceLocation location, String text, ITypeDefinition type) {
        String atFunctionName = MXMLCompilerDirectiveParser.getAtFunctionName(text);
        if (atFunctionName == null) {
            return null;
        }
        String trimmedText = builder.getMXMLDialect().trim(text);
        return MXMLCompilerDirectiveParser.parseAtFunction(builder, parent, location, atFunctionName, trimmedText, type);
    }

    private static String getAtFunctionName(String value) {
        int openParen;
        if ((value = value.trim()).length() > 1 && value.charAt(0) == '@' && (openParen = value.indexOf(40)) > 1 && value.indexOf(41) > openParen) {
            return value.substring(1, openParen);
        }
        return null;
    }

    private static MXMLCompilerDirectiveNodeBase parseAtFunction(MXMLTreeBuilder builder, IMXMLNode parent, ISourceLocation location, String functionName, String text, ITypeDefinition type) {
        MXMLCompilerDirectiveNodeBase result = null;
        if ("Embed".equals(functionName)) {
            FlexProject project = builder.getProject();
            ITypeDefinition stringType = project.getBuiltinType(IASLanguageConstants.BuiltinType.STRING);
            ITypeDefinition classType = project.getBuiltinType(IASLanguageConstants.BuiltinType.CLASS);
            ITypeDefinition anyType = project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE);
            if (stringType.isInstanceOf(type, (ICompilerProject)project) || classType.isInstanceOf(type, (ICompilerProject)project) || type == anyType) {
                result = new MXMLEmbedNode((MXMLNodeBase)parent);
                result.initializeFromText(builder, text, location);
            } else {
                EmbedTypeNotEmbeddableProblem problem = new EmbedTypeNotEmbeddableProblem(location, type.getBaseName());
                builder.addProblem(problem);
            }
        } else if ("Resource".equals(functionName)) {
            result = new MXMLResourceNode((NodeBase)((Object)parent), type);
            result.initializeFromText(builder, text, location);
        } else {
            builder.addProblem(new MXMLUnrecognizedCompilerDirectiveProblem(location, functionName));
        }
        if (result != null) {
            result.setSourceLocation(location);
        }
        return result;
    }
}

